/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.yirmiri.dungeonsdelight.common.item.BiteableItem;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class BubblegunkItem
extends BiteableItem {
    private final int hungerReduction;
    private final boolean hasFoodEffectTooltip;

    public BubblegunkItem(Item.Properties properties, int hungerReduction, boolean hasPotionEffectTooltip) {
        super(properties, hasPotionEffectTooltip);
        this.hungerReduction = hungerReduction;
        this.hasFoodEffectTooltip = hasPotionEffectTooltip;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            tooltip.add((Component)TextUtils.getTranslation((String)"tooltip.bubblegunk", (Object[])new Object[0]).m_130940_(ChatFormatting.BLUE));
            if (this.hasFoodEffectTooltip) {
                TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip, (float)1.0f);
            }
        }
    }

    @Override
    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity consumer) {
        Player player = consumer instanceof Player ? (Player)consumer : null;
        player.m_36324_().m_38705_(player.m_36324_().m_38702_() - this.hungerReduction);
        if (player.m_36324_().m_38702_() < 0) {
            player.m_36324_().m_38705_(0);
        }
        return super.m_5922_(stack, level, consumer);
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public SoundEvent m_6023_() {
        return SoundEvents.f_11969_;
    }

    public SoundEvent m_6061_() {
        return SoundEvents.f_11969_;
    }
}

