/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client.gui;

import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemAPI;
import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterScreen;
import dev.ftb.mods.ftbfiltersystem.client.FTBFilterSystemClient;
import dev.ftb.mods.ftbfiltersystem.client.gui.AbstractItemEditorConfigScreen;
import dev.ftb.mods.ftbfiltersystem.client.gui.widget.CustomStringWidget;
import dev.ftb.mods.ftbfiltersystem.filter.ExpressionFilter;
import dev.ftb.mods.ftbfiltersystem.registry.item.SmartFilterItem;
import dev.ftb.mods.ftbfiltersystem.util.FilterParser;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ExpressionConfigScreen
extends AbstractItemEditorConfigScreen<ExpressionFilter> {
    private EditBox customEditBox;

    public ExpressionConfigScreen(ExpressionFilter filter, AbstractFilterScreen parentScreen) {
        super(filter, parentScreen, 320, 176);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.editBox.m_240159_(((ExpressionFilter)this.filter).getExpression());
        MutableComponent text = Component.m_237115_((String)"ftbfiltersystem.gui.custom_name");
        this.m_142416_((GuiEventListener)CustomStringWidget.withText(this.leftPos + 180, this.topPos + 110, (Component)text, this.f_96547_).m_269033_(0x404040));
        Objects.requireNonNull(this.f_96547_);
        Objects.requireNonNull(this.f_96547_);
        this.customEditBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.leftPos + 180, this.topPos + 110 + 9 + 4, this.guiWidth - 190, 9 + 6, (Component)Component.m_237119_()));
        this.customEditBox.m_94144_(((ExpressionFilter)this.filter).getCustomName());
    }

    @Override
    @Nullable
    protected ExpressionFilter makeNewFilter() {
        try {
            String str = this.customEditBox.m_94155_().isEmpty() ? this.editBox.m_239249_() : this.editBox.m_239249_() + "/" + this.customEditBox.m_94155_();
            return new ExpressionFilter(((ExpressionFilter)this.filter).getParent(), str);
        }
        catch (FilterException e) {
            return null;
        }
    }

    @Override
    protected void onItemWidgetClicked() {
        this.customEditBox.m_94144_(this.customHoverName == null ? "" : this.customHoverName.getString());
    }

    @Override
    protected Predicate<ItemStack> inventoryChecker() {
        return stack -> stack.m_41782_() && FTBFilterSystemAPI.api().isFilterItem((ItemStack)stack) && !FTBFilterSystemClient.isPlayerHolding(stack);
    }

    @Override
    protected String serialize(ItemStack stack) {
        return SmartFilterItem.getFilterString(stack);
    }

    @Override
    protected void doScheduledUpdate() {
        if (this.editBox.m_239249_().isEmpty()) {
            this.setStatus(true, (Component)Component.m_237119_(), null);
        } else {
            try {
                FilterParser.parse(this.editBox.m_239249_());
                this.setStatus(true, (Component)Component.m_237115_((String)"ftbfiltersystem.gui.filter_ok"), null);
            }
            catch (FilterException e) {
                this.setStatus(false, (Component)Component.m_237115_((String)"ftbfiltersystem.gui.filter_bad"), e.getMessage());
            }
        }
    }
}

