/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.filter;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemAPI;
import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import dev.ftb.mods.ftbfiltersystem.api.filter.AbstractSmartFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import dev.ftb.mods.ftbfiltersystem.util.NBTUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NbtFilter
extends AbstractSmartFilter {
    public static final ResourceLocation ID = FTBFilterSystemAPI.rl("nbt");
    protected final CompoundTag tag;
    private final boolean fuzzyMatch;

    public NbtFilter(@Nullable SmartFilter.Compound parent) {
        this(parent, true, new CompoundTag());
    }

    public NbtFilter(SmartFilter.Compound parent, boolean fuzzyMatch, CompoundTag tag) {
        super(parent);
        this.fuzzyMatch = fuzzyMatch;
        this.tag = tag;
    }

    @NotNull
    public static String getNBTPrefix(boolean fuzzy) {
        return fuzzy ? "fuzzy:" : "strict:";
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.tag.m_128456_() ? stack.m_41783_() == null || stack.m_41783_().m_128456_() : (this.fuzzyMatch ? this.fuzzyMatch(stack.m_41783_()) : this.tag.equals((Object)stack.m_41783_()));
    }

    private boolean fuzzyMatch(CompoundTag toMatch) {
        return this.tag != null && NBTUtil.compareNbt((Tag)this.tag, (Tag)toMatch, true, true);
    }

    @Override
    public String getStringArg() {
        return NbtFilter.getNBTPrefix(this.fuzzyMatch) + this.tag.toString();
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public boolean isFuzzyMatch() {
        return this.fuzzyMatch;
    }

    public static NbtFilter fromString(SmartFilter.Compound parent, String str) {
        try {
            boolean fuzzy = true;
            if (str.startsWith("strict:") || str.startsWith("fuzzy:")) {
                fuzzy = str.startsWith("fuzzy:");
                str = str.substring(str.indexOf(58) + 1);
            }
            return new NbtFilter(parent, fuzzy, NbtFilter.parseNBT(str));
        }
        catch (CommandSyntaxException e) {
            throw new FilterException("invalid NBT tag: " + str, e);
        }
    }

    private static CompoundTag parseNBT(String str) throws CommandSyntaxException {
        if (!((String)str).startsWith("{") && !((String)str).endsWith("}")) {
            str = "{" + (String)str + "}";
        }
        return TagParser.m_129359_((String)str);
    }
}

