/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture.types.connecting;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.SpriteCreationContext;
import com.supermartijn642.fusion.api.texture.SpritePreparationContext;
import com.supermartijn642.fusion.api.texture.TextureErrorException;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureData;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureLayout;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureSprite;
import com.supermartijn642.fusion.texture.types.connecting.layouts.ConnectingTextureLayoutHandler;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.util.Mth;

public class ConnectingTextureType
implements TextureType<ConnectingTextureData> {
    @Override
    public ConnectingTextureData deserialize(JsonObject json) throws JsonParseException {
        BaseTextureData base = (BaseTextureData)DefaultTextureTypes.BASE.deserialize(json);
        ConnectingTextureData.Builder builder = ConnectingTextureData.builder();
        builder.renderType(base.getRenderType());
        builder.emissive(base.isEmissive());
        builder.tinting(base.getTinting());
        if (json.has("layout")) {
            ConnectingTextureLayout layout;
            if (!json.get("layout").isJsonPrimitive() || !json.getAsJsonPrimitive("layout").isString()) {
                throw new JsonParseException("Property 'layout' must be a string!");
            }
            String layoutString = json.get("layout").getAsString();
            try {
                layout = ConnectingTextureLayout.valueOf(layoutString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Property 'layout' must be one of " + Arrays.toString((Object[])ConnectingTextureLayout.values()).toLowerCase(Locale.ROOT) + ", not '" + layoutString + "'!");
            }
            builder.layout(layout);
        }
        return (ConnectingTextureData)builder.build();
    }

    @Override
    public JsonObject serialize(ConnectingTextureData data) {
        JsonObject json = DefaultTextureTypes.BASE.serialize(data);
        if (data.getLayout() != ConnectingTextureLayout.FULL) {
            json.addProperty("layout", data.getLayout().name().toLowerCase(Locale.ROOT));
        }
        return json.size() == 0 ? null : json;
    }

    @Override
    public Pair<Integer, Integer> getFrameSize(SpritePreparationContext context, ConnectingTextureData data) {
        if (data.getLayout() == ConnectingTextureLayout.FULL && context.getTextureWidth() == context.getTextureHeight()) {
            return Pair.of(context.getTextureWidth(), context.getTextureHeight() * 6 / 8);
        }
        if (context.getAnimationMetadata() != null) {
            Pair<Integer, Integer> frameSize;
            AnimationMetadataSection animation = context.getAnimationMetadata();
            if (animation.f_119014_ != -1 && animation.f_119015_ != -1) {
                frameSize = Pair.of(animation.f_119014_, animation.f_119015_);
            } else if (animation.f_119014_ != -1) {
                frameSize = Pair.of(animation.f_119014_, context.getTextureHeight());
            } else if (animation.f_119015_ != -1) {
                frameSize = Pair.of(context.getTextureWidth(), animation.f_119015_);
            } else {
                ConnectingTextureLayoutHandler handler = ConnectingTextureLayoutHandler.get(data.getLayout());
                int height = Math.min(context.getTextureWidth() / handler.getWidth() * handler.getHeight(), context.getTextureHeight());
                frameSize = Pair.of(context.getTextureWidth(), height);
            }
            if (!Mth.m_264612_((int)context.getTextureWidth(), (int)frameSize.left()) || !Mth.m_264612_((int)context.getTextureHeight(), (int)frameSize.right())) {
                throw new TextureErrorException("Image size " + context.getTextureWidth() + "x" + context.getTextureHeight() + " is not a multiple of frame size " + frameSize.left() + "x" + frameSize.right() + "!");
            }
            return frameSize;
        }
        return Pair.of(context.getTextureWidth(), context.getTextureHeight());
    }

    @Override
    public TextureAtlasSprite createSprite(SpriteCreationContext context, ConnectingTextureData data) {
        ConnectingTextureLayoutHandler layoutHandler = ConnectingTextureLayoutHandler.get(data.getLayout());
        TextureAtlasSprite sprite = context.createOriginalSprite();
        float startU = sprite.f_118351_;
        float startV = sprite.f_118353_;
        float tileWidth = (sprite.f_118352_ - sprite.f_118351_) / (float)layoutHandler.getWidth();
        float tileHeight = (sprite.f_118354_ - sprite.f_118353_) / (float)layoutHandler.getHeight();
        sprite.f_118352_ = sprite.f_118351_ + tileWidth * (float)(layoutHandler.defaultTileX() + 1);
        sprite.f_118354_ = sprite.f_118353_ + tileHeight * (float)(layoutHandler.defaultTileY() + 1);
        sprite.f_118351_ += tileWidth * (float)layoutHandler.defaultTileX();
        sprite.f_118353_ += tileHeight * (float)layoutHandler.defaultTileY();
        return new ConnectingTextureSprite(sprite, data, startU, startV);
    }
}

