/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.eroding_boulder;

import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEffects;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEntities;
import com.gametechbc.gtbcs_geomancy_plus.init.GGSpells;
import com.gametechbc.gtbcs_geomancy_plus.network.ClientboundEarthExplosionParticles;
import com.gametechbc.gtbcs_geomancy_plus.setup.GGInstanceMessages;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ErodingBoulderEntity
extends AbstractMagicProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Float> BLAST_RADIUS = SynchedEntityData.m_135353_(ErodingBoulderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int effectAmplifier = 0;
    private static final RawAnimation IDLE_LOOP_ANIM = RawAnimation.begin().thenLoop("idle_loop");
    private final AnimationController<ErodingBoulderEntity> controller = new AnimationController((GeoAnimatable)this, "boulder_controller", 0, this::animationPredicate);

    public ErodingBoulderEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ErodingBoulderEntity(Level pLevel, LivingEntity pShooter) {
        this((EntityType<? extends Projectile>)((EntityType)GGEntities.ERODING_BOULDER.get()), pLevel);
        this.m_5602_((Entity)pShooter);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BLAST_RADIUS, (Object)Float.valueOf(3.0f));
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("BlastRadius", this.getBlastRadius());
        tag.m_128405_("EffectAmplifier", this.effectAmplifier);
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("BlastRadius")) {
            this.setBlastRadius(tag.m_128457_("BlastRadius"));
        }
        if (tag.m_128441_("EffectAmplifier")) {
            this.effectAmplifier = tag.m_128451_("EffectAmplifier");
        }
    }

    public float getBlastRadius() {
        return ((Float)this.f_19804_.m_135370_(BLAST_RADIUS)).floatValue();
    }

    public void setBlastRadius(float radius) {
        this.f_19804_.m_135381_(BLAST_RADIUS, (Object)Float.valueOf(radius));
    }

    public int getEffectAmplifier() {
        return this.effectAmplifier;
    }

    public void setEffectAmplifier(int amplifier) {
        this.effectAmplifier = amplifier;
    }

    protected void m_6532_(HitResult hitResult) {
        if (!this.m_9236_().f_46443_) {
            float explosionRadius = this.getBlastRadius();
            float explosionRadiusSqr = explosionRadius * explosionRadius;
            List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_((double)explosionRadius));
            Vec3 losPoint = Utils.raycastForBlock((Level)this.m_9236_(), (Vec3)this.m_20182_(), (Vec3)this.m_20182_().m_82520_(0.0, 2.0, 0.0), (ClipContext.Fluid)ClipContext.Fluid.NONE).m_82450_();
            for (Entity entity : entities) {
                double distanceSqr = entity.m_20238_(hitResult.m_82450_());
                if (!(distanceSqr < (double)explosionRadiusSqr) || !this.m_5603_(entity) || !Utils.hasLineOfSight((Level)this.m_9236_(), (Vec3)losPoint, (Vec3)entity.m_20191_().m_82399_(), (boolean)true)) continue;
                double p = 1.0 - distanceSqr / (double)explosionRadiusSqr;
                float damage = (float)((double)this.damage * p);
                DamageSources.applyDamage((Entity)entity, (float)damage, (DamageSource)((AbstractSpell)GGSpells.ERODING_BOULDER_SPELL.get()).getDamageSource((Entity)this, this.m_19749_()));
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)GGEffects.ERODE_EFFECT.get(), 100, this.getEffectAmplifier(), false, false, false));
            }
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)GGSchools.GEO.get()).getTargetingColor(), explosionRadius), (double)this.m_20185_(), (double)(this.m_20186_() + (double)0.165f), (double)this.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
            GGInstanceMessages.sendToPlayersTrackingEntity(new ClientboundEarthExplosionParticles(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), explosionRadius), (Entity)this);
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_1.get(), 2.7f, 1.0f);
            this.m_146870_();
        }
    }

    public void trailParticles() {
        Vec3 vec3 = this.m_20184_();
        double d0 = this.m_20185_() - vec3.f_82479_;
        double d1 = this.m_20186_() - vec3.f_82480_;
        double d2 = this.m_20189_() - vec3.f_82481_;
        int count = Mth.m_14045_((int)((int)(vec3.m_82556_() * 4.0)), (int)1, (int)4);
        BlockState dirtBlock = Blocks.f_50493_.m_49966_();
        for (int i = 0; i < count; ++i) {
            Vec3 random = Utils.getRandomVec3((double)0.25);
            float f = (float)i / (float)count;
            double x = Mth.m_14139_((double)f, (double)d0, (double)this.m_20185_());
            double y = Mth.m_14139_((double)f, (double)d1, (double)this.m_20186_());
            double z = Mth.m_14139_((double)f, (double)d2, (double)this.m_20189_());
            if (dirtBlock.m_60799_() == RenderShape.INVISIBLE) continue;
            this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, dirtBlock), x - random.f_82479_, y + 0.5 - random.f_82480_, z - random.f_82481_, random.f_82479_ * 0.5, random.f_82480_ * 0.5, random.f_82481_ * 0.5);
        }
    }

    public void impactParticles(double x, double y, double z) {
    }

    public float getSpeed() {
        return 1.15f;
    }

    public Optional<SoundEvent> getImpactSound() {
        return Optional.of((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_1.get());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.controller});
    }

    private PlayState animationPredicate(AnimationState<ErodingBoulderEntity> state) {
        state.getController().setAnimation(IDLE_LOOP_ANIM);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

