/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonate_pillar;

import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.api.entity.IResonanceEntity;
import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.api.util.GGGeneralUtil;
import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.resonate_pillar.ResonatePillarParticleManager;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEffects;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEntities;
import com.gametechbc.gtbcs_geomancy_plus.init.GGSpells;
import com.gametechbc.gtbcs_geomancy_plus.util.GGTags;
import com.gametechbc.spelllib.entity.misc.GSLScreenShakeEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ResonatePillarEntity
extends Entity
implements GeoEntity,
AntiMagicSusceptible {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.m_135353_(ResonatePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_AGE = SynchedEntityData.m_135353_(ResonatePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_MAX_AGE = SynchedEntityData.m_135353_(ResonatePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_STAGE = SynchedEntityData.m_135353_(ResonatePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_SHOCKWAVE_RADIUS = SynchedEntityData.m_135353_(ResonatePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_EMISSIVE_BRIGHTNESS = SynchedEntityData.m_135353_(ResonatePillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private UUID summonerUUID;
    private LivingEntity cachedSummoner;
    private int lastShockwaveAge = 0;
    private int lastStage1ShockwaveAge = -30;
    private int lastStage2ShockwaveAge = -20;
    private int lastStage3ShockwaveAge = -10;
    private int secondBlastwaveAge = -1;
    private int erodeAmplifier = 0;
    private float targetEmissiveBrightness = 0.0f;
    private final RawAnimation IDLE_BLANK_ANIMATION = RawAnimation.begin().thenLoop("idle_blank");
    private final RawAnimation PILLAR_RISE_ANIMATION = RawAnimation.begin().thenPlay("pillar_rise");
    private final RawAnimation PILLAR_DIE_ANIMATION = RawAnimation.begin().thenPlay("pillar_die");
    private final AnimationController<ResonatePillarEntity> controller = new AnimationController((GeoAnimatable)this, "pillar_controller", 0, this::animationPredicate);

    public ResonatePillarEntity(EntityType<? extends Entity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ResonatePillarEntity(Level level, LivingEntity summoner) {
        this((EntityType<? extends Entity>)((EntityType)GGEntities.RESONATE_PILLAR.get()), level);
        this.setSummoner(summoner);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_DAMAGE, (Object)Float.valueOf(8.0f));
        this.f_19804_.m_135372_(DATA_AGE, (Object)0);
        this.f_19804_.m_135372_(DATA_MAX_AGE, (Object)600);
        this.f_19804_.m_135372_(DATA_STAGE, (Object)0);
        this.f_19804_.m_135372_(DATA_SHOCKWAVE_RADIUS, (Object)Float.valueOf(6.0f));
        this.f_19804_.m_135372_(DATA_EMISSIVE_BRIGHTNESS, (Object)Float.valueOf(0.0f));
    }

    public void m_7380_(CompoundTag tag) {
        tag.m_128350_("Damage", this.getDamage());
        tag.m_128405_("Age", this.getAge());
        tag.m_128405_("MaxAge", this.getMaxAge());
        tag.m_128405_("Stage", this.getStageValue());
        tag.m_128350_("ShockwaveRadius", this.getShockwaveRadius());
        tag.m_128405_("LastShockwaveAge", this.lastShockwaveAge);
        tag.m_128350_("EmissiveBrightness", this.getEmissiveBrightness());
        tag.m_128405_("ErodeAmplifier", this.getErodeAmplifier());
        if (this.summonerUUID != null) {
            tag.m_128362_("Summoner", this.summonerUUID);
        }
    }

    public void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("Age")) {
            this.setAge(tag.m_128451_("Age"));
        }
        if (tag.m_128441_("MaxAge")) {
            this.setMaxAge(tag.m_128451_("MaxAge"));
        }
        if (tag.m_128441_("Damage")) {
            this.setDamage(tag.m_128457_("Damage"));
        }
        if (tag.m_128441_("Stage")) {
            this.setStage(Stage.fromValue(tag.m_128451_("Stage")));
        }
        if (tag.m_128441_("ShockwaveRadius")) {
            this.setShockwaveRadius(tag.m_128457_("ShockwaveRadius"));
        }
        if (tag.m_128441_("LastShockwaveAge")) {
            this.lastShockwaveAge = tag.m_128451_("LastShockwaveAge");
        }
        if (tag.m_128441_("EmissiveBrightness")) {
            this.setEmissiveBrightness(tag.m_128457_("EmissiveBrightness"));
        }
        if (tag.m_128441_("ErodeAmplifier")) {
            this.setErodeAmplifier(tag.m_128451_("ErodeAmplifier"));
        }
        if (tag.m_128403_("Summoner")) {
            this.summonerUUID = tag.m_128342_("Summoner");
        }
    }

    public int getAge() {
        return (Integer)this.f_19804_.m_135370_(DATA_AGE);
    }

    public void setAge(int age) {
        this.f_19804_.m_135381_(DATA_AGE, (Object)age);
    }

    public int getMaxAge() {
        return (Integer)this.f_19804_.m_135370_(DATA_MAX_AGE);
    }

    public void setMaxAge(int maxAge) {
        this.f_19804_.m_135381_(DATA_MAX_AGE, (Object)maxAge);
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DATA_DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_DAMAGE)).floatValue();
    }

    public Stage getStage() {
        return Stage.fromValue((Integer)this.f_19804_.m_135370_(DATA_STAGE));
    }

    public int getStageValue() {
        return (Integer)this.f_19804_.m_135370_(DATA_STAGE);
    }

    public void setStage(Stage stage) {
        this.f_19804_.m_135381_(DATA_STAGE, (Object)stage.value);
    }

    public float getShockwaveRadius() {
        return ((Float)this.f_19804_.m_135370_(DATA_SHOCKWAVE_RADIUS)).floatValue();
    }

    public void setShockwaveRadius(float radius) {
        this.f_19804_.m_135381_(DATA_SHOCKWAVE_RADIUS, (Object)Float.valueOf(radius));
    }

    public int getErodeAmplifier() {
        return this.erodeAmplifier;
    }

    public void setErodeAmplifier(int amplifier) {
        this.erodeAmplifier = Math.max(0, amplifier);
    }

    public float getEmissiveBrightness() {
        return ((Float)this.f_19804_.m_135370_(DATA_EMISSIVE_BRIGHTNESS)).floatValue();
    }

    public void setEmissiveBrightness(float brightness) {
        this.f_19804_.m_135381_(DATA_EMISSIVE_BRIGHTNESS, (Object)Float.valueOf(brightness));
    }

    public void setSummoner(@Nullable LivingEntity owner) {
        if (owner != null) {
            this.summonerUUID = owner.m_20148_();
            this.cachedSummoner = owner;
        }
    }

    public LivingEntity getSummoner() {
        if (this.cachedSummoner != null && this.cachedSummoner.m_6084_()) {
            return this.cachedSummoner;
        }
        if (this.summonerUUID != null && this.m_9236_() instanceof ServerLevel) {
            Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(this.summonerUUID);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.cachedSummoner = livingEntity = (LivingEntity)entity;
            }
            return this.cachedSummoner;
        }
        return null;
    }

    public void m_8119_() {
        super.m_8119_();
        int currentAge = this.getAge();
        this.setAge(currentAge + 1);
        int age = this.getAge();
        int maxAge = this.getMaxAge();
        int stageProgression = age / 10 % 4;
        this.setStage(Stage.fromValue(stageProgression));
        this.updateEmissiveBrightness();
        Vec3 currentMotion = this.m_20184_();
        double newY = this.applyArtificialGravity(currentMotion.f_82480_);
        this.m_20334_(currentMotion.f_82479_, newY, currentMotion.f_82481_);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        Vec3 motion = this.m_20184_();
        this.m_20334_(0.0, motion.f_82480_, 0.0);
        if ((age == 1 || age % 60 == 0) && this.m_20096_()) {
            this.alignToBlockCenter();
        }
        if (this.m_9236_().f_46443_) {
            ResonatePillarParticleManager.playWaterfallCascade(this.m_9236_(), this.m_20182_(), this.getAge(), 1.7);
        }
        if (age - this.lastShockwaveAge >= 40) {
            this.performOwnShockwave();
            this.lastShockwaveAge = age;
            this.secondBlastwaveAge = age + 2;
        }
        if (!this.m_9236_().f_46443_ && this.secondBlastwaveAge != -1 && age >= this.secondBlastwaveAge) {
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(GGGeneralUtil.hexToVector3f(7719759), this.getShockwaveRadius()), (double)this.m_20185_(), (double)(this.m_20186_() + (double)0.165f), (double)this.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
            this.secondBlastwaveAge = -1;
        }
        if (age - this.lastStage1ShockwaveAge >= 40) {
            this.performResonanceShockwave(Stage.STAGE_1);
            this.lastStage1ShockwaveAge = age;
        }
        if (age - this.lastStage2ShockwaveAge >= 40) {
            this.performResonanceShockwave(Stage.STAGE_2);
            this.lastStage2ShockwaveAge = age;
        }
        if (age - this.lastStage3ShockwaveAge >= 40) {
            this.performResonanceShockwave(Stage.STAGE_3);
            this.lastStage3ShockwaveAge = age;
        }
        if (age >= maxAge) {
            this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_1.get(), 4.0f, 1.0f);
            if (!this.m_9236_().f_46443_) {
                GSLScreenShakeEntity.createScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)(this.getShockwaveRadius() * 2.0f), (float)0.025f, (int)10, (int)0, (int)5, (boolean)true);
            }
            this.m_146870_();
        }
    }

    private double applyArtificialGravity(double currentY) {
        if (this.m_20096_()) {
            return Math.max(currentY * 0.8, -0.05);
        }
        double gravity = -0.1;
        double terminalVelocity = -1.5;
        double newY = currentY + gravity;
        return Math.max(newY, terminalVelocity);
    }

    private void alignToBlockCenter() {
        if (!this.m_20096_()) {
            return;
        }
        Vec3 currentPos = this.m_20182_();
        BlockPos groundBlock = this.m_20183_().m_7495_();
        BlockState groundState = this.m_9236_().m_8055_(groundBlock);
        if (groundState.m_60795_() || !groundState.m_60804_((BlockGetter)this.m_9236_(), groundBlock)) {
            return;
        }
        double centerX = (double)groundBlock.m_123341_() + 0.5;
        double centerZ = (double)groundBlock.m_123343_() + 0.5;
        double currentY = currentPos.f_82480_;
        double distanceFromCenter = Math.sqrt(Math.pow(currentPos.f_82479_ - centerX, 2.0) + Math.pow(currentPos.f_82481_ - centerZ, 2.0));
        if (distanceFromCenter > 0.1) {
            this.m_6021_(centerX, currentY, centerZ);
            Vec3 motion = this.m_20184_();
            this.m_20334_(0.0, motion.f_82480_, 0.0);
        }
    }

    private void performOwnShockwave() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        LivingEntity owner = this.getSummoner();
        float radius = this.getShockwaveRadius();
        AABB shockwaveArea = new AABB(this.m_20185_() - (double)radius, this.m_20186_() - 1.0, this.m_20189_() - (double)radius, this.m_20185_() + (double)radius, this.m_20186_() + 2.0, this.m_20189_() + (double)radius);
        this.m_9236_().m_45976_(LivingEntity.class, shockwaveArea).stream().filter(entity -> entity.m_6084_() && entity.m_19879_() != this.m_19879_() && entity != owner).filter(entity -> entity.m_20270_((Entity)this) <= radius).filter(entity -> owner == null || !GGGeneralUtil.isAlly(owner, entity) && !GGGeneralUtil.isTamed(entity)).forEach(entity -> {
            entity.f_19802_ = 0;
            DamageSources.applyDamage((Entity)entity, (float)this.getDamage(), (DamageSource)((AbstractSpell)GGSpells.PILLAR_OF_THE_RESOUNDING_EARTH.get()).getDamageSource((Entity)this, (Entity)owner));
            if (this.getErodeAmplifier() > 0) {
                entity.m_7292_(new MobEffectInstance((MobEffect)GGEffects.ERODE_EFFECT.get(), 60, this.getErodeAmplifier() - 1, false, false, true));
            }
        });
        this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_2.get(), 2.5f, 0.8f);
        GSLScreenShakeEntity.createScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)(radius * 2.0f), (float)0.01f, (int)8, (int)0, (int)4, (boolean)true);
        MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(GGGeneralUtil.hexToVector3f(7719759), this.getShockwaveRadius()), (double)this.m_20185_(), (double)(this.m_20186_() + (double)0.165f), (double)this.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
        this.createBaseShockwaveParticles();
    }

    private void performResonanceShockwave(Stage forceStage) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        int targetIndex = forceStage.value - 1;
        float baseRadius = this.getShockwaveRadius();
        float searchRadius = baseRadius * 2.0f;
        List<Entity> resonanceEntities = this.m_9236_().m_45976_(Entity.class, new AABB(this.m_20185_() - (double)searchRadius, this.m_20186_() - 20.0, this.m_20189_() - (double)searchRadius, this.m_20185_() + (double)searchRadius, this.m_20186_() + 20.0, this.m_20189_() + (double)searchRadius)).stream().filter(entity -> entity.m_19879_() != this.m_19879_()).filter(this::canResonateWith).sorted(Comparator.comparingDouble(entity -> entity.m_20270_((Entity)this))).toList();
        if (resonanceEntities.size() <= targetIndex) {
            return;
        }
        Entity resonanceEntity = resonanceEntities.get(targetIndex);
        Vec3 resonancePosition = resonanceEntity.m_20182_();
        LivingEntity owner = this.getSummoner();
        float radiusReduction = 1.0f - (float)forceStage.value * 0.15f;
        float resonanceRadius = baseRadius * radiusReduction;
        float stageMultiplier = 1.0f - (float)forceStage.value * 0.1f;
        float entityMultiplier = this.getEntityResonanceMultiplier(resonanceEntity);
        float baseDamage = this.getDamage();
        float finalDamage = baseDamage * stageMultiplier * entityMultiplier;
        if (resonanceEntity instanceof IResonanceEntity) {
            IResonanceEntity resonanceImpl = (IResonanceEntity)resonanceEntity;
            resonanceImpl.onResonanceActivated(this, forceStage, resonanceRadius, baseDamage, finalDamage, owner);
            this.createSpecialResonanceEffects(resonancePosition, forceStage);
        }
        AABB shockwaveArea = new AABB(resonancePosition.f_82479_ - (double)resonanceRadius, resonancePosition.f_82480_ - 1.0, resonancePosition.f_82481_ - (double)resonanceRadius, resonancePosition.f_82479_ + (double)resonanceRadius, resonancePosition.f_82480_ + 2.0, resonancePosition.f_82481_ + (double)resonanceRadius);
        this.m_9236_().m_45976_(LivingEntity.class, shockwaveArea).stream().filter(entity -> entity.m_6084_() && entity.m_19879_() != this.m_19879_() && entity != owner).filter(entity -> entity.m_20182_().m_82554_(resonancePosition) <= (double)resonanceRadius).filter(entity -> owner == null || !GGGeneralUtil.isAlly(owner, entity) && !GGGeneralUtil.isTamed(entity)).filter(entity -> !this.canResonateWith((Entity)entity)).forEach(entity -> {
            entity.f_19802_ = 0;
            DamageSources.applyDamage((Entity)entity, (float)finalDamage, (DamageSource)((AbstractSpell)GGSpells.PILLAR_OF_THE_RESOUNDING_EARTH.get()).getDamageSource((Entity)this, (Entity)owner));
            if (this.getErodeAmplifier() > 0) {
                entity.m_7292_(new MobEffectInstance((MobEffect)GGEffects.ERODE_EFFECT.get(), 60, this.getErodeAmplifier() - 1, false, false, true));
            }
            if (resonanceEntity instanceof IResonanceEntity) {
                IResonanceEntity resonanceImpl = (IResonanceEntity)resonanceEntity;
                double distanceFromResonanceSource = entity.m_20182_().m_82554_(resonancePosition);
                resonanceImpl.onResonanceShockwave(this, forceStage, owner, (LivingEntity)entity, this.m_9236_(), resonancePosition, resonanceRadius, distanceFromResonanceSource, baseDamage, finalDamage);
            }
        });
        this.createResonanceEffects(resonancePosition, resonanceEntity, resonanceRadius, forceStage);
    }

    private boolean canResonateWith(Entity entity) {
        if (entity.m_6095_().m_204039_(GGTags.CAN_RESONATE)) {
            return true;
        }
        if (entity instanceof IResonanceEntity) {
            IResonanceEntity resonanceEntity = (IResonanceEntity)entity;
            return resonanceEntity.canResonateWith(this);
        }
        return false;
    }

    private float getEntityResonanceMultiplier(Entity entity) {
        if (entity instanceof IResonanceEntity) {
            IResonanceEntity resonanceEntity = (IResonanceEntity)entity;
            return resonanceEntity.getResonanceMultiplier();
        }
        return 1.0f;
    }

    private void createSpecialResonanceEffects(Vec3 position, Stage stage) {
        if (!this.m_9236_().f_46443_) {
            for (int i = 0; i < 8; ++i) {
                double angle = (double)i / 8.0 * 2.0 * Math.PI;
                double radius = 2.0 + (double)stage.value * 0.5;
                double x = position.f_82479_ + Math.cos(angle) * radius;
                double z = position.f_82481_ + Math.sin(angle) * radius;
                MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)ParticleTypes.f_123809_, (double)x, (double)(position.f_82480_ + 1.0), (double)z, (int)1, (double)0.0, (double)0.1, (double)0.0, (double)0.02, (boolean)false);
            }
        }
    }

    private void createResonanceEffects(Vec3 position, Entity resonanceEntity, float radius, Stage stage) {
        GSLScreenShakeEntity.createScreenShake((Level)this.m_9236_(), (Vec3)resonanceEntity.m_20182_(), (float)this.getShockwaveRadius(), (float)0.007f, (int)6, (int)0, (int)2, (boolean)true);
        float basePitch = 0.8f;
        float stagePitch = basePitch + (float)stage.value * 0.1f;
        this.m_9236_().m_6263_(null, resonanceEntity.m_20185_(), resonanceEntity.m_20186_(), resonanceEntity.m_20189_(), (SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_SMALL.get(), SoundSource.AMBIENT, 1.5f, stagePitch);
        Vector3f particleColor = ((SchoolType)GGSchools.GEO.get()).getTargetingColor();
        if (resonanceEntity instanceof IResonanceEntity) {
            IResonanceEntity resonanceImpl = (IResonanceEntity)resonanceEntity;
            particleColor = resonanceImpl.getResonanceParticleColor();
        }
        MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(particleColor, radius), (double)position.f_82479_, (double)(position.f_82480_ + (double)0.165f), (double)position.f_82481_, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
        if (!this.m_9236_().f_46443_) {
            this.createResonanceShockwaveParticles(position, radius, stage);
        }
    }

    private void createBaseShockwaveParticles() {
        float radius = this.getShockwaveRadius();
        Vec3 center = this.m_20182_();
        float radiusScale = radius / 6.0f;
        int basaltCount = Math.round(50.0f * radiusScale);
        for (int i = 0; i < basaltCount; ++i) {
            double angle = (double)i / (double)basaltCount * 2.0 * Math.PI;
            double distance = 1.0 + this.f_19796_.m_188500_() * ((double)radius - 1.0);
            double x = center.f_82479_ + Math.cos(angle) * distance;
            double z = center.f_82481_ + Math.sin(angle) * distance;
            double y = center.f_82480_ + 0.1 + this.f_19796_.m_188500_() * 0.3;
            double velX = Math.cos(angle) * (0.3 + this.f_19796_.m_188500_() * 0.4);
            double velY = 0.1 + this.f_19796_.m_188500_() * 0.3;
            double velZ = Math.sin(angle) * (0.3 + this.f_19796_.m_188500_() * 0.4);
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50137_.m_49966_()), (double)x, (double)y, (double)z, (int)1, (double)velX, (double)velY, (double)velZ, (double)0.0, (boolean)false);
        }
        int debrisCount = Math.round(16.0f * radiusScale);
        for (int i = 0; i < debrisCount; ++i) {
            double x = center.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * (double)radius * 2.0;
            double z = center.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * (double)radius * 2.0;
            double y = center.f_82480_ + this.f_19796_.m_188500_() * 1.5;
            double velX = (this.f_19796_.m_188500_() - 0.5) * 0.2;
            double velY = this.f_19796_.m_188500_() * 0.4;
            double velZ = (this.f_19796_.m_188500_() - 0.5) * 0.2;
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50652_.m_49966_()), (double)x, (double)y, (double)z, (int)1, (double)velX, (double)velY, (double)velZ, (double)0.0, (boolean)false);
        }
        int smokeCount = Math.round(12.0f * radiusScale);
        for (int i = 0; i < smokeCount; ++i) {
            double x = center.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * (double)radius;
            double z = center.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * (double)radius;
            double y = center.f_82480_ + 0.5 + this.f_19796_.m_188500_();
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)ParticleTypes.f_123777_, (double)x, (double)y, (double)z, (int)1, (double)0.0, (double)0.02, (double)0.0, (double)0.01, (boolean)false);
        }
    }

    private void createResonanceShockwaveParticles(Vec3 center, float radius, Stage stage) {
        float radiusScale = radius / 6.0f;
        int baseParticleCount = Math.round(20.0f * radiusScale);
        int particleCount = Math.max(5, baseParticleCount - stage.value * 3);
        for (int i = 0; i < particleCount; ++i) {
            double angle = (double)i / (double)particleCount * 2.0 * Math.PI;
            double distance = 0.5 + this.f_19796_.m_188500_() * ((double)radius * 0.8);
            double x = center.f_82479_ + Math.cos(angle) * distance;
            double z = center.f_82481_ + Math.sin(angle) * distance;
            double y = center.f_82480_ + this.f_19796_.m_188500_() * 0.2;
            double velX = Math.cos(angle) * (0.2 + this.f_19796_.m_188500_() * 0.2);
            double velY = 0.05 + this.f_19796_.m_188500_() * 0.2;
            double velZ = Math.sin(angle) * (0.2 + this.f_19796_.m_188500_() * 0.2);
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50137_.m_49966_()), (double)x, (double)y, (double)z, (int)1, (double)velX, (double)velY, (double)velZ, (double)0.0, (boolean)false);
        }
        int groundCount = Math.max(2, Math.round(8.0f * radiusScale - (float)(stage.value * 2)));
        for (int i = 0; i < groundCount; ++i) {
            double x = center.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * (double)radius;
            double z = center.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * (double)radius;
            double y = center.f_82480_ - 0.3 + this.f_19796_.m_188500_() * 0.1;
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50069_.m_49966_()), (double)x, (double)y, (double)z, (int)1, (double)0.0, (double)0.1, (double)0.0, (double)0.02, (boolean)false);
        }
    }

    public void onAntiMagic(MagicData playerMagicData) {
        this.m_146870_();
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_20068_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    private PlayState animationPredicate(AnimationState<ResonatePillarEntity> event) {
        int age = this.getAge();
        int maxAge = this.getMaxAge();
        if (age <= 10) {
            event.getController().setAnimation(this.PILLAR_RISE_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (age >= maxAge - 10) {
            event.getController().setAnimation(this.PILLAR_DIE_ANIMATION);
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(this.IDLE_BLANK_ANIMATION);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private void updateEmissiveBrightness() {
        Stage currentStage = this.getStage();
        float targetBrightness = switch (currentStage) {
            case Stage.STAGE_0 -> 0.8f;
            case Stage.STAGE_1 -> 0.8f;
            case Stage.STAGE_2 -> 0.4f;
            case Stage.STAGE_3 -> 0.1f;
            default -> 0.0f;
        };
        this.targetEmissiveBrightness = targetBrightness;
        float newBrightness = this.getNewBrightness(targetBrightness);
        this.setEmissiveBrightness(newBrightness);
    }

    private float getNewBrightness(float targetBrightness) {
        float lerpSpeed = 0.15f;
        float currentBrightness = this.getEmissiveBrightness();
        float newBrightness = Mth.m_14179_((float)lerpSpeed, (float)currentBrightness, (float)targetBrightness);
        if (Math.abs(newBrightness - targetBrightness) < 0.005f) {
            newBrightness = targetBrightness;
        }
        return newBrightness;
    }

    public static enum Stage {
        STAGE_0(0),
        STAGE_1(1),
        STAGE_2(2),
        STAGE_3(3);

        public final int value;

        private Stage(int value) {
            this.value = value;
        }

        public static Stage fromValue(int value) {
            for (Stage stage : Stage.values()) {
                if (stage.value != value) continue;
                return stage;
            }
            return STAGE_0;
        }
    }
}

