/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.seismic_ride;

import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityFallingBlock;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEntities;
import com.gametechbc.spelllib.entity.misc.GSLScreenShakeEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SeismicRideEntity
extends Mob
implements GeoEntity,
AntiMagicSusceptible {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.m_135353_(SeismicRideEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_AGE = SynchedEntityData.m_135353_(SeismicRideEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_MAX_AGE = SynchedEntityData.m_135353_(SeismicRideEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_RESTING_INITIAL = SynchedEntityData.m_135353_(SeismicRideEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_RISING = SynchedEntityData.m_135353_(SeismicRideEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_RESTING_HOVER = SynchedEntityData.m_135353_(SeismicRideEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_GOING_FORWARD = SynchedEntityData.m_135353_(SeismicRideEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_GOING_DOWN = SynchedEntityData.m_135353_(SeismicRideEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> GOING_DOWN_START_AGE = SynchedEntityData.m_135353_(SeismicRideEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final float targetHoverYLevel = 25.0f;
    private static final int MINIMUM_MAX_AGE = 980;
    private float forwardSpeed = 0.3f;
    private UUID summonerUUID;
    private LivingEntity cachedSummoner;
    private final RawAnimation RIDE_BUILDING_ANIMATION = RawAnimation.begin().thenPlayAndHold("ride_building");
    private final AnimationController<SeismicRideEntity> controller = new AnimationController((GeoAnimatable)this, "seismic_ride_controller", 0, this::animationPredicate);

    public SeismicRideEntity(EntityType<? extends Mob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SeismicRideEntity(Level level, LivingEntity summoner) {
        this((EntityType<? extends Mob>)((EntityType)GGEntities.SEISMIC_RIDE.get()), level);
        this.setSummoner(summoner);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_DAMAGE, (Object)Float.valueOf(5.0f));
        this.f_19804_.m_135372_(DATA_AGE, (Object)0);
        this.f_19804_.m_135372_(DATA_MAX_AGE, (Object)1000);
        this.f_19804_.m_135372_(IS_RESTING_INITIAL, (Object)true);
        this.f_19804_.m_135372_(IS_RISING, (Object)false);
        this.f_19804_.m_135372_(IS_RESTING_HOVER, (Object)false);
        this.f_19804_.m_135372_(IS_GOING_FORWARD, (Object)false);
        this.f_19804_.m_135372_(IS_GOING_DOWN, (Object)false);
        this.f_19804_.m_135372_(GOING_DOWN_START_AGE, (Object)-1);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("Damage", this.getDamage());
        tag.m_128405_("Age", this.getAge());
        tag.m_128405_("MaxAge", this.getMaxAge());
        tag.m_128350_("ForwardSpeed", this.forwardSpeed);
        tag.m_128405_("GoingDownStartAge", this.getGoingDownStartAge());
        tag.m_128379_("IsRestingInitial", this.isRestingInitial());
        tag.m_128379_("IsRising", this.isRising());
        tag.m_128379_("IsRestingHover", this.isRestingHover());
        tag.m_128379_("IsGoingForward", this.isGoingForward());
        tag.m_128379_("IsGoingDown", this.isGoingDown());
        if (this.summonerUUID != null) {
            tag.m_128362_("Summoner", this.summonerUUID);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Age")) {
            this.setAge(tag.m_128451_("Age"));
        }
        if (tag.m_128441_("MaxAge")) {
            this.setMaxAge(tag.m_128451_("MaxAge"));
        }
        if (tag.m_128441_("ForwardSpeed")) {
            this.forwardSpeed = tag.m_128457_("ForwardSpeed");
        }
        if (tag.m_128441_("GoingDownStartAge")) {
            this.setGoingDownStartAge(tag.m_128451_("GoingDownStartAge"));
        }
        if (tag.m_128441_("Damage")) {
            this.setDamage(tag.m_128457_("Damage"));
        }
        if (tag.m_128441_("IsRestingInitial")) {
            this.setRestingInitial(tag.m_128471_("IsRestingInitial"));
        }
        if (tag.m_128441_("IsRising")) {
            this.setRising(tag.m_128471_("IsRising"));
        }
        if (tag.m_128441_("IsRestingHover")) {
            this.setRestingHover(tag.m_128471_("IsRestingHover"));
        }
        if (tag.m_128441_("IsGoingForward")) {
            this.setGoingForward(tag.m_128471_("IsGoingForward"));
        }
        if (tag.m_128441_("IsGoingDown")) {
            this.setGoingDown(tag.m_128471_("IsGoingDown"));
        }
        if (tag.m_128403_("Summoner")) {
            this.summonerUUID = tag.m_128342_("Summoner");
        }
    }

    public int getAge() {
        return (Integer)this.f_19804_.m_135370_(DATA_AGE);
    }

    public void setAge(int age) {
        this.f_19804_.m_135381_(DATA_AGE, (Object)age);
    }

    public int getMaxAge() {
        return (Integer)this.f_19804_.m_135370_(DATA_MAX_AGE);
    }

    public void setMaxAge(int maxAge) {
        this.f_19804_.m_135381_(DATA_MAX_AGE, (Object)Math.max(maxAge, 980));
    }

    public int getGoingDownStartAge() {
        return (Integer)this.f_19804_.m_135370_(GOING_DOWN_START_AGE);
    }

    public void setGoingDownStartAge(int age) {
        this.f_19804_.m_135381_(GOING_DOWN_START_AGE, (Object)age);
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DATA_DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_DAMAGE)).floatValue();
    }

    public float getForwardSpeed() {
        return this.forwardSpeed;
    }

    public void setForwardSpeed(float speed) {
        this.forwardSpeed = speed;
    }

    public boolean isRestingInitial() {
        return (Boolean)this.f_19804_.m_135370_(IS_RESTING_INITIAL);
    }

    public void setRestingInitial(boolean value) {
        this.f_19804_.m_135381_(IS_RESTING_INITIAL, (Object)value);
    }

    public boolean isRising() {
        return (Boolean)this.f_19804_.m_135370_(IS_RISING);
    }

    public void setRising(boolean value) {
        this.f_19804_.m_135381_(IS_RISING, (Object)value);
    }

    public boolean isRestingHover() {
        return (Boolean)this.f_19804_.m_135370_(IS_RESTING_HOVER);
    }

    public void setRestingHover(boolean value) {
        this.f_19804_.m_135381_(IS_RESTING_HOVER, (Object)value);
    }

    public boolean isGoingForward() {
        return (Boolean)this.f_19804_.m_135370_(IS_GOING_FORWARD);
    }

    public void setGoingForward(boolean value) {
        this.f_19804_.m_135381_(IS_GOING_FORWARD, (Object)value);
    }

    public boolean isGoingDown() {
        return (Boolean)this.f_19804_.m_135370_(IS_GOING_DOWN);
    }

    public void setGoingDown(boolean value) {
        this.f_19804_.m_135381_(IS_GOING_DOWN, (Object)value);
    }

    private void setPhase(boolean initial, boolean rising, boolean hover, boolean forward, boolean down) {
        this.setRestingInitial(initial);
        this.setRising(rising);
        this.setRestingHover(hover);
        this.setGoingForward(forward);
        this.setGoingDown(down);
    }

    public void setSummoner(@Nullable LivingEntity owner) {
        if (owner != null) {
            this.summonerUUID = owner.m_20148_();
            this.cachedSummoner = owner;
        }
    }

    public LivingEntity getSummoner() {
        Level level;
        if (this.cachedSummoner != null && this.cachedSummoner.m_6084_()) {
            return this.cachedSummoner;
        }
        if (this.summonerUUID != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = serverLevel.m_8791_(this.summonerUUID);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.cachedSummoner = livingEntity = (LivingEntity)entity;
            }
            return this.cachedSummoner;
        }
        return null;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (this.m_20160_()) {
            return super.m_6071_(pPlayer, pHand);
        }
        if (pPlayer == this.getSummoner()) {
            this.doPlayerRide(pPlayer);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    protected void doPlayerRide(Player pPlayer) {
        if (!this.m_9236_().f_46443_) {
            pPlayer.m_146922_(this.m_146908_());
            pPlayer.m_146926_(this.m_146909_());
            pPlayer.m_20329_((Entity)this);
        }
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Mob) {
            return (Mob)entity;
        }
        entity = this.m_146895_();
        if (entity instanceof Player) {
            return (Player)entity;
        }
        return null;
    }

    protected void m_274498_(Player player, Vec3 movementVector) {
        super.m_274498_(player, movementVector);
        this.f_19859_ = this.m_146908_();
        if (this.isGoingForward()) {
            this.m_146922_(player.m_146908_());
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20885_ = this.m_146908_();
        }
        this.f_20883_ = this.f_19859_;
    }

    protected Vec3 m_274312_(Player player, Vec3 playerMovementInput) {
        return Vec3.f_82478_;
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.m_20365_(passenger)) {
            float yOffset = 0.22f;
            moveFunction.m_20372_(passenger, this.m_20185_(), this.m_20186_() + (double)yOffset + this.m_6048_(), this.m_20189_());
        } else {
            super.m_19956_(passenger, moveFunction);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        int currentAge = this.getAge();
        this.setAge(currentAge + 1);
        int age = this.getAge();
        int maxAge = this.getMaxAge();
        if (!this.isGoingDown() && age >= maxAge - 220) {
            this.setGoingDown(true);
            this.setGoingDownStartAge(age);
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
            if (!this.m_9236_().f_46443_) {
                GSLScreenShakeEntity.createScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)6.0f, (float)0.008f, (int)10, (int)0, (int)5, (boolean)false);
            }
        }
        if (this.isGoingDown()) {
            int goingDownStartAge = this.getGoingDownStartAge();
            int goingDownAge = age - goingDownStartAge;
            if (goingDownAge <= 60) {
                this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
                BlockPos groundPos = this.findGroundBelow();
                double groundHeight = groundPos.m_123342_() + 1;
                double targetHeight = groundHeight + 25.0;
                double hoverOffset = 0.5 * Math.sin((double)age * 0.25);
                double hoverY = targetHeight + hoverOffset;
                double deltaY = hoverY - this.m_20186_();
                if (Math.abs(deltaY) > 0.02) {
                    Vec3 motion = this.m_20184_();
                    this.m_20334_(motion.f_82479_, deltaY * 0.25, motion.f_82481_);
                }
                this.f_19789_ = 0.0f;
                this.m_6853_(false);
            } else if (goingDownAge <= 220) {
                double descendProgress;
                double scaledProgress;
                BlockPos groundPos;
                double groundHeight;
                double desiredY;
                double deltaY;
                if (goingDownAge == 61 && !this.m_9236_().f_46443_) {
                    this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_LOOP.get(), 2.5f, 1.0f);
                }
                if (!this.m_9236_().f_46443_ && (goingDownAge - 61) % 60 == 0 && goingDownAge > 61) {
                    this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_LOOP.get(), 2.5f, 1.0f);
                }
                if (Math.abs(deltaY = (desiredY = (groundHeight = (double)((groundPos = this.findGroundBelow()).m_123342_() + 1)) + 25.0 * (scaledProgress = Math.cos((descendProgress = (double)(goingDownAge - 60) / 160.0) * Math.PI * 0.5))) - this.m_20186_()) > 0.02) {
                    this.m_20334_(0.0, deltaY * 0.1, 0.0);
                    this.f_19812_ = true;
                }
                this.f_19789_ = 0.0f;
                this.m_6853_(false);
                if (!this.m_9236_().f_46443_) {
                    AABB boundingBox = this.m_20191_();
                    for (int i = 0; i < 3; ++i) {
                        double d0 = boundingBox.f_82288_ + (boundingBox.f_82291_ - boundingBox.f_82288_) * this.f_19796_.m_188500_();
                        double d1 = boundingBox.f_82289_ + (boundingBox.f_82292_ - boundingBox.f_82289_) * this.f_19796_.m_188500_();
                        double d2 = boundingBox.f_82290_ + (boundingBox.f_82293_ - boundingBox.f_82290_) * this.f_19796_.m_188500_();
                        double d3 = (this.f_19796_.m_188500_() - 0.5) * 0.1;
                        double d4 = 0.05 + this.f_19796_.m_188500_() * 0.1;
                        double d5 = (this.f_19796_.m_188500_() - 0.5) * 0.1;
                        MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_152550_.m_49966_()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.0, (boolean)false);
                    }
                }
            } else {
                this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_1.get(), 2.5f, 1.0f);
                if (!this.m_9236_().f_46443_) {
                    GSLScreenShakeEntity.createScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)12.0f, (float)0.04f, (int)10, (int)0, (int)10, (boolean)false);
                    this.spawnDiscardBlast();
                    this.spawnFallingBlockBlast();
                }
                this.m_146870_();
            }
        } else if (age <= 100) {
            if (!this.isRestingInitial()) {
                this.setPhase(true, false, false, false, false);
                if (!this.m_9236_().f_46443_) {
                    this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_LOOP.get(), 2.5f, 1.0f);
                }
            }
            if (age <= 40 && age % 5 == 0 && !this.m_9236_().f_46443_) {
                if (age == 40) {
                    this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_1.get(), 1.0f, 1.0f);
                } else {
                    float randomPitch = 0.8f + this.f_19796_.m_188501_() * 0.4f;
                    this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_SMALL.get(), 1.0f, randomPitch);
                }
            }
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        } else if (age <= 260) {
            double risingProgress;
            double scaledProgress;
            BlockPos groundPos;
            double groundHeight;
            double desiredY;
            double deltaY;
            if (this.isRestingInitial() || !this.isRising()) {
                this.setPhase(false, true, false, false, false);
                if (!this.m_9236_().f_46443_) {
                    GSLScreenShakeEntity.createScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)6.0f, (float)0.008f, (int)10, (int)0, (int)5, (boolean)false);
                    this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_LOOP.get(), 2.5f, 1.0f);
                }
            }
            if (Math.abs(deltaY = (desiredY = (groundHeight = (double)((groundPos = this.findGroundBelow()).m_123342_() + 1)) + 25.0 * (scaledProgress = Math.sin((risingProgress = (double)(age - 100) / 160.0) * Math.PI * 0.5))) - this.m_20186_()) > 0.02) {
                this.m_20334_(0.0, deltaY * 0.1, 0.0);
                this.f_19812_ = true;
            }
            this.f_19789_ = 0.0f;
            this.m_6853_(false);
            if (!this.m_9236_().f_46443_) {
                AABB boundingBox = this.m_20191_();
                for (int i = 0; i < 2; ++i) {
                    double d0 = boundingBox.f_82288_ + (boundingBox.f_82291_ - boundingBox.f_82288_) * this.f_19796_.m_188500_();
                    double d1 = boundingBox.f_82289_ + (boundingBox.f_82292_ - boundingBox.f_82289_) * this.f_19796_.m_188500_();
                    double d2 = boundingBox.f_82290_ + (boundingBox.f_82293_ - boundingBox.f_82290_) * this.f_19796_.m_188500_();
                    double d3 = (this.f_19796_.m_188500_() - 0.5) * 0.05;
                    double d4 = -0.1 - this.f_19796_.m_188500_() * 0.05;
                    double d5 = (this.f_19796_.m_188500_() - 0.5) * 0.05;
                    MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_152550_.m_49966_()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.0, (boolean)false);
                }
            }
            if (!this.m_9236_().f_46443_ && (age - 100) % 60 == 0 && age > 100) {
                this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_RUMBLE_LOOP.get(), 2.5f, 1.0f);
            }
        } else if (age <= 360) {
            if (this.isRising() || !this.isRestingHover()) {
                this.setPhase(false, false, true, false, false);
                if (!this.m_9236_().f_46443_) {
                    GSLScreenShakeEntity.createScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)6.0f, (float)0.008f, (int)10, (int)0, (int)5, (boolean)false);
                }
            }
            this.maintainHoverHeight();
        } else {
            if (this.isRestingHover() || !this.isGoingForward()) {
                this.setPhase(false, false, false, true, false);
                if (!this.m_9236_().f_46443_) {
                    this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_2.get(), 2.5f, 1.0f);
                }
            }
            Vec3 forward = this.m_20154_().m_82541_().m_82490_((double)this.forwardSpeed);
            this.m_20334_(forward.f_82479_, this.m_20184_().f_82480_, forward.f_82481_);
            this.maintainHoverHeight();
            this.f_19812_ = true;
            if (!this.m_9236_().f_46443_) {
                Vec3 velocity = this.m_20184_();
                AABB boundingBox = this.m_20191_();
                for (int i = 0; i < 2; ++i) {
                    double d0 = boundingBox.f_82288_ + (boundingBox.f_82291_ - boundingBox.f_82288_) * this.f_19796_.m_188500_();
                    double d1 = boundingBox.f_82289_ + (boundingBox.f_82292_ - boundingBox.f_82289_) * this.f_19796_.m_188500_();
                    double d2 = boundingBox.f_82290_ + (boundingBox.f_82293_ - boundingBox.f_82290_) * this.f_19796_.m_188500_();
                    double d3 = -velocity.f_82479_ * 0.8 + (this.f_19796_.m_188500_() - 0.5) * 0.1;
                    double d4 = this.f_19796_.m_188500_() * 0.05 + 0.01;
                    double d5 = -velocity.f_82481_ * 0.8 + (this.f_19796_.m_188500_() - 0.5) * 0.1;
                    MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_152550_.m_49966_()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.0, (boolean)false);
                }
                if (this.f_19797_ % 2 == 0) {
                    double d0 = this.m_20185_() - velocity.f_82479_ * 1.5 + (this.f_19796_.m_188500_() - 0.5);
                    double d1 = this.m_20186_() + this.f_19796_.m_188500_() * 0.5;
                    double d2 = this.m_20189_() - velocity.f_82481_ * 1.5 + (this.f_19796_.m_188500_() - 0.5);
                    double d3 = (this.f_19796_.m_188500_() - 0.5) * 0.02;
                    double d4 = this.f_19796_.m_188500_() * 0.02 + 0.01;
                    double d5 = (this.f_19796_.m_188500_() - 0.5) * 0.02;
                    MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)ParticleTypes.f_123777_, (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.0, (boolean)false);
                }
            }
        }
    }

    private BlockPos findGroundBelow() {
        BlockPos groundPos = this.m_20183_().m_7495_();
        while (this.m_9236_().m_46859_(groundPos) && groundPos.m_123342_() > this.m_9236_().m_141937_()) {
            groundPos = groundPos.m_7495_();
        }
        return groundPos;
    }

    private void maintainHoverHeight() {
        double hoverOffset;
        BlockPos groundPos = this.findGroundBelow();
        double groundHeight = groundPos.m_123342_() + 1;
        double targetHeight = groundHeight + 25.0;
        double hoverY = targetHeight + (hoverOffset = 0.5 * Math.sin((double)this.getAge() * 0.25));
        double deltaY = hoverY - this.m_20186_();
        if (Math.abs(deltaY) > 0.02) {
            Vec3 motion = this.m_20184_();
            this.m_20334_(motion.f_82479_, deltaY * 0.25, motion.f_82481_);
        }
        this.f_19789_ = 0.0f;
        this.m_6853_(false);
    }

    private void spawnDiscardBlast() {
        for (int i = 0; i < 30; ++i) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 10.0;
            double d1 = this.m_20186_() + this.f_19796_.m_188500_() * 5.0;
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 10.0;
            double d3 = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            double d4 = this.f_19796_.m_188500_() * 0.4 + 0.1;
            double d5 = (this.f_19796_.m_188500_() - 0.5) * 0.5;
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_152550_.m_49966_()), (double)d0, (double)d1, (double)d2, (int)1, (double)d3, (double)d4, (double)d5, (double)0.0, (boolean)false);
        }
    }

    private void spawnFallingBlockBlast() {
        AABB boundingBox = this.m_20191_();
        Vec3 center = boundingBox.m_82399_();
        int particleCount = 6;
        for (int i = 0; i < particleCount; ++i) {
            double d3 = (this.f_19796_.m_188500_() - 0.5) * 1.5;
            double d4 = this.f_19796_.m_188500_() * 0.9 + 0.3;
            double d5 = (this.f_19796_.m_188500_() - 0.5) * 1.5;
            int duration = 80 + this.f_19796_.m_188503_(41);
            EntityFallingBlock fallingBlock = new EntityFallingBlock((EntityType)EntityHandler.FALLING_BLOCK.get(), this.m_9236_(), duration, Blocks.f_152551_.m_49966_());
            fallingBlock.m_6034_(center.f_82479_, center.f_82480_, center.f_82481_);
            fallingBlock.m_20334_(d3, d4, d5);
            this.m_9236_().m_7967_((Entity)fallingBlock);
        }
    }

    public void onAntiMagic(MagicData playerMagicData) {
        if (this.getAge() < 40) {
            return;
        }
        this.m_5496_((SoundEvent)MMSounds.EFFECT_GEOMANCY_BREAK_LARGE_1.get(), 2.5f, 1.0f);
        if (!this.m_9236_().f_46443_) {
            GSLScreenShakeEntity.createScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)12.0f, (float)0.008f, (int)10, (int)0, (int)5, (boolean)false);
        }
        if (!this.isGoingDown()) {
            this.setGoingDown(true);
            this.setGoingDownStartAge(this.getAge());
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22276_, 800.0).m_22268_(Attributes.f_22277_, 0.0).m_22268_(Attributes.f_22278_, 100.0).m_22268_(Attributes.f_22279_, 0.0);
    }

    private PlayState animationPredicate(AnimationState<SeismicRideEntity> event) {
        event.getController().setAnimation(this.RIDE_BUILDING_ANIMATION);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

