/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.spells.geo;

import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.entity.projectiles.eroding_boulder.ErodingBoulderEntity;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class ErodingBoulderSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"gtbcs_geomancy_plus", (String)"eroding_boulder");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(GGSchools.GEO_RESOURCE).setMaxLevel(5).setCooldownSeconds(30.0).build();

    public ErodingBoulderSpell() {
        this.manaCostPerLevel = 16;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 40;
        this.baseManaCost = 50;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)MMSounds.EFFECT_GEOMANCY_BOULDER_CHARGE.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)MMSounds.ENTITY_BLUFF_SPIKE_EMERGE.get());
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        Vec3 origin = entity.m_146892_();
        ErodingBoulderEntity erodingBoulder = new ErodingBoulderEntity(world, entity);
        erodingBoulder.setDamage(this.getDamage(spellLevel, entity));
        erodingBoulder.setBlastRadius(this.getRadius(spellLevel, entity));
        erodingBoulder.setEffectAmplifier(this.getErodeAmplifier(spellLevel));
        erodingBoulder.m_146884_(origin.m_82549_(entity.m_20156_()).m_82492_(0.0, (double)(erodingBoulder.m_20206_() / 2.0f), 0.0));
        erodingBoulder.shoot(entity.m_20154_());
        world.m_7967_((Entity)erodingBoulder);
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    public float getDamage(int spellLevel, LivingEntity caster) {
        return 6.0f + 4.5f * this.getSpellPower(spellLevel, (Entity)caster);
    }

    public int getRadius(int spellLevel, LivingEntity caster) {
        return 2 + (int)this.getSpellPower(spellLevel, (Entity)caster);
    }

    public int getErodeAmplifier(int spellLevel) {
        return 1 + spellLevel / 2;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.gtbcs_geomancy_plus.aoe_damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.m_237110_((String)"ui.gtbcs_geomancy_plus.aoe_radius", (Object[])new Object[]{this.getRadius(spellLevel, caster)}), Component.m_237110_((String)"ui.gtbcs_geomancy_plus.erode_amplifier", (Object[])new Object[]{this.getErodeAmplifier(spellLevel)}), Component.m_237113_((String)"\u00a79GTBC'S Geomancy Plus"));
    }
}

