/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gtbcs_geomancy_plus.spells.geo;

import com.gametechbc.gtbcs_geomancy_plus.api.init.GGSchools;
import com.gametechbc.gtbcs_geomancy_plus.init.GGEffects;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class TremorStepSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("gtbcs_geomancy_plus", "tremor_step");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(GGSchools.GEO_RESOURCE).setMaxLevel(3).setCooldownSeconds(75.0).build();

    public TremorStepSpell() {
        this.manaCostPerLevel = 20;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 40;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        entity.m_7292_(new MobEffectInstance((MobEffect)GGEffects.TREMOR_STEP_EFFECT.get(), this.getDuration(spellLevel), this.getAmplifier(entity, spellLevel)));
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public int getDuration(int spellLevel) {
        return 200 + spellLevel * 200;
    }

    public int getAmplifier(LivingEntity caster, int spellLevel) {
        return (int)(1.5 + (double)this.getSpellPower(spellLevel, (Entity)caster) * 1.5);
    }

    public float getSpeedBonusPercentage(LivingEntity caster, int spellLevel) {
        int amplifier = this.getAmplifier(caster, spellLevel);
        return (float)amplifier * 0.025f;
    }

    public String getSpeedBonusString(LivingEntity caster, int spellLevel) {
        float speedBonus = this.getSpeedBonusPercentage(caster, spellLevel);
        return String.format("%.1f%%", Float.valueOf(speedBonus * 100.0f));
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.STOMP;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.gtbcs_geomancy_plus.aoe_damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getAmplifier(caster, spellLevel), (int)2)}), Component.m_237110_((String)"ui.gtbcs_geomancy_plus.speed_bonus", (Object[])new Object[]{this.getSpeedBonusString(caster, spellLevel)}), Component.m_237110_((String)"ui.gtbcs_geomancy_plus.effect_length", (Object[])new Object[]{Utils.timeFromTicks((float)this.getDuration(spellLevel), (int)1)}), Component.m_237113_((String)"\u00a79GTBC'S Geomancy Plus"));
    }
}

