/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.hiddennames;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import github.pitbox46.hiddennames.data.NameData;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;

public class JsonData {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public final MinecraftServer server;
    public final String modName;
    public final String fileName;
    public Path path;

    public JsonData(String modName, String fileName, MinecraftServer server) {
        this.server = server;
        this.modName = modName;
        this.fileName = fileName;
    }

    public void getOrCreateFile() throws IOException {
        Path modFolderPath = this.server.m_129843_(new LevelResource(this.modName));
        File modFolder = Files.isDirectory(modFolderPath, new LinkOption[0]) ? modFolderPath.toFile() : Files.createDirectory(modFolderPath, new FileAttribute[0]).toFile();
        File dataFile = new File(modFolder, this.fileName);
        if (dataFile.createNewFile()) {
            Files.writeString(dataFile.toPath(), (CharSequence)GSON.toJson((JsonElement)new JsonArray()), new OpenOption[0]);
        }
        this.path = dataFile.toPath();
    }

    public void readToData() throws IOException {
        JsonArray json = (JsonArray)GSON.fromJson(Files.readString(this.path), JsonArray.class);
        for (JsonElement element : json) {
            NameData data = NameData.deserialize(element.getAsJsonObject());
            NameData.DATA.put(data.getUuid(), data);
        }
    }

    public void saveToJson() throws IOException {
        Files.writeString(this.path, (CharSequence)GSON.toJson((JsonElement)NameData.deserializeAll()), StandardOpenOption.TRUNCATE_EXISTING);
    }
}

