/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.hiddennames;

import github.pitbox46.hiddennames.Config;
import github.pitbox46.hiddennames.HiddenNames;
import github.pitbox46.hiddennames.JsonData;
import github.pitbox46.hiddennames.data.NameData;
import github.pitbox46.hiddennames.network.BlocksHidePacket;
import github.pitbox46.hiddennames.network.PacketHandler;
import java.io.IOException;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerEvents {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) throws IOException {
        HiddenNames.JSON = new JsonData("hiddennames", "data.json", event.getServer());
        HiddenNames.JSON.getOrCreateFile();
        HiddenNames.JSON.readToData();
    }

    @SubscribeEvent
    public static void onJoinServer(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        NameData.DATA.computeIfAbsent(player.m_20148_(), uuid -> new NameData(player));
        PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new BlocksHidePacket((Boolean)Config.BLOCKS_HIDE.get()));
        NameData.sendSyncData();
    }

    @SubscribeEvent
    public static void onWorldSave(LevelEvent.Save event) throws IOException {
        if (HiddenNames.JSON != null) {
            HiddenNames.JSON.saveToJson();
        }
    }
}

