/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.hiddennames.data;

import github.pitbox46.hiddennames.data.Animation;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.RandomStringUtils;

public class Animations {
    private static final Map<String, Animation> ANIMATIONS = new HashMap<String, Animation>();
    public static final Animation NO_ANIMATION = Animations.regAnimation(new Animation("null", input -> new Animation.Return(input.displayName(), true)));
    public static final Animation HIDDEN = Animations.regAnimation(new Animation("hidden", input -> new Animation.Return(input.ogName(), false)));
    public static final Animation BREATHE = Animations.regAnimation(new Animation("breathe", input -> {
        int amp = 60;
        int cycle = 180;
        Component displayName = input.displayName();
        TextColor color = displayName.m_7383_().m_131135_();
        if (color == null) {
            color = TextColor.m_131270_((ChatFormatting)ChatFormatting.WHITE);
        }
        int primaryColor = color.m_131265_();
        int red = FastColor.ARGB32.m_13665_((int)primaryColor);
        int green = FastColor.ARGB32.m_13667_((int)primaryColor);
        int blue = FastColor.ARGB32.m_13669_((int)primaryColor);
        double sin = Math.sin((double)(input.tick() % 360L * 2L) * Math.PI / (double)cycle);
        double newRed = (double)red + (double)amp * sin;
        double newGreen = (double)green + (double)amp * sin;
        double newBlue = (double)blue + (double)amp * sin;
        MutableComponent newName = displayName.m_6881_();
        newName.m_6270_(displayName.m_7383_().m_131148_(TextColor.m_131266_((int)FastColor.ARGB32.m_13660_((int)255, (int)Animations.roundToByte(newRed), (int)Animations.roundToByte(newGreen), (int)Animations.roundToByte(newBlue)))));
        return new Animation.Return((Component)newName, true);
    }));
    public static final Animation RAINBOW = Animations.regAnimation(new Animation("rainbow", input -> {
        Component displayName = input.displayName();
        MutableComponent newName = Component.m_237113_((String)"");
        int i = 0;
        for (char c : displayName.getString().toCharArray()) {
            newName.m_7220_((Component)Component.m_237113_((String)String.valueOf(c)).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)Mth.m_14169_((float)((float)((input.tick() + (long)(3 * i)) % 180L) / 180.0f), (float)1.0f, (float)1.0f)))));
            ++i;
        }
        return new Animation.Return((Component)newName, true);
    }));
    public static final Animation CYCLE = Animations.regAnimation(new Animation("cycle", input -> {
        Component displayName = input.displayName();
        int toNext = 80;
        Random rng = new Random(input.player().m_19879_());
        IntStream stream = rng.ints();
        TextColor color1 = TextColor.m_131266_((int)stream.skip(input.tick() / (long)toNext).findFirst().orElseThrow());
        TextColor color2 = TextColor.m_131266_((int)rng.nextInt());
        MutableComponent newName = displayName.m_6881_();
        newName.m_6270_(newName.m_7383_().m_131148_(Animations.blendColors(color1, color2, (float)((long)toNext - input.tick() % (long)toNext) / (float)toNext)));
        return new Animation.Return((Component)newName, true);
    }));
    public static final Animation RANDOM = Animations.regAnimation(new Animation("random", input -> {
        int toNext = 15;
        Random rng = new Random((long)input.player().m_19879_() * (input.tick() / (long)toNext));
        String name = RandomStringUtils.random((int)rng.nextInt(3, 10), (int)32, (int)127, (boolean)false, (boolean)false, null, (Random)rng);
        MutableComponent newName = Component.m_237113_((String)"");
        for (char c : name.toCharArray()) {
            newName.m_7220_((Component)Component.m_237113_((String)String.valueOf(c)).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)rng.nextInt()))));
        }
        return new Animation.Return((Component)newName, true);
    }));

    public static Animation regAnimation(Animation animation) {
        ANIMATIONS.put(animation.key(), animation);
        return animation;
    }

    @Nonnull
    public static Animation getAnimation(String key) {
        return ANIMATIONS.getOrDefault(key, NO_ANIMATION);
    }

    @Nullable
    public static Animation getAnimationUnsafe(String key) {
        return ANIMATIONS.get(key);
    }

    public static Set<String> getKeys() {
        return ANIMATIONS.keySet();
    }

    private static int roundToByte(double number) {
        if (number < 0.0) {
            return 0;
        }
        if (number > 255.0) {
            return 255;
        }
        return (int)Math.round(number);
    }

    private static TextColor blendColors(TextColor primary, TextColor secondary, float percent) {
        if (percent > 1.0f) {
            percent = 1.0f;
        }
        if (percent < 0.0f) {
            percent = 0.0f;
        }
        int red = (int)((float)FastColor.ARGB32.m_13665_((int)primary.m_131265_()) * percent + (float)FastColor.ARGB32.m_13665_((int)secondary.m_131265_()) * (1.0f - percent));
        int green = (int)((float)FastColor.ARGB32.m_13667_((int)primary.m_131265_()) * percent + (float)FastColor.ARGB32.m_13667_((int)secondary.m_131265_()) * (1.0f - percent));
        int blue = (int)((float)FastColor.ARGB32.m_13669_((int)primary.m_131265_()) * percent + (float)FastColor.ARGB32.m_13669_((int)secondary.m_131265_()) * (1.0f - percent));
        return TextColor.m_131266_((int)FastColor.ARGB32.m_13660_((int)255, (int)red, (int)green, (int)blue));
    }
}

