/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.hiddennames.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import github.pitbox46.hiddennames.Config;
import github.pitbox46.hiddennames.PlayerDuck;
import github.pitbox46.hiddennames.data.Animation;
import github.pitbox46.hiddennames.data.Animations;
import github.pitbox46.hiddennames.network.NameDataSyncPacket;
import github.pitbox46.hiddennames.network.PacketHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class NameData {
    public static final Map<UUID, NameData> DATA = new HashMap<UUID, NameData>(){

        @Override
        public NameData get(Object key) {
            NameData data = (NameData)super.get(key);
            if (data == null) {
                data = new NameData((UUID)key, (Component)Component.m_237113_((String)("ERROR_DESYNC:" + key.toString())), Animations.NO_ANIMATION);
            }
            return data;
        }
    };
    private final UUID uuid;
    private Component displayName;
    private Animation animation;

    public NameData(Player player) {
        this(player, (Boolean)Config.DEFAULT_VISIBLE.get() != false ? Animations.NO_ANIMATION : Animations.HIDDEN);
    }

    public NameData(Player player, @Nonnull Animation animation) {
        this(player.m_20148_(), ((PlayerDuck)player).hiddenNames$getUnmodifiedDisplayName(), animation);
    }

    public NameData(UUID uuid, Component displayName, Animation animation) {
        this.uuid = uuid;
        this.displayName = displayName;
        this.animation = animation;
    }

    public static void sendSyncData() {
        for (NameData data : DATA.values()) {
            PacketHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new NameDataSyncPacket(data));
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(Component displayName) {
        this.displayName = displayName;
    }

    public Animation getAnimation() {
        return this.animation == null ? Animations.NO_ANIMATION : this.animation;
    }

    public void setAnimation(Animation animation) {
        this.animation = animation == null ? Animations.NO_ANIMATION : animation;
    }

    public JsonObject serialize(JsonObject json) {
        json.addProperty("uuid", this.uuid.toString());
        json.add("displayName", Component.Serializer.m_130716_((Component)this.displayName));
        json.addProperty("animation", this.animation.key());
        return json;
    }

    public static NameData deserialize(JsonObject json) {
        UUID uuid = UUID.fromString(json.getAsJsonPrimitive("uuid").getAsString());
        MutableComponent component = Component.Serializer.m_130691_((JsonElement)json.get("displayName"));
        Animation animation = Animations.getAnimation(json.getAsJsonPrimitive("animation").getAsString());
        return new NameData(uuid, (Component)component, animation);
    }

    public static JsonArray deserializeAll() {
        JsonArray array = new JsonArray();
        for (NameData data : DATA.values()) {
            array.add((JsonElement)data.serialize(new JsonObject()));
        }
        return array;
    }
}

