/*
 * Decompiled with CFR 0.152.
 */
package net.donne431.ice_and_fire_delight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.donne431.ice_and_fire_delight.block.BlackDragonCuttingBoardBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.block.state.properties.Property;
import vectorwing.farmersdelight.client.renderer.CuttingBoardRenderer;
import vectorwing.farmersdelight.common.block.CuttingBoardBlock;
import vectorwing.farmersdelight.common.block.entity.CuttingBoardBlockEntity;
import vectorwing.farmersdelight.common.tag.ModTags;

public class CustomCuttingBoardRenderer
implements BlockEntityRenderer<CuttingBoardBlockEntity> {
    private final CuttingBoardRenderer defaultRenderer;

    public CustomCuttingBoardRenderer(BlockEntityRendererProvider.Context context) {
        this.defaultRenderer = new CuttingBoardRenderer(context);
    }

    public void render(CuttingBoardBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (entity.m_58900_().m_60734_() instanceof BlackDragonCuttingBoardBlock) {
            ItemStack boardStack = entity.getStoredItem();
            System.out.println("Rendering item for BlackDragonCuttingBoard: " + boardStack + " at pos: " + entity.m_58899_() + ", empty: " + boardStack.m_41619_());
            if (!boardStack.m_41619_()) {
                poseStack.m_85836_();
                ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                Direction direction = ((Direction)entity.m_58900_().m_61143_((Property)CuttingBoardBlock.FACING)).m_122424_();
                float rotationY = -direction.m_122435_();
                int posLong = (int)entity.m_58899_().m_121878_();
                boolean isBlockItem = itemRenderer.m_174264_(boardStack, entity.m_58904_(), null, 0).applyTransform(ItemDisplayContext.FIXED, poseStack, false).m_7539_();
                System.out.println("Item isBlockItem: " + isBlockItem + ", direction: " + direction + ", rotationY: " + rotationY);
                if (entity.isItemCarvingBoard()) {
                    this.renderItemCarved(poseStack, direction, boardStack);
                    System.out.println("Rendering as carved item, translate: (0.5, 0.23, 0.5), scale: (0.6, 0.6, 0.6)");
                } else if (isBlockItem && !boardStack.m_204117_(ModTags.FLAT_ON_CUTTING_BOARD)) {
                    this.renderBlock(poseStack, direction);
                    System.out.println("Rendering as block, translate: (0.5, 0.27, 0.5), scale: (0.8, 0.8, 0.8)");
                } else {
                    this.renderItemLayingDown(poseStack, direction);
                    System.out.println("Rendering as flat item, translate: (0.5, 0.08, 0.5), scale: (0.6, 0.6, 0.6)");
                }
                itemRenderer.m_269128_(boardStack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, buffer, entity.m_58904_(), posLong);
                poseStack.m_85849_();
            } else {
                System.out.println("No item to render for BlackDragonCuttingBoard at pos: " + entity.m_58899_());
            }
        } else {
            this.defaultRenderer.render(entity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        }
    }

    private void renderItemLayingDown(PoseStack matrixStackIn, Direction direction) {
        matrixStackIn.m_85837_(0.5, 0.08, 0.5);
        float f = -direction.m_122435_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(f));
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        matrixStackIn.m_85841_(0.6f, 0.6f, 0.6f);
    }

    private void renderBlock(PoseStack matrixStackIn, Direction direction) {
        matrixStackIn.m_85837_(0.5, 0.27, 0.5);
        float f = -direction.m_122435_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(f));
        matrixStackIn.m_85841_(0.8f, 0.8f, 0.8f);
    }

    private void renderItemCarved(PoseStack matrixStackIn, Direction direction, ItemStack itemStack) {
        matrixStackIn.m_85837_(0.5, 0.23, 0.5);
        float f = -direction.m_122435_() + 180.0f;
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(f));
        float poseAngle = itemStack.m_41720_() instanceof PickaxeItem || itemStack.m_41720_() instanceof HoeItem ? 225.0f : (itemStack.m_41720_() instanceof TridentItem ? 135.0f : 180.0f);
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(poseAngle));
        matrixStackIn.m_85841_(0.6f, 0.6f, 0.6f);
    }
}

