/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.structure;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.config.BiomeConfig;
import com.github.alexthe666.iceandfire.datagen.IafBiomeTagGenerator;
import com.github.alexthe666.iceandfire.datagen.IafStructurePieces;
import com.github.alexthe666.iceandfire.world.IafStructureTypes;
import com.github.alexthe666.iceandfire.world.structure.IafStructure;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class MausoleumStructure
extends IafStructure {
    public static final Codec<MausoleumStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MausoleumStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, MausoleumStructure::new)).codec();

    public MausoleumStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config, startPool, startJigsawName, size, startHeight, projectStartToHeightmap, maxDistanceFromCenter);
    }

    @Override
    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext pContext) {
        if (!IafConfig.generateMausoleums) {
            return Optional.empty();
        }
        ChunkPos pos = pContext.f_226628_();
        BlockPos blockpos = pos.m_151394_(1);
        if (!this.isBiomeValid(pContext, BiomeConfig.mausoleumBiomes, blockpos)) {
            return Optional.empty();
        }
        Optional structurePiecesGenerator = JigsawPlacement.m_227238_((Structure.GenerationContext)pContext, (Holder)this.startPool, (Optional)this.startJigsawName, (int)this.size, (BlockPos)blockpos, (boolean)false, (Optional)this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
        return structurePiecesGenerator;
    }

    @Override
    public StructureType<?> m_213658_() {
        return (StructureType)IafStructureTypes.MAUSOLEUM.get();
    }

    public static MausoleumStructure buildStructureConfig(BootstapContext<Structure> context) {
        HolderGetter templatePoolHolderGetter = context.m_255420_(Registries.f_256948_);
        Holder.Reference graveyardHolder = templatePoolHolderGetter.m_255043_(IafStructurePieces.MAUSOLEUM_START);
        return new MausoleumStructure(new Structure.StructureSettings((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(IafBiomeTagGenerator.HAS_MAUSOLEUM), new HashMap(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)graveyardHolder, Optional.empty(), 1, (HeightProvider)ConstantHeight.f_161945_, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 16);
    }
}

