/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering;

import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.blocks.LeafPileBlock;
import com.ordana.immersive_weathering.client.particles.EmberParticle;
import com.ordana.immersive_weathering.client.particles.LeafParticle;
import com.ordana.immersive_weathering.client.particles.NormalGravityParticle;
import com.ordana.immersive_weathering.dynamicpack.ClientDynamicResourcesHandler;
import com.ordana.immersive_weathering.items.FlowerCrownItem;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModEntities;
import com.ordana.immersive_weathering.reg.ModItems;
import com.ordana.immersive_weathering.reg.ModParticles;
import net.mehvahdjukaar.moonlight.api.client.renderer.FallingBlockRendererGeneric;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.GlowParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ImmersiveWeatheringClient {
    public static void init() {
        ClientHelper.addClientSetup(ImmersiveWeatheringClient::setup);
        ClientDynamicResourcesHandler.INSTANCE.register();
        ClientHelper.registerOptionalTexturePack((ResourceLocation)ImmersiveWeathering.res("visual_waxed_iron_items"));
        ClientHelper.addEntityRenderersRegistration(ImmersiveWeatheringClient::registerEntityRenderers);
        ClientHelper.addBlockColorsRegistration(ImmersiveWeatheringClient::registerBlockColors);
        ClientHelper.addItemColorsRegistration(ImmersiveWeatheringClient::registerItemColors);
        ClientHelper.addParticleRegistration(ImmersiveWeatheringClient::registerParticles);
    }

    public static void setup() {
        ClientHelper.registerRenderType((Block)ModBlocks.GRASSY_PERMAFROST.get(), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)ModBlocks.GRASSY_SILT.get(), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)ModBlocks.GRASSY_EARTHEN_CLAY.get(), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)ModBlocks.GRASSY_SANDY_DIRT.get(), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)ModBlocks.ROOTED_GRASS_BLOCK.get(), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)ModBlocks.VITRIFIED_SAND.get(), (RenderType)RenderType.m_110466_());
        ClientHelper.registerRenderType((Block)ModBlocks.EXPOSED_IRON_DOOR.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.WEATHERED_IRON_DOOR.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.RUSTED_IRON_DOOR.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.EXPOSED_IRON_TRAPDOOR.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.WEATHERED_IRON_TRAPDOOR.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.RUSTED_IRON_TRAPDOOR.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.EXPOSED_IRON_BARS.get(), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)ModBlocks.WEATHERED_IRON_BARS.get(), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)ModBlocks.RUSTED_IRON_BARS.get(), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)ModBlocks.WAXED_IRON_DOOR.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.WAXED_EXPOSED_IRON_DOOR.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.WAXED_WEATHERED_IRON_DOOR.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.WAXED_RUSTED_IRON_DOOR.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.WAXED_IRON_TRAPDOOR.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.WAXED_EXPOSED_IRON_TRAPDOOR.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.WAXED_WEATHERED_IRON_TRAPDOOR.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.WAXED_RUSTED_IRON_TRAPDOOR.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.WAXED_IRON_BARS.get(), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)ModBlocks.WAXED_EXPOSED_IRON_BARS.get(), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)ModBlocks.WAXED_WEATHERED_IRON_BARS.get(), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)ModBlocks.WAXED_RUSTED_IRON_BARS.get(), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)ModBlocks.ICICLE.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.FULGURITE.get(), (RenderType)RenderType.m_110463_());
        ModBlocks.LEAF_PILES.values().forEach(b -> ClientHelper.registerRenderType((Block)b, (RenderType)RenderType.m_110457_()));
        ClientHelper.registerRenderType((Block)((Block)ModBlocks.AZALEA_FLOWER_PILE.get()), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)ModBlocks.WEEDS.get(), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)((Block)ModBlocks.IVY.get()), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)ModBlocks.MOSS.get(), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)ModBlocks.DUNE_GRASS.get(), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)ModBlocks.SOOT.get(), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)ModBlocks.SOOT.get(), (RenderType)RenderType.m_110466_());
        ClientHelper.registerRenderType((Block)ModBlocks.FROST.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.FROST.get(), (RenderType)RenderType.m_110466_());
        ClientHelper.registerRenderType((Block)ModBlocks.FROSTY_GLASS.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.FROSTY_GLASS.get(), (RenderType)RenderType.m_110466_());
        ClientHelper.registerRenderType((Block)ModBlocks.FROSTY_GLASS_PANE.get(), (RenderType)RenderType.m_110463_());
        ClientHelper.registerRenderType((Block)ModBlocks.FROSTY_GLASS_PANE.get(), (RenderType)RenderType.m_110466_());
        ClientHelper.registerRenderType((Block)ModBlocks.FROSTY_GRASS.get(), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)ModBlocks.FROSTY_FERN.get(), (RenderType)RenderType.m_110457_());
        ClientHelper.registerRenderType((Block)ModBlocks.THIN_ICE.get(), (RenderType)RenderType.m_110466_());
        ClientHelper.registerRenderType((Block)ModBlocks.TINTED_GLASS_PANE.get(), (RenderType)RenderType.m_110466_());
        ClientHelper.registerRenderType((Block)ModBlocks.HANGING_ROOTS_WALL.get(), (RenderType)RenderType.m_110457_());
        ItemProperties.m_174570_((Item)ModItems.FLOWER_CROWN.get(), (ResourceLocation)ImmersiveWeathering.res("supporter"), (stack, world, entity, s) -> FlowerCrownItem.getItemTextureIndex(stack));
    }

    private static void registerEntityRenderers(ClientHelper.EntityRendererEvent event) {
        event.register(ModEntities.FALLING_ICICLE.get(), FallingBlockRendererGeneric::new);
        event.register(ModEntities.FALLING_LAYER.get(), FallingBlockRendererGeneric::new);
        event.register(ModEntities.FALLING_PROPAGULE.get(), FallingBlockRendererGeneric::new);
    }

    private static void registerParticles(ClientHelper.ParticleEvent event) {
        event.register((ParticleType)ModParticles.EMBERSPARK.get(), EmberParticle.EmberFactory::new);
        event.register((ParticleType)ModParticles.SCRAPE_RUST.get(), ScrapeRustFactory::new);
        event.register((ParticleType)ModParticles.MOSS.get(), NormalGravityParticle.Particle::new);
        event.register((ParticleType)ModParticles.GRAVITY_AZALEA_FLOWER.get(), NormalGravityParticle.Particle::new);
        event.register((ParticleType)ModParticles.AZALEA_FLOWER.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_BEE.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_JAR.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_BOB.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_ACE.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_ARO.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_BI.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_ENBY.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_GAY.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_LESBIAN.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_RAINBOW.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_TRANS.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_GENDERQUEER.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_FLUID.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_INTERSEX.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_PAN.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_FLAX.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_NEKOMASTER.get(), LeafParticle.SimpleLeafParticle::new);
        event.register((ParticleType)ModParticles.FLOWER_AKASHII.get(), LeafParticle.SimpleLeafParticle::new);
    }

    private static void registerBlockColors(ClientHelper.BlockColorEvent event) {
        ModBlocks.LEAF_PILES.forEach((type, leafPile) -> event.register((blockState, blockAndTintGetter, blockPos, i) -> ImmersiveWeatheringClient.getLeafTypeColor(event, type, blockState, blockAndTintGetter, blockPos, i), new Block[]{leafPile}));
        event.register((blockState, level, blockPos, i) -> {
            if (i == 0) {
                return -1;
            }
            return event.getColor(Blocks.f_50440_.m_49966_(), level, blockPos, i);
        }, new Block[]{ModBlocks.GRASSY_PERMAFROST.get(), ModBlocks.GRASSY_SILT.get(), ModBlocks.GRASSY_EARTHEN_CLAY.get(), ModBlocks.GRASSY_SANDY_DIRT.get(), ModBlocks.ROOTED_GRASS_BLOCK.get(), ModBlocks.FROSTY_GRASS.get(), ModBlocks.FROSTY_FERN.get()});
    }

    private static int getLeafTypeColor(ClientHelper.BlockColorEvent event, LeavesType type, BlockState state, BlockAndTintGetter level, BlockPos pos, int i) {
        int original = event.getColor(type.leaves.m_49966_(), level, pos, i);
        float percentage = (float)((Integer)state.m_61143_((Property)LeafPileBlock.AGE)).intValue() / 10.0f;
        int brown = 8213010;
        return new RGBColor(original).asLAB().mixWith(new RGBColor(brown).asLAB(), percentage).asRGB().toInt();
    }

    private static void registerItemColors(ClientHelper.ItemColorEvent event) {
        event.register((itemStack, i) -> event.getColor(Items.f_42276_.m_7968_(), i), new ItemLike[]{(ItemLike)ModBlocks.ROOTED_GRASS_BLOCK.get(), (ItemLike)ModBlocks.GRASSY_SILT.get(), (ItemLike)ModBlocks.GRASSY_PERMAFROST.get(), (ItemLike)ModBlocks.GRASSY_SANDY_DIRT.get(), (ItemLike)ModBlocks.GRASSY_EARTHEN_CLAY.get()});
        ModItems.LEAF_PILES.forEach((type, leafPile) -> event.register((itemStack, i) -> event.getColor(type.leaves.m_5456_().m_7968_(), i), new ItemLike[]{leafPile}));
    }

    private static class ScrapeRustFactory
    extends GlowParticle.ScrapeProvider {
        public ScrapeRustFactory(SpriteSet spriteSet) {
            super(spriteSet);
        }

        public Particle m_6966_(SimpleParticleType particleType, ClientLevel level, double p_172207_, double p_172208_, double p_172209_, double p_172210_, double p_172211_, double p_172212_) {
            Particle p = super.m_6966_(particleType, level, p_172207_, p_172208_, p_172209_, p_172210_, p_172211_, p_172212_);
            if (p != null) {
                if (level.f_46441_.m_188499_()) {
                    p.m_107253_(0.76862746f, 0.4627451f, 0.28627452f);
                } else {
                    p.m_107253_(0.6901961f, 0.24705882f, 0.15686275f);
                }
            }
            return p;
        }
    }
}

