/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks;

import com.ordana.immersive_weathering.entities.FallingIcicleEntity;
import com.ordana.immersive_weathering.entities.IcicleBlockEntity;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModTags;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class IcicleBlock
extends PointedDripstoneBlock
implements EntityBlock {
    public IcicleBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (state.m_61143_((Property)f_154009_) == Direction.DOWN && state.m_61143_((Property)f_154010_) == DripstoneThickness.TIP) {
            return new IcicleBlockEntity(pos, state);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener m_214009_(ServerLevel serverLevel, T blockEntity) {
        IcicleBlockEntity t;
        return blockEntity instanceof IcicleBlockEntity ? (t = (IcicleBlockEntity)blockEntity) : null;
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hitResult, Projectile projectile) {
        BlockPos blockpos = hitResult.m_82425_();
        if (!level.f_46443_ && projectile.m_142265_(level, blockpos) && projectile.m_20184_().m_82553_() > 0.6) {
            level.m_46961_(blockpos, true);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return IcicleBlock.isValidIciclePlacement(level, pos, (Direction)state.m_61143_((Property)f_154009_));
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)f_154011_)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (dir != Direction.UP && dir != Direction.DOWN) {
            return state;
        }
        Direction direction = (Direction)state.m_61143_((Property)f_154009_);
        if (direction == Direction.DOWN && level.m_183326_().m_183582_(pos, (Object)this)) {
            return state;
        }
        if (dir == direction.m_122424_() && !this.m_7898_(state, (LevelReader)level, pos)) {
            if (direction == Direction.DOWN) {
                level.m_186460_(pos, (Block)this, 2);
            } else {
                level.m_186460_(pos, (Block)this, 1);
            }
            return state;
        }
        boolean flag = state.m_61143_((Property)f_154010_) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = IcicleBlock.calculateIcicleThickness((LevelReader)level, pos, direction, flag);
        return (BlockState)state.m_61124_((Property)f_154010_, (Comparable)dripstonethickness);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (state.m_61143_((Property)f_154009_) == Direction.UP && state.m_61143_((Property)f_154010_) == DripstoneThickness.TIP) {
            entity.m_142535_(fallDistance + 2.0f, 3.5f, level.m_269111_().m_268989_());
        } else {
            entity.m_142535_(fallDistance, 1.0f, level.m_269111_().m_268989_());
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Optional<Fluid> optional;
        float f;
        if (IcicleBlock.canDrip(state) && !((f = random.m_188501_()) > 0.12f) && (optional = IcicleBlock.getFluidAboveStalactite(level, pos, state)).filter(fluid -> IcicleBlock.isValidDripFluid(fluid) || !((Biome)level.m_204166_(pos).m_203334_()).m_198904_(pos) && f < 0.02f).isPresent()) {
            IcicleBlock.spawnDripParticle(level, pos, state, optional.get());
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (IcicleBlock.isIcicleFacingDirection(state, Direction.UP) && !this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        } else {
            this.spawnFallingIcicle(state, level, pos);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.maybeFillCauldron(state, level, pos, random.m_188501_());
        if (random.m_188501_() < 0.2f && IcicleBlock.isIcicleTip(state, (LevelReader)level, pos)) {
            IcicleBlock.growStalactiteOrStalagmiteIfPossible(state, level, pos, random);
        }
        Holder biome = level.m_204166_(pos);
        if (level.m_45517_(LightLayer.BLOCK, pos) > 13 - state.m_60739_((BlockGetter)level, pos) || level.m_46472_() == Level.f_46429_ || !biome.m_203656_(ModTags.ICY) && level.m_46461_() && !level.m_46471_()) {
            level.m_7471_(pos, false);
        }
    }

    public void maybeFillCauldron(BlockState state, ServerLevel level, BlockPos pos, float dripChance) {
        BlockPos blockPos2;
        BlockPos blockPos;
        Fluid fluid;
        float f;
        if (!(dripChance > 0.2f) && IcicleBlock.isIcicleTip(state, (LevelReader)level, pos) && level.m_46461_() && !level.m_46471_() && !level.m_46470_() && !(dripChance >= (f = (fluid = IcicleBlock.m_221849_((ServerLevel)level, (BlockPos)pos)) == Fluids.f_76193_ ? 0.17578125f : 0.05859375f)) && (blockPos = IcicleBlock.findTip(state, (LevelAccessor)level, pos, 11, false)) != null && (blockPos2 = IcicleBlock.getCauldronPos((Level)level, blockPos)) != null) {
            level.m_46796_(1504, blockPos, 0);
            int i = blockPos.m_123342_() - blockPos2.m_123342_();
            int j = 50 + i;
            BlockState blockState = level.m_8055_(blockPos2);
            level.m_186460_(blockPos2, blockState.m_60734_(), j);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction direction;
        BlockPos blockPos;
        Level levelAccess = ctx.m_43725_();
        Direction direction2 = IcicleBlock.calculateTipDirection((LevelReader)levelAccess, blockPos = ctx.m_8083_(), direction = ctx.m_151260_().m_122424_());
        if (direction2 == null) {
            return null;
        }
        boolean bl = !ctx.m_7078_();
        DripstoneThickness thickness = IcicleBlock.calculateIcicleThickness((LevelReader)levelAccess, blockPos, direction2, bl);
        return thickness == null ? null : (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_154009_, (Comparable)direction2)).m_61124_((Property)f_154010_, (Comparable)thickness)).m_61124_((Property)f_154011_, (Comparable)Boolean.valueOf(levelAccess.m_6425_(blockPos).m_76152_() == Fluids.f_76193_));
    }

    public void m_142525_(Level level, BlockPos pos, FallingBlockEntity fallingBlockEntity) {
        if (!fallingBlockEntity.m_20067_()) {
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)this.m_49966_()));
        }
    }

    private void spawnFallingIcicle(BlockState state, ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        BlockState blockstate = state;
        while (IcicleBlock.isIcicle(blockstate) && this.m_7898_(blockstate, (LevelReader)level, (BlockPos)mutable)) {
            if (IcicleBlock.isTip(blockstate, true)) {
                if (FallingBlock.m_53241_((BlockState)level.m_8055_(mutable.m_7495_()))) break;
                return;
            }
            mutable.m_122173_(Direction.DOWN);
            blockstate = level.m_8055_((BlockPos)mutable);
        }
        mutable = pos.m_122032_();
        blockstate = state;
        while (IcicleBlock.isIcicle(blockstate)) {
            FallingBlockEntity fallingblockentity = FallingIcicleEntity.fall((Level)level, (BlockPos)mutable, blockstate);
            if (IcicleBlock.isTip(blockstate, true)) {
                int i = Math.max(1 + pos.m_123342_() - mutable.m_123342_(), 6);
                float f = i;
                fallingblockentity.m_149656_(f, 40);
                break;
            }
            mutable.m_122173_(Direction.DOWN);
            blockstate = level.m_8055_((BlockPos)mutable);
        }
    }

    public static void growStalactiteOrStalagmiteIfPossible(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState blockState3;
        BlockPos blockPos;
        BlockState blockState2;
        BlockState blockState = level.m_8055_(pos.m_6630_(1));
        if (IcicleBlock.canGrow(blockState, blockState2 = level.m_8055_(pos.m_6630_(2))) && level.m_46461_() && !level.m_46471_() && !level.m_46470_() && (blockPos = IcicleBlock.findTip(state, (LevelAccessor)level, pos, 7, false)) != null && IcicleBlock.canDrip(blockState3 = level.m_8055_(blockPos)) && IcicleBlock.canTipGrow(blockState3, level, blockPos)) {
            if (random.m_188499_()) {
                IcicleBlock.grow(level, blockPos, Direction.DOWN);
            } else {
                IcicleBlock.growStalagmiteBelow(level, blockPos);
            }
        }
    }

    private static void growStalagmiteBelow(ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (int i = 0; i < 10; ++i) {
            mutable.m_122173_(Direction.DOWN);
            BlockState blockState = level.m_8055_((BlockPos)mutable);
            if (!blockState.m_60819_().m_76178_()) {
                return;
            }
            if (IcicleBlock.isUnmergedTipWithDirection(blockState, Direction.UP) && IcicleBlock.canTipGrow(blockState, level, (BlockPos)mutable)) {
                IcicleBlock.grow(level, (BlockPos)mutable, Direction.UP);
                return;
            }
            if (!IcicleBlock.isValidIciclePlacement((LevelReader)level, (BlockPos)mutable, Direction.UP) || level.m_46801_(mutable.m_7495_())) continue;
            IcicleBlock.grow(level, mutable.m_7495_(), Direction.UP);
            return;
        }
    }

    private static void grow(ServerLevel level, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.m_121945_(direction);
        BlockState blockState = level.m_8055_(blockPos);
        if (IcicleBlock.isUnmergedTipWithDirection(blockState, direction.m_122424_())) {
            IcicleBlock.createMergedTips(blockState, (LevelAccessor)level, blockPos);
        } else if (blockState.m_60795_() || blockState.m_60713_(Blocks.f_49990_)) {
            IcicleBlock.createIcicle((LevelAccessor)level, blockPos, direction, DripstoneThickness.TIP);
        }
    }

    private static void createIcicle(LevelAccessor level, BlockPos pos, Direction direction, DripstoneThickness thickness) {
        BlockState blockState = (BlockState)((BlockState)((BlockState)ModBlocks.ICICLE.get().m_49966_().m_61124_((Property)f_154009_, (Comparable)direction)).m_61124_((Property)f_154010_, (Comparable)thickness)).m_61124_((Property)f_154011_, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
        level.m_7731_(pos, blockState, 3);
    }

    private static void createMergedTips(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockPos blockPos2;
        BlockPos blockPos;
        if (state.m_61143_((Property)f_154009_) == Direction.UP) {
            blockPos = pos;
            blockPos2 = pos.m_7494_();
        } else {
            blockPos2 = pos;
            blockPos = pos.m_7495_();
        }
        IcicleBlock.createIcicle(level, blockPos2, Direction.DOWN, DripstoneThickness.TIP_MERGE);
        IcicleBlock.createIcicle(level, blockPos, Direction.UP, DripstoneThickness.TIP_MERGE);
    }

    private static void spawnDripParticle(Level level, BlockPos pos, BlockState state, Fluid fluid) {
        Vec3 vec3d = state.m_60824_((BlockGetter)level, pos);
        double e = (double)pos.m_123341_() + 0.5 + vec3d.f_82479_;
        double f = pos.m_123342_() + 0;
        double g = (double)pos.m_123343_() + 0.5 + vec3d.f_82481_;
        SimpleParticleType particleEffect = ParticleTypes.f_175824_;
        level.m_7106_((ParticleOptions)particleEffect, e, f, g, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPos findTip(BlockState state, LevelAccessor level, BlockPos pos, int range, boolean allowMerged) {
        if (IcicleBlock.isTip(state, allowMerged)) {
            return pos;
        }
        Direction direction = (Direction)state.m_61143_((Property)f_154009_);
        Predicate<BlockState> predicate = statex -> statex.m_60713_(ModBlocks.ICICLE.get()) && statex.m_61143_((Property)f_154009_) == direction;
        return IcicleBlock.searchInDirection(level, pos, direction.m_122421_(), predicate, statex -> IcicleBlock.isTip(statex, allowMerged), range).orElse(null);
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader level, BlockPos pos, Direction direction) {
        Direction direction2;
        if (IcicleBlock.isValidIciclePlacement(level, pos, direction)) {
            direction2 = direction;
        } else {
            if (!IcicleBlock.isValidIciclePlacement(level, pos, direction.m_122424_())) {
                return null;
            }
            direction2 = direction.m_122424_();
        }
        return direction2;
    }

    private static DripstoneThickness calculateIcicleThickness(LevelReader level, BlockPos pos, Direction direction, boolean tryMerge) {
        Direction direction2 = direction.m_122424_();
        BlockState blockState = level.m_8055_(pos.m_121945_(direction));
        if (IcicleBlock.isIcicleFacingDirection(blockState, direction2)) {
            return !tryMerge && blockState.m_61143_((Property)f_154010_) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!IcicleBlock.isIcicleFacingDirection(blockState, direction)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness thickness = (DripstoneThickness)blockState.m_61143_((Property)f_154010_);
        if (thickness != DripstoneThickness.TIP && thickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockState2 = level.m_8055_(pos.m_121945_(direction2));
            return !IcicleBlock.isIcicleFacingDirection(blockState2, direction) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean canDrip(BlockState state) {
        return IcicleBlock.isIcicle(state) && state.m_61143_((Property)f_154010_) == DripstoneThickness.TIP && (Boolean)state.m_61143_((Property)f_154011_) == false;
    }

    private static boolean canTipGrow(BlockState state, ServerLevel level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)f_154009_);
        BlockPos blockPos = pos.m_121945_(direction);
        BlockState blockState = level.m_8055_(blockPos);
        if (!blockState.m_60819_().m_76178_()) {
            return false;
        }
        return blockState.m_60795_() || IcicleBlock.isUnmergedTipWithDirection(blockState, direction.m_122424_());
    }

    private static Optional<BlockPos> getSupportingPos(Level level, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)f_154009_);
        Predicate<BlockState> predicate = statex -> statex.m_60713_(ModBlocks.ICICLE.get()) && statex.m_61143_((Property)f_154009_) == direction;
        return IcicleBlock.searchInDirection((LevelAccessor)level, pos, direction.m_122424_().m_122421_(), predicate, statex -> !statex.m_60713_(ModBlocks.ICICLE.get()), 11);
    }

    private static boolean isValidIciclePlacement(LevelReader level, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockState = level.m_8055_(blockPos);
        return blockState.m_204336_(BlockTags.f_13035_) || IcicleBlock.m_49863_((LevelReader)level, (BlockPos)blockPos, (Direction)direction) || IcicleBlock.isIcicleFacingDirection(blockState, direction);
    }

    private static boolean isTip(BlockState state, boolean allowMerged) {
        if (!state.m_60713_(ModBlocks.ICICLE.get())) {
            return false;
        }
        DripstoneThickness thickness = (DripstoneThickness)state.m_61143_((Property)f_154010_);
        return thickness == DripstoneThickness.TIP || allowMerged && thickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isUnmergedTipWithDirection(BlockState state, Direction direction) {
        return IcicleBlock.isTip(state, false) && state.m_61143_((Property)f_154009_) == direction;
    }

    private static boolean isIcicle(BlockState state) {
        return IcicleBlock.isIcicleFacingDirection(state, Direction.DOWN);
    }

    private static boolean isIcicleTip(BlockState state, LevelReader level, BlockPos pos) {
        return IcicleBlock.isIcicle(state) && !level.m_8055_(pos.m_7494_()).m_60713_(ModBlocks.ICICLE.get());
    }

    private static boolean isIcicleFacingDirection(BlockState state, Direction direction) {
        return state.m_60713_(ModBlocks.ICICLE.get()) && state.m_61143_((Property)f_154009_) == direction;
    }

    @Nullable
    private static BlockPos getCauldronPos(Level level, BlockPos pos) {
        Predicate<BlockState> predicate = state -> state.m_60734_() instanceof AbstractCauldronBlock;
        return IcicleBlock.searchInDirection((LevelAccessor)level, pos, Direction.DOWN.m_122421_(), BlockBehaviour.BlockStateBase::m_60795_, predicate, 11).orElse(null);
    }

    public static Fluid getCauldronFillFluidType(Level level, BlockPos pos) {
        return IcicleBlock.getFluidAboveStalactite(level, pos, level.m_8055_(pos)).filter(IcicleBlock::isValidDripFluid).orElse(Fluids.f_76191_);
    }

    private static Optional<Fluid> getFluidAboveStalactite(Level level, BlockPos pos, BlockState state) {
        return !IcicleBlock.isIcicle(state) ? Optional.empty() : IcicleBlock.getSupportingPos(level, pos, state).map(posx -> level.m_6425_(posx.m_7494_()).m_76152_());
    }

    private static boolean isValidDripFluid(Fluid fluid) {
        return fluid == Fluids.f_76193_;
    }

    private static boolean canGrow(BlockState iceBlockState, BlockState waterState) {
        return iceBlockState.m_204336_(ModTags.ICE) && waterState.m_60713_(Blocks.f_49990_);
    }

    private static Optional<BlockPos> searchInDirection(LevelAccessor level, BlockPos pos, Direction.AxisDirection direction, Predicate<BlockState> continuePredicate, Predicate<BlockState> stopPredicate, int range) {
        Direction direction2 = Direction.m_122390_((Direction.AxisDirection)direction, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (int i = 1; i < range; ++i) {
            mutable.m_122173_(direction2);
            BlockState blockState = level.m_8055_((BlockPos)mutable);
            if (stopPredicate.test(blockState)) {
                return Optional.of(mutable.m_7949_());
            }
            if (!level.m_151562_(mutable.m_123342_()) && continuePredicate.test(blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }
}

