/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks;

import com.ordana.immersive_weathering.blocks.ModBlockProperties;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModSoundEvents;
import com.ordana.immersive_weathering.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ThinIceBlock
extends IceBlock
implements LiquidBlockContainer {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final IntegerProperty CRACKED = ModBlockProperties.CRACKED;
    public static final BooleanProperty CAN_EXPAND = ModBlockProperties.CAN_EXPAND;

    public ThinIceBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CRACKED, (Comparable)Integer.valueOf(0))).m_61124_((Property)CAN_EXPAND, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{CRACKED, CAN_EXPAND});
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (!this.isDimEnoughToForm(state, level, pos)) {
            return false;
        }
        BlockState upState = level.m_8055_(pos.m_7494_());
        return state.m_60819_().m_192917_((Fluid)Fluids.f_76193_) && !upState.m_60819_().m_192917_((Fluid)Fluids.f_76193_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Level level = blockPlaceContext.m_43725_();
        BlockPos pos = blockPlaceContext.m_8083_();
        return this.getPlacement(level, pos);
    }

    private BlockState getPlacement(Level level, BlockPos pos) {
        boolean hasIce = false;
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            if (!this.canExpand(level, pos.m_121945_(dir))) continue;
            hasIce = true;
            break;
        }
        return (BlockState)this.m_49966_().m_61124_((Property)CAN_EXPAND, (Comparable)Boolean.valueOf(hasIce));
    }

    public boolean canExpand(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_204336_(ModTags.ICE) && ((Biome)level.m_204166_(pos).m_203334_()).m_198904_(pos);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.m_45517_(LightLayer.BLOCK, pos) > 11 - state.m_60739_((BlockGetter)level, pos)) {
            this.m_54168_(state, (Level)level, pos);
        }
        if (CommonConfigs.THIN_ICE_MELTING.get().booleanValue() && (level.m_6042_().f_63857_() || !level.m_46471_() && level.m_46461_() || !this.isDimEnoughToForm(state, (LevelReader)level, pos))) {
            level.m_46597_(pos, Blocks.f_49990_.m_49966_());
        }
    }

    private boolean isDimEnoughToForm(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_45517_(LightLayer.BLOCK, pos) < 7 - state.m_60739_((BlockGetter)level, pos);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        int i = (Integer)state.m_61143_((Property)CRACKED);
        if (!(entity instanceof LivingEntity) || EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44967_, (LivingEntity)((LivingEntity)entity)) > 0) {
            return;
        }
        if (!level.f_46443_ && level.f_46441_.m_188501_() < fallDistance - 0.5f && (entity instanceof Player || level.m_46469_().m_46207_(GameRules.f_46132_)) && entity.m_20205_() * entity.m_20205_() * entity.m_20206_() > 0.512f) {
            if (level.f_46441_.m_188499_()) {
                level.m_46597_(pos, ThinIceBlock.m_49897_((BlockState)state, (BlockState)Blocks.f_49990_.m_49966_(), (LevelAccessor)level, (BlockPos)pos));
                level.m_5594_(null, pos, SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (i < 3) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)CRACKED, (Comparable)Integer.valueOf(i + 1)));
                level.m_5594_(null, pos, ModSoundEvents.ICICLE_CRACK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (i == 3) {
                level.m_46597_(pos, ThinIceBlock.m_49897_((BlockState)state, (BlockState)Blocks.f_49990_.m_49966_(), (LevelAccessor)level, (BlockPos)pos));
                level.m_5594_(null, pos, SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        for (Direction direction : Direction.values()) {
            BlockState targetState = level.m_8055_(pos.m_121945_(direction));
            if (!level.m_8055_(pos.m_121945_(direction)).m_60713_((Block)this)) continue;
            int j = (Integer)targetState.m_61143_((Property)CRACKED);
            if (!level.f_46441_.m_188499_() || j >= 3) continue;
            level.m_46597_(pos.m_121945_(direction), (BlockState)this.m_152465_(targetState).m_61124_((Property)CRACKED, (Comparable)Integer.valueOf(j + 1)));
        }
        super.m_142072_(level, state, pos, entity, fallDistance);
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!(entity instanceof LivingEntity) || EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44967_, (LivingEntity)((LivingEntity)entity)) > 0) {
            return;
        }
        if (!level.f_46443_ && (entity instanceof Player || level.m_46469_().m_46207_(GameRules.f_46132_)) && entity.m_20205_() * entity.m_20205_() * entity.m_20206_() > 0.512f && level.f_46441_.m_188503_(15) == 0) {
            int i = (Integer)state.m_61143_((Property)CRACKED);
            if (i < 3) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)CRACKED, (Comparable)Integer.valueOf(i + 1)));
                level.m_5594_(null, pos, ModSoundEvents.ICICLE_CRACK.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (i == 3) {
                level.m_46597_(pos, ThinIceBlock.m_49897_((BlockState)state, (BlockState)Blocks.f_49990_.m_49966_(), (LevelAccessor)level, (BlockPos)pos));
                level.m_5594_(null, pos, SoundEvents.f_11983_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        super.m_141947_(level, pos, state, entity);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public FluidState m_5888_(BlockState blockState) {
        return Fluids.f_76193_.m_76068_(false);
    }

    public boolean m_6044_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return false;
    }

    public boolean m_7361_(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        return false;
    }
}

