/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.sandy;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.ordana.immersive_weathering.blocks.ModBlockProperties;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModTags;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public interface Sandy {
    public static final IntegerProperty SANDINESS = ModBlockProperties.SANDINESS;
    public static final IntegerProperty SAND_AGE = ModBlockProperties.SAND_AGE;
    public static final Supplier<BiMap<Block, Block>> NORMAL_TO_SANDY = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)Blocks.f_50069_, (Object)ModBlocks.SANDY_STONE.get()).put((Object)Blocks.f_50635_, (Object)ModBlocks.SANDY_STONE_STAIRS.get()).put((Object)Blocks.f_50404_, (Object)ModBlocks.SANDY_STONE_SLAB.get()).put((Object)ModBlocks.STONE_WALL.get(), (Object)ModBlocks.SANDY_STONE_WALL.get()).put((Object)Blocks.f_50652_, (Object)ModBlocks.SANDY_COBBLESTONE.get()).put((Object)Blocks.f_50157_, (Object)ModBlocks.SANDY_COBBLESTONE_STAIRS.get()).put((Object)Blocks.f_50409_, (Object)ModBlocks.SANDY_COBBLESTONE_SLAB.get()).put((Object)Blocks.f_50274_, (Object)ModBlocks.SANDY_COBBLESTONE_WALL.get()).put((Object)Blocks.f_50222_, (Object)ModBlocks.SANDY_STONE_BRICKS.get()).put((Object)Blocks.f_50225_, (Object)ModBlocks.SANDY_CHISELED_STONE_BRICKS.get()).put((Object)Blocks.f_50194_, (Object)ModBlocks.SANDY_STONE_BRICK_STAIRS.get()).put((Object)Blocks.f_50411_, (Object)ModBlocks.SANDY_STONE_BRICK_SLAB.get()).put((Object)Blocks.f_50609_, (Object)ModBlocks.SANDY_STONE_BRICK_WALL.get());
        return builder.build();
    });
    public static final Supplier<BiMap<Block, Block>> SANDY_TO_NORMAL = Suppliers.memoize(() -> NORMAL_TO_SANDY.get().inverse());

    public static Optional<BlockState> getSandy(BlockState state) {
        return Sandy.getSandy(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    public static Optional<BlockState> getUnSandy(BlockState state) {
        return Sandy.getUnSandy(state.m_60734_()).map(block -> block.m_152465_(state));
    }

    public static Optional<Block> getUnSandy(Block block) {
        return Optional.ofNullable((Block)SANDY_TO_NORMAL.get().get((Object)block));
    }

    public static Optional<Block> getSandy(Block block) {
        return Optional.ofNullable((Block)NORMAL_TO_SANDY.get().get((Object)block));
    }

    default public boolean interactWithPlayer(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        Optional<BlockState> unSandy = Sandy.getUnSandy(state);
        if (unSandy.isPresent() && item instanceof ShovelItem) {
            level.m_5594_(player, pos, SoundEvents.f_12331_, SoundSource.BLOCKS, 1.0f, 1.0f);
            ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_49992_.m_49966_()), (IntProvider)UniformInt.m_146622_((int)3, (int)5));
            stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(hand));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                level.m_46597_(pos, unSandy.get());
                if ((Integer)state.m_61143_((Property)ModBlockProperties.SANDINESS) == 0) {
                    level.m_46597_(pos, unSandy.get());
                }
                if ((Integer)state.m_61143_((Property)ModBlockProperties.SANDINESS) == 1) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)ModBlockProperties.SANDINESS, (Comparable)Integer.valueOf(0)));
                }
                if (!player.m_7500_() || CommonConfigs.CREATIVE_DROP.get().booleanValue()) {
                    Block.m_152435_((Level)level, (BlockPos)pos, (Direction)hitResult.m_82434_(), (ItemStack)new ItemStack((ItemLike)ModBlocks.SAND_LAYER_BLOCK.get()));
                }
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            }
            return true;
        }
        return false;
    }

    default public void spawnParticles(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockPos blockpos;
        BlockState blockstate;
        if (random.m_188503_(10) == 1 && !(blockstate = level.m_8055_(blockpos = pos.m_7495_())).m_60783_((BlockGetter)level, blockpos, Direction.UP)) {
            double d0 = (double)pos.m_123341_() + random.m_188500_();
            double d1 = (double)pos.m_123342_() - 0.05;
            double d2 = (double)pos.m_123343_() + random.m_188500_();
            if ((Integer)state.m_61143_((Property)ModBlockProperties.SANDINESS) == 0 && random.m_188503_(10) == 1) {
                level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_49992_.m_49966_()), d0, d1, d2, 0.0, 0.0, 0.0);
            } else {
                level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_49992_.m_49966_()), d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public static boolean isRandomSandyPos(BlockPos pos) {
        Random posRandom = new Random(Mth.m_14057_((Vec3i)pos));
        return posRandom.nextInt(5) > 2;
    }

    default public int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty());
    }

    default public IntegerProperty getAgeProperty() {
        return SAND_AGE;
    }

    default public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        Optional<BlockState> unSandy = Sandy.getUnSandy(state);
        Optional<BlockState> Sandy2 = Sandy.getSandy(belowState);
        if (belowState.m_60795_() && (Integer)state.m_61143_((Property)SAND_AGE) > 0) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SAND_AGE, (Comparable)Integer.valueOf(this.getAge(state) - 1)));
            level.m_46597_(belowPos, ModBlocks.SAND_LAYER_BLOCK.get().m_49966_());
        } else if (belowState.m_204336_(ModTags.DOUBLE_SANDABLE) && Sandy.isRandomSandyPos(pos) && Sandy2.isPresent()) {
            if ((Integer)state.m_61143_((Property)SANDINESS) == 1) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)SANDINESS, (Comparable)Integer.valueOf(0)));
            }
            if ((Integer)state.m_61143_((Property)SANDINESS) == 0 && unSandy.isPresent()) {
                level.m_46597_(pos, unSandy.get());
            }
            level.m_46597_(belowPos, Sandy2.get());
        }
    }

    default public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean isMoving) {
        Optional<BlockState> unSandy = Sandy.getUnSandy(state);
        BlockState neighborState = level.m_8055_(neighborPos);
        if (neighborState.m_60819_().m_192917_((Fluid)Fluids.f_76192_) && unSandy.isPresent()) {
            level.m_46597_(pos, unSandy.get());
            ItemStack stack = new ItemStack((ItemLike)ModBlocks.SAND_LAYER_BLOCK.get());
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
            level.m_5594_(null, pos, SoundEvents.f_12331_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_49992_.m_49966_()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.0);
            }
            ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_49992_.m_49966_()), (IntProvider)UniformInt.m_146622_((int)3, (int)5));
        }
    }
}

