/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.soil_types;

import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.util.WeatheringHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.lighting.LightEngine;

public class BaseSoilBlock
extends SnowyDirtBlock
implements BonemealableBlock {
    public BaseSoilBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public static boolean canBeGrass(BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        BlockState blockstate = levelReader.m_8055_(blockpos);
        if (blockstate.m_60713_(Blocks.f_50125_) && (Integer)blockstate.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        if (blockstate.m_60819_().m_76186_() == 8) {
            return false;
        }
        int i = LightEngine.m_284282_((BlockGetter)levelReader, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.m_60739_((BlockGetter)levelReader, blockpos));
        return i < levelReader.m_7469_();
    }

    public static boolean canPropagate(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        return BaseSoilBlock.canBeGrass(state, level, pos) && !level.m_6425_(blockpos).m_205070_(FluidTags.f_13131_);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.m_46803_(pos.m_7494_()) >= 9 && BaseSoilBlock.canBeGrass(state, (LevelReader)level, pos)) {
            for (int i = 0; i < 4; ++i) {
                BlockPos blockPos = pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(5) - 3, random.m_188503_(3) - 1);
                BlockState s = level.m_8055_(blockPos);
                Optional<BlockState> soil = WeatheringHelper.getGrassySoil(s);
                if (CommonConfigs.GRASS_OVER_MYCELIUM.get().booleanValue() && s.m_60713_(Blocks.f_50195_) && BaseSoilBlock.canPropagate(state, (LevelReader)level, blockPos)) {
                    level.m_46597_(blockPos, (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(level.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_50125_))));
                    continue;
                }
                if (!soil.isPresent() || !BaseSoilBlock.canPropagate(state, (LevelReader)level, blockPos)) continue;
                if (soil.get().m_61138_((Property)BlockStateProperties.f_61451_)) {
                    level.m_46597_(blockPos, (BlockState)soil.get().m_61124_((Property)BlockStateProperties.f_61451_, (Comparable)Boolean.valueOf(level.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_50125_))));
                    continue;
                }
                level.m_46597_(blockPos, soil.get());
            }
        }
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return level.m_8055_(pos.m_7494_()).m_60795_();
    }

    public boolean m_214167_(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos blockPos = pos.m_7494_();
        BlockState blockState = Blocks.f_50034_.m_49966_();
        Optional optional = level.m_9598_().m_175515_(Registries.f_256988_).m_203636_(VegetationPlacements.f_195459_);
        block0: for (int i = 0; i < 128; ++i) {
            Holder holder;
            BlockPos blockPos2 = blockPos;
            for (int j = 0; j < i / 16; ++j) {
                if (!level.m_8055_((blockPos2 = blockPos2.m_7918_(random.m_188503_(3) - 1, (random.m_188503_(3) - 1) * random.m_188503_(3) / 2, random.m_188503_(3) - 1)).m_7495_()).m_60713_((Block)this) || level.m_8055_(blockPos2).m_60838_((BlockGetter)level, blockPos2)) continue block0;
            }
            BlockState blockState2 = level.m_8055_(blockPos2);
            if (blockState2.m_60713_(blockState.m_60734_()) && random.m_188503_(10) == 0) {
                ((BonemealableBlock)blockState.m_60734_()).m_214148_(level, random, blockPos2, blockState2);
            }
            if (!blockState2.m_60795_()) continue;
            if (random.m_188503_(8) == 0) {
                List list = ((Biome)level.m_204166_(blockPos2).m_203334_()).m_47536_().m_47815_();
                if (list.isEmpty()) continue;
                holder = ((RandomPatchConfiguration)((ConfiguredFeature)list.get(0)).f_65378_()).f_191304_();
            } else {
                if (!optional.isPresent()) continue;
                holder = (Holder)optional.get();
            }
            ((PlacedFeature)holder.m_203334_()).m_226357_((WorldGenLevel)level, level.m_7726_().m_8481_(), random, blockPos2);
        }
    }
}

