/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths.area_condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.data.block_growths.area_condition.AreaCondition;
import com.ordana.immersive_weathering.data.block_growths.growths.ConfigurableBlockGrowth;
import com.ordana.immersive_weathering.util.StrOpt;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

record NeighborCheck(RuleTest mustHavePredicate, RuleTest mustNotHavePredicate, Integer requiredAmount, List<Direction> directions) implements AreaCondition
{
    public static final String NAME = "neighbor_based_generation";
    public static final Codec<NeighborCheck> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RuleTest.f_74307_.fieldOf("must_have").forGetter(NeighborCheck::mustHavePredicate), (App)StrOpt.of(RuleTest.f_74307_, "must_not_have", AlwaysTrueTest.f_73954_).forGetter(NeighborCheck::mustNotHavePredicate), (App)StrOpt.of(Codec.INT, "required_amount", 1).forGetter(NeighborCheck::requiredAmount), (App)StrOpt.of(Direction.f_175356_.listOf(), "directions", List.of(Direction.values())).forGetter(NeighborCheck::directions)).apply((Applicative)instance, NeighborCheck::new));
    static final AreaCondition.AreaConditionType<NeighborCheck> TYPE = new AreaCondition.AreaConditionType<NeighborCheck>(CODEC, "neighbor_based_generation");

    public AreaCondition.AreaConditionType<NeighborCheck> getType() {
        return TYPE;
    }

    @Override
    public boolean test(BlockPos pos, Level level, ConfigurableBlockGrowth config) {
        int count = 0;
        RandomSource random = RandomSource.m_216335_((long)Mth.m_14057_((Vec3i)pos));
        List list = Util.m_214661_(this.directions.stream(), (RandomSource)random);
        for (Direction dir : list) {
            BlockPos p = pos.m_121945_(dir);
            BlockState state = level.m_8055_(p);
            if (this.mustHavePredicate.m_213865_(state, random)) {
                ++count;
            } else if (this.mustNotHavePredicate != AlwaysTrueTest.f_73954_ && this.mustNotHavePredicate.m_213865_(state, random)) {
                return false;
            }
            if (count < this.requiredAmount) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMaxRange() {
        return 1;
    }
}

