/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.fluid_generators.builtin;

import com.mojang.serialization.Codec;
import com.ordana.immersive_weathering.blocks.mossy.Mossable;
import com.ordana.immersive_weathering.data.fluid_generators.IFluidGenerator;
import com.ordana.immersive_weathering.util.Weatherable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class BurnMossGenerator
implements IFluidGenerator {
    public static final BurnMossGenerator INSTANCE = new BurnMossGenerator();
    public static final Codec<BurnMossGenerator> CODEC = Codec.unit(() -> INSTANCE);
    public static final IFluidGenerator.Type<BurnMossGenerator> TYPE = new IFluidGenerator.Type<BurnMossGenerator>(CODEC, "burn_moss");

    @Override
    public Optional<BlockPos> tryGenerating(List<Direction> possibleFlowDir, BlockPos pos, Level level, Map<Direction, BlockState> neighborCache) {
        for (Direction d : possibleFlowDir) {
            BlockPos p;
            BlockState state = neighborCache.computeIfAbsent(d, arg_0 -> BurnMossGenerator.lambda$tryGenerating$1(level, p = pos.m_121945_(d), arg_0));
            BlockState s = Mossable.getUnaffectedMossBlock(state);
            if (s == state) continue;
            level.m_46597_(p, (BlockState)s.m_61124_((Property)Mossable.WEATHERABLE, (Comparable)((Object)Weatherable.WeatheringState.STABLE)));
            return Optional.of(p);
        }
        return Optional.empty();
    }

    @Override
    public Fluid getFluid() {
        return Fluids.f_76195_;
    }

    @Override
    public IFluidGenerator.FluidType getFluidType() {
        return IFluidGenerator.FluidType.BOTH;
    }

    @Override
    public IFluidGenerator.Type<?> getType() {
        return TYPE;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    private static /* synthetic */ BlockState lambda$tryGenerating$1(Level level, BlockPos p, Direction c) {
        return level.m_8055_(p);
    }
}

