/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.impactful.api.client;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.nameless.impactful.api.PropertiesReader;
import com.nameless.impactful.capabilities.ImpactfulCap;
import com.nameless.impactful.capabilities.ImpactfulCapabilities;
import com.nameless.impactful.client.CameraEngine;
import com.nameless.impactful.client.RadialBlurEngine;
import java.util.List;
import java.util.Map;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.compress.utils.Lists;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;

@OnlyIn(value=Dist.CLIENT)
public class VFXPropertiesReader {
    public static final PropertiesReader.SubFileType<VFXProperty> SUBFILE_VFX_PROPERTY = new VFXPropertyType();

    @OnlyIn(value=Dist.CLIENT)
    private static class VFXPropertyType
    extends PropertiesReader.SubFileType<VFXProperty> {
        private VFXPropertyType() {
            super("visual_effect", new VFXPropertyDeserializer());
        }

        @Override
        public void applySubFileInfo(VFXProperty deserialized, StaticAnimation animation) {
            if (animation instanceof AttackAnimation) {
                AttackAnimation attackAnimation = (AttackAnimation)animation;
                if (!deserialized.shake_entry_map.isEmpty()) {
                    deserialized.shake_entry_map.forEach((phase, entry) -> attackAnimation.addProperty(VFXAnimationProperties.SCREEN_SHAKE, entry, phase - 1));
                }
                if (!deserialized.radial_blur_map.isEmpty()) {
                    deserialized.radial_blur_map.forEach((phase, entry) -> attackAnimation.addProperty(VFXAnimationProperties.RADIAL_BLUR, entry, phase - 1));
                }
            }
            if (!deserialized.shakeEventList.isEmpty()) {
                deserialized.shakeEventList.forEach(entry -> animation.addEvents(AnimationProperty.StaticAnimationProperty.ON_BEGIN_EVENTS, new AnimationEvent[]{AnimationEvent.SimpleEvent.create((entityPatch, animation1, params) -> {
                    Player player;
                    ImpactfulCap impactfulCap;
                    Entity patt2934$temp = entityPatch.getOriginal();
                    if (patt2934$temp instanceof Player && (impactfulCap = (ImpactfulCap)(player = (Player)patt2934$temp).getCapability(ImpactfulCapabilities.INSTANCE).orElse(null)) != null) {
                        impactfulCap.ShakeCam((CameraEngine.ShakeEntry)entry);
                    }
                }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT)}));
            }
            if (!deserialized.blurEventList.isEmpty()) {
                deserialized.blurEventList.forEach(entry -> animation.addEvents(AnimationProperty.StaticAnimationProperty.ON_BEGIN_EVENTS, new AnimationEvent[]{AnimationEvent.SimpleEvent.create((entityPatch, animation1, params) -> {
                    Player player;
                    ImpactfulCap impactfulCap;
                    Entity patt3717$temp = entityPatch.getOriginal();
                    if (patt3717$temp instanceof Player && (impactfulCap = (ImpactfulCap)(player = (Player)patt3717$temp).getCapability(ImpactfulCapabilities.INSTANCE).orElse(null)) != null) {
                        impactfulCap.applyBlur((RadialBlurEngine.RadialBlur)entry);
                    }
                }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT)}));
            }
        }
    }

    public static class VFXAnimationProperties {
        @OnlyIn(value=Dist.CLIENT)
        public static final AnimationProperty.AttackPhaseProperty<CameraEngine.ShakeEntry> SCREEN_SHAKE = new AnimationProperty.AttackPhaseProperty();
        @OnlyIn(value=Dist.CLIENT)
        public static final AnimationProperty.AttackPhaseProperty<RadialBlurEngine.RadialBlur> RADIAL_BLUR = new AnimationProperty.AttackPhaseProperty();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class VFXPropertyDeserializer
    implements PropertiesReader.AnimationSubFileDeserializer<VFXProperty> {
        private VFXPropertyDeserializer() {
        }

        @Override
        public VFXProperty deserialize(StaticAnimation staticAnimation, JsonElement jsonElement) throws JsonParseException {
            int duration;
            float strength;
            JsonObject shakeEntry;
            JsonArray shakeEntries;
            VFXProperty property = new VFXProperty();
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has("hit_shake") && !(shakeEntries = jsonObject.get("hit_shake").getAsJsonArray()).isEmpty()) {
                shakeEntries.forEach(element -> {
                    JsonObject entry = element.getAsJsonObject();
                    int phase = GsonHelper.m_13927_((JsonObject)entry, (String)"phase");
                    double strength = GsonHelper.m_144784_((JsonObject)entry, (String)"strength");
                    int duration = GsonHelper.m_13927_((JsonObject)entry, (String)"duration");
                    property.shake_entry_map.put(phase, new CameraEngine.ShakeEntry(strength, duration));
                });
            }
            if (jsonObject.has("hit_blur") && !(shakeEntries = jsonObject.get("hit_blur").getAsJsonArray()).isEmpty()) {
                shakeEntries.forEach(element -> {
                    JsonObject entry = element.getAsJsonObject();
                    int phase = GsonHelper.m_13927_((JsonObject)entry, (String)"phase");
                    float strength = GsonHelper.m_13915_((JsonObject)entry, (String)"strength");
                    int duration = GsonHelper.m_13927_((JsonObject)entry, (String)"duration");
                    property.radial_blur_map.put(phase, new RadialBlurEngine.RadialBlur(duration, strength));
                });
            }
            if (jsonObject.has("event_shake") && (shakeEntry = jsonObject.getAsJsonObject("event_shake")) != null) {
                strength = GsonHelper.m_13915_((JsonObject)shakeEntry, (String)"strength");
                duration = GsonHelper.m_13927_((JsonObject)shakeEntry, (String)"duration");
                property.shakeEventList.add(new CameraEngine.ShakeEntry(strength, duration));
            }
            if (jsonObject.has("event_blur") && (shakeEntry = jsonObject.getAsJsonObject("event_blur")) != null) {
                strength = GsonHelper.m_13915_((JsonObject)shakeEntry, (String)"strength");
                duration = GsonHelper.m_13927_((JsonObject)shakeEntry, (String)"duration");
                property.blurEventList.add(new RadialBlurEngine.RadialBlur(duration, strength));
            }
            return property;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class VFXProperty {
        final Map<Integer, CameraEngine.ShakeEntry> shake_entry_map = Maps.newHashMap();
        final Map<Integer, RadialBlurEngine.RadialBlur> radial_blur_map = Maps.newHashMap();
        final List<CameraEngine.ShakeEntry> shakeEventList = Lists.newArrayList();
        final List<RadialBlurEngine.RadialBlur> blurEventList = Lists.newArrayList();

        VFXProperty() {
        }
    }
}

