/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.impactful.capabilities;

import com.google.common.collect.Maps;
import com.nameless.impactful.api.HitStopPropertiesReader;
import com.nameless.impactful.api.ICapabilityItem;
import com.nameless.impactful.client.CameraEngine;
import com.nameless.impactful.client.RadialBlurEngine;
import com.nameless.impactful.network.CPApplyVFX;
import com.nameless.impactful.network.NetWorkManger;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ImpactfulCap {
    public static final EntityDataAccessor<Boolean> HIT_STOP = new EntityDataAccessor(134, EntityDataSerializers.f_135035_);
    public int HIT_STOP_TIME = 0;
    public float HIT_STOP_SPEED = 1.0f;
    private static final UUID EVENT_UUID = UUID.fromString("a0081299-9a78-4aa2-8650-5496ea6cfe68");
    public static final Map<WeaponCategory, HitStop> hit_stop_by_weapon_categories = Maps.newHashMap();

    public void onInitiate(Player player) {
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        if (playerPatch != null) {
            playerPatch.getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID, event -> {
                Object patt2148$temp;
                if (event.getDamageSource() != null && (patt2148$temp = event.getDamageSource().getAnimation().get()) instanceof AttackAnimation) {
                    AttackAnimation animation = (AttackAnimation)patt2148$temp;
                    int weaponCategoryId = ((ServerPlayerPatch)event.getPlayerPatch()).getAdvancedHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory().universalOrdinal();
                    int animationId = animation.getId();
                    AnimationPlayer animationPlayer = ((ServerPlayerPatch)event.getPlayerPatch()).getAnimator().getPlayerFor((AssetAccessor)event.getDamageSource().getAnimation());
                    float elapsedTime = animationPlayer != null ? animationPlayer.getElapsedTime() : 0.0f;
                    NetWorkManger.sendToPlayer(new CPApplyVFX(weaponCategoryId, animationId, elapsedTime), (ServerPlayer)player);
                }
            });
            playerPatch.getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
                if (event.getDamageSource() != null && event.getDamageSource().getAnimation().get() instanceof AttackAnimation) {
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20088_().m_135381_(HIT_STOP, (Object)true);
                }
            });
            playerPatch.getEventListener().addEventListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, EVENT_UUID, event -> {
                StaticAnimation patt3439$temp = event.getAnimation();
                if (patt3439$temp instanceof AttackAnimation) {
                    AttackAnimation animation = (AttackAnimation)patt3439$temp;
                    CapabilityItem capabilityItem = playerPatch.getAdvancedHoldingItemCapability(InteractionHand.MAIN_HAND);
                    AnimationPlayer animationPlayer = event.getPlayerPatch().getAnimator().getPlayerFor((AssetAccessor)animation.getRealAnimation());
                    float elapsedTime = animationPlayer != null ? animationPlayer.getElapsedTime() : 0.0f;
                    HitStop hitStop = animation.getPhaseByTime(elapsedTime).getProperty(HitStopPropertiesReader.HIT_STOP).orElse(((ICapabilityItem)capabilityItem).getHitStopEntry());
                    if (hitStop != null) {
                        this.HIT_STOP_TIME = hitStop.duration();
                        this.HIT_STOP_SPEED = hitStop.speed();
                    }
                }
            });
            playerPatch.getEventListener().addEventListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID, event -> ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20088_().m_135381_(HIT_STOP, (Object)false));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void ShakeCam(CameraEngine.ShakeEntry entry) {
        CameraEngine.getInstance().shakeCamera(entry);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void applyBlur(RadialBlurEngine.RadialBlur blur) {
        RadialBlurEngine.getInstance().applyRadialBlurByAnim(blur);
    }

    public record HitStop(int duration, float speed) {
        public HitStop copy() {
            return new HitStop(this.duration, this.speed);
        }
    }
}

