/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.impactful.client;

import com.google.common.collect.Maps;
import com.nameless.impactful.api.client.VFXPropertiesReader;
import com.nameless.impactful.client.IRenderItemBase;
import com.nameless.impactful.config.ClientConfig;
import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.world.capabilities.item.WeaponCategory;

@OnlyIn(value=Dist.CLIENT)
public class CameraEngine {
    private static CameraEngine instance;
    private final PriorityQueue<ShakeEntry> queue = new PriorityQueue<ShakeEntry>(Comparator.comparingDouble(e -> -e.strength));
    public static final Map<WeaponCategory, ShakeEntry> camera_shake_by_weapon_categories;
    private final ShakeEntry default_entry = new ShakeEntry(1.0, 3, 0.3);

    public CameraEngine() {
        instance = this;
    }

    public static CameraEngine getInstance() {
        return instance;
    }

    public PriorityQueue<ShakeEntry> getQueue() {
        return this.queue;
    }

    public void tick(ViewportEvent.ComputeCameraAngles event, Player player) {
        if (((Boolean)ClientConfig.DISABLE_SCREEN_SHAKE.get()).booleanValue() || Minecraft.m_91087_().m_91104_() || this.queue.isEmpty()) {
            return;
        }
        this.queue.removeIf(entry -> {
            --entry.remainingTicks;
            entry.strength *= 0.97;
            entry.frequency *= 0.97;
            return entry.remainingTicks <= 0;
        });
        if (!this.queue.isEmpty()) {
            ShakeEntry top = this.queue.peek();
            double ticksExistedDelta = (double)player.f_19797_ + event.getPartialTick();
            double k = top.strength / 4.0 * (double)((Double)ClientConfig.SCREEN_SHAKE_AMPLITUDE_RATE.get()).floatValue();
            double f = top.frequency;
            event.setPitch((float)((double)event.getPitch() + k * Math.cos(ticksExistedDelta * f + 2.0)));
            event.setYaw((float)((double)event.getYaw() + k * Math.cos(ticksExistedDelta * f + 1.0)));
            event.setRoll((float)((double)event.getRoll() + k * Math.cos(ticksExistedDelta * f)));
            top.strength *= 0.97;
        }
    }

    public void shakeCamera(ShakeEntry entry) {
        ShakeEntry entry1 = entry.copy();
        this.queue.add(entry1);
    }

    public void shakeCamera(float strength, int time, float frequency) {
        this.shakeCamera(new ShakeEntry(strength, time, frequency));
    }

    public void shakeCamera(int time, float strength) {
        this.shakeCamera(new ShakeEntry(strength, time, 0.3));
    }

    public void shakeCameraByAnim(int animationId, float elapsedTime) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        RenderItemBase renderitembase = ClientEngine.getInstance().renderEngine.getItemRenderer(stack);
        ShakeEntry shakeEntry = ((IRenderItemBase)renderitembase).getShakeEntry() != null ? ((IRenderItemBase)renderitembase).getShakeEntry() : this.default_entry;
        Object object = AnimationManager.byId((int)animationId).get();
        if (object instanceof AttackAnimation) {
            AttackAnimation attackAnimation = (AttackAnimation)object;
            shakeEntry = attackAnimation.getPhaseByTime(elapsedTime).getProperty(VFXPropertiesReader.VFXAnimationProperties.SCREEN_SHAKE).orElse(shakeEntry);
        }
        this.shakeCamera(shakeEntry);
    }

    static {
        camera_shake_by_weapon_categories = Maps.newHashMap();
    }

    public static class ShakeEntry {
        double strength;
        int remainingTicks;
        double frequency;

        public ShakeEntry(double strength, int tick, double frequency) {
            this.strength = strength;
            this.remainingTicks = tick;
            this.frequency = frequency;
        }

        public ShakeEntry(double strength, int tick) {
            this(strength, tick, 0.3f);
        }

        public ShakeEntry copy() {
            return new ShakeEntry(this.strength, this.remainingTicks, this.frequency);
        }
    }

    @Mod.EventBusSubscriber(modid="impactful", value={Dist.CLIENT})
    public static class Events {
        @SubscribeEvent(priority=EventPriority.LOW)
        public static void cameraSetupEvent(ViewportEvent.ComputeCameraAngles event) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            instance.tick(event, (Player)player);
        }
    }
}

