/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.impactful.mixin.common;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.nameless.impactful.api.HitStopPropertiesReader;
import com.nameless.impactful.api.PropertiesReader;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.exception.AssetLoadingException;
import yesman.epicfight.api.utils.MutableBoolean;
import yesman.epicfight.main.EpicFightMod;

@Mixin(value={AnimationManager.class})
public class AnimationManagerCommonMixin {
    @Shadow
    @Final
    private Map<AnimationManager.AnimationAccessor<? extends StaticAnimation>, StaticAnimation> animations;

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="TAIL")}, cancellable=false, remap=false)
    public void loadHitStop(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManager, ProfilerFiller profilerIn, CallbackInfo ci) {
        this.animations.entrySet().stream().reduce(Lists.newArrayList(), (list, entry) -> {
            MutableBoolean init = new MutableBoolean(true);
            if (entry.getValue() == null || ((StaticAnimation)entry.getValue()).getAccessor() == null) {
                EpicFightMod.logAndStacktraceIfDevSide(Logger::error, (String)("Invalid animation implementation: " + entry.getKey()), AssetLoadingException::new);
                init.set(false);
            }
            ((StaticAnimation)entry.getValue()).getSubAnimations().forEach(subAnimation -> {
                if (subAnimation == null || subAnimation.get() == null) {
                    EpicFightMod.logAndStacktraceIfDevSide(Logger::error, (String)("Invalid sub animation implementation: " + entry.getKey()), AssetLoadingException::new);
                    init.set(false);
                }
            });
            if (init.value()) {
                list.add(((StaticAnimation)entry.getValue()).getAccessor());
                list.addAll(((StaticAnimation)entry.getValue()).getSubAnimations());
            }
            return list;
        }, (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        }).forEach(accessor -> {
            accessor.doOrThrow(StaticAnimation::postInit);
            ResourceLocation vfxLocation = PropertiesReader.getSubAnimationFileLocation(((StaticAnimation)accessor.get()).getLocation(), HitStopPropertiesReader.SUBFILE_HS_PROPERTY);
            AnimationManager.getAnimationResourceManager().m_213713_(vfxLocation).ifPresent(rs -> PropertiesReader.readAndApply((StaticAnimation)accessor.get(), rs, HitStopPropertiesReader.SUBFILE_HS_PROPERTY));
        });
    }
}

