/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.impactful.network;

import com.nameless.impactful.client.CameraEngine;
import com.nameless.impactful.config.ClientConfig;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class CPApplyShake {
    private final int time;
    private final float strength;
    private final float frequency;

    public CPApplyShake(int time, float strength, float frequency) {
        this.time = time;
        this.strength = strength;
        this.frequency = frequency;
    }

    public CPApplyShake(FriendlyByteBuf buf) {
        this.time = buf.readInt();
        this.strength = buf.readFloat();
        this.frequency = buf.readFloat();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.time);
        buf.writeFloat(this.strength);
        buf.writeFloat(this.frequency);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (!((Boolean)ClientConfig.DISABLE_SCREEN_SHAKE.get()).booleanValue()) {
                CameraEngine.getInstance().shakeCamera(this.strength, this.time, this.frequency);
            }
        });
        context.get().setPacketHandled(true);
    }
}

