/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.capability;

import com.p1nero.invincible.capability.InvincibleEntity;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@Mod.EventBusSubscriber(modid="invincible")
public class InvincibleEntityCapabilityProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static Capability<InvincibleEntity> INVINCIBLE_ENTITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<InvincibleEntity>(){});
    private InvincibleEntity InvincibleEntity = null;
    private final LazyOptional<InvincibleEntity> optional = LazyOptional.of(this::createInvincibleEntity);

    private InvincibleEntity createInvincibleEntity() {
        if (this.InvincibleEntity == null) {
            this.InvincibleEntity = new InvincibleEntity();
        }
        return this.InvincibleEntity;
    }

    public static InvincibleEntity get(LivingEntity entity) {
        return (InvincibleEntity)entity.getCapability(INVINCIBLE_ENTITY).orElse((Object)new InvincibleEntity());
    }

    public static InvincibleEntity get(LivingEntityPatch<?> patch) {
        return InvincibleEntityCapabilityProvider.get((LivingEntity)patch.getOriginal());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
        if (capability == INVINCIBLE_ENTITY) {
            return this.optional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.createInvincibleEntity().saveNBTData(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.createInvincibleEntity().loadNBTData(tag);
    }
}

