/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.client;

import com.p1nero.invincible.InvincibleConfig;
import com.p1nero.invincible.api.events.Side;
import com.p1nero.invincible.api.skill.ComboNode;
import com.p1nero.invincible.api.skill.ComboType;
import com.p1nero.invincible.capability.InvinciblePlayer;
import com.p1nero.invincible.capability.InvinciblePlayerCapabilityProvider;
import com.p1nero.invincible.client.InvincibleKeyMappings;
import com.p1nero.invincible.gameassets.InvincibleSkillDataKeys;
import com.p1nero.invincible.skill.AbstractInvincibleInnateSkill;
import com.p1nero.invincible.skill.ComboBasicAttack;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPSkillRequest;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.eventlistener.SkillCastEvent;

@Mod.EventBusSubscriber(modid="invincible", value={Dist.CLIENT})
public class InputManager {
    private static int reserveCounter;
    private static long lastInputTime;
    private static long inputInterval;
    private static final Map<ComboType, KeyMapping> TYPE_KEY_MAP;
    private static final Map<Integer, Integer> KEY_STATE_CACHE;
    private static final Queue<Integer> INPUT_QUEUE;
    private static ComboNode currentNode;

    public static ComboNode getCurrentNode() {
        return currentNode;
    }

    public static void init() {
        InputManager.register(ComboNode.ComboTypes.KEY_1, InvincibleKeyMappings.KEY1);
        InputManager.register(ComboNode.ComboTypes.KEY_2, InvincibleKeyMappings.KEY2);
        InputManager.register(ComboNode.ComboTypes.KEY_3, InvincibleKeyMappings.KEY3);
        InputManager.register(ComboNode.ComboTypes.KEY_4, InvincibleKeyMappings.KEY4);
        InputManager.register(ComboNode.ComboTypes.DODGE, EpicFightKeyMappings.DODGE);
        InputManager.register(ComboNode.ComboTypes.WEAPON_INNATE, EpicFightKeyMappings.WEAPON_INNATE_SKILL);
    }

    public static void register(ComboType type, KeyMapping keyMapping) {
        TYPE_KEY_MAP.put(type, keyMapping);
        KEY_STATE_CACHE.put(keyMapping.getKey().m_84873_(), 0);
    }

    public static int getPressedTickFor(ComboType comboType) {
        return InputManager.testPressedTime(comboType);
    }

    @Nullable
    public static ComboBasicAttack getComboBasicSkill() {
        LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
        if (localPlayerPatch == null) {
            return null;
        }
        Skill skill = localPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill();
        if (skill instanceof ComboBasicAttack) {
            ComboBasicAttack comboBasicAttack = (ComboBasicAttack)skill;
            return comboBasicAttack;
        }
        return null;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START || Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
        if (localPlayerPatch != null && Minecraft.m_91087_().m_91403_() != null) {
            SkillContainer container;
            if (reserveCounter > 0) {
                --reserveCounter;
                if (InputManager.tryRequestSkillExecute(false)) {
                    InputManager.clearReservedKeys();
                    InputManager.clearKeyCache();
                }
                if (reserveCounter == 0) {
                    InputManager.clearReservedKeys();
                    InputManager.clearKeyCache();
                }
            } else {
                InputManager.handlePressing();
            }
            if ((container = localPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE)).getSkill() instanceof AbstractInvincibleInnateSkill) {
                Options options = Minecraft.m_91087_().f_91066_;
                SkillDataManager manager = container.getDataManager();
                InputManager.checkDirectionKeyDown(manager, (SkillDataKey<Boolean>)((SkillDataKey)InvincibleSkillDataKeys.UP.get()), options.f_92085_);
                InputManager.checkDirectionKeyDown(manager, (SkillDataKey<Boolean>)((SkillDataKey)InvincibleSkillDataKeys.DOWN.get()), options.f_92087_);
                InputManager.checkDirectionKeyDown(manager, (SkillDataKey<Boolean>)((SkillDataKey)InvincibleSkillDataKeys.LEFT.get()), options.f_92086_);
                InputManager.checkDirectionKeyDown(manager, (SkillDataKey<Boolean>)((SkillDataKey)InvincibleSkillDataKeys.RIGHT.get()), options.f_92088_);
            }
        }
        while (INPUT_QUEUE.size() > 2) {
            Integer keyId = INPUT_QUEUE.poll();
            if (INPUT_QUEUE.contains(keyId)) continue;
            KEY_STATE_CACHE.put(keyId, 0);
        }
    }

    private static void checkDirectionKeyDown(SkillDataManager manager, SkillDataKey<Boolean> skillDataKey, KeyMapping key) {
        if (((Boolean)manager.getDataValue(skillDataKey)).booleanValue() != key.m_90857_()) {
            manager.setDataSync(skillDataKey, (Object)key.m_90857_());
        }
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton event) {
        InputManager.handleInput(event.getButton(), event.getAction());
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        InputManager.handleInput(event.getKey(), event.getAction());
    }

    private static void handleInput(int key, int action) {
        LocalPlayerPatch playerPatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerPatch != null && Minecraft.m_91087_().f_91080_ == null && !Minecraft.m_91087_().m_91104_() && playerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill() instanceof ComboBasicAttack) {
            if (action == 1) {
                for (KeyMapping keyMapping : TYPE_KEY_MAP.values()) {
                    int keyId = keyMapping.getKey().m_84873_();
                    if (key != keyId) continue;
                    if (!INPUT_QUEUE.contains(keyId)) {
                        INPUT_QUEUE.add(keyId);
                    }
                    KEY_STATE_CACHE.put(keyId, KEY_STATE_CACHE.getOrDefault(keyId, 0) + 1);
                    InputManager.clearReservedKeys();
                }
            }
            if (action == 0) {
                InputManager.tryRequestSkillExecute(true);
            }
        }
    }

    private static void handlePressing() {
        AtomicBoolean shouldExecute = new AtomicBoolean(false);
        int maxPressTick = (Integer)InvincibleConfig.MAX_PRESS_TICK.get();
        ComboBasicAttack comboBasicAttack = InputManager.getComboBasicSkill();
        if (comboBasicAttack != null) {
            maxPressTick = comboBasicAttack.getMaxPressTime();
        }
        int finalMaxPressTick = maxPressTick;
        KEY_STATE_CACHE.forEach((keyId, integer) -> {
            if (integer > 0) {
                KEY_STATE_CACHE.put((Integer)keyId, integer + 1);
                if (integer > finalMaxPressTick) {
                    shouldExecute.set(true);
                }
            }
        });
        if (shouldExecute.get()) {
            InputManager.tryRequestSkillExecute(true);
        }
    }

    public static void clearKeyCache() {
        KEY_STATE_CACHE.forEach((keyId, aInt) -> KEY_STATE_CACHE.put((Integer)keyId, 0));
        INPUT_QUEUE.clear();
    }

    public static void clearReservedKeys() {
        reserveCounter = -1;
    }

    public static void setReserveCounter(int reserveCounter) {
        InputManager.reserveCounter = reserveCounter;
    }

    public static void setReserve() {
        reserveCounter = (Integer)InvincibleConfig.RESERVE_TICK.get();
        ComboBasicAttack comboBasicAttack = InputManager.getComboBasicSkill();
        if (comboBasicAttack != null) {
            reserveCounter = comboBasicAttack.getMaxReserveTime();
        }
    }

    public static boolean tryRequestSkillExecute(boolean shouldReserve) {
        SkillSlots slot = SkillSlots.WEAPON_INNATE;
        LocalPlayerPatch executor = ClientEngine.getInstance().getPlayerPatch();
        if (executor != null && executor.getPlayerMode() == PlayerPatch.PlayerMode.EPICFIGHT) {
            if (InputManager.sendExecuteRequest(executor, executor.getSkill((SkillSlot)slot)).shouldReserveKey()) {
                if (shouldReserve) {
                    InputManager.setReserve();
                }
                return false;
            }
            InputManager.clearKeyCache();
            return true;
        }
        return false;
    }

    public static SkillCastEvent sendExecuteRequest(LocalPlayerPatch executor, SkillContainer container) {
        SkillCastEvent event = new SkillCastEvent((PlayerPatch)executor, container, null);
        InvinciblePlayer invinciblePlayer = InvinciblePlayerCapabilityProvider.get((Player)executor.getOriginal());
        currentNode = invinciblePlayer.getCurrentNode();
        if (container.canUse((PlayerPatch)executor, event)) {
            for (CPSkillRequest packet : InputManager.getAvailablePackets(container)) {
                EpicFightNetworkManager.sendToServer((Object)packet);
            }
        }
        return event;
    }

    public static List<CPSkillRequest> getAvailablePackets(SkillContainer container) {
        ArrayList<CPSkillRequest> list = new ArrayList<CPSkillRequest>();
        ArrayList<ComboType> typeList = new ArrayList<ComboType>(ComboType.ENUM_MANAGER.universalValues().stream().toList());
        typeList.sort(Comparator.comparingInt(comboType -> -1 * comboType.getSubTypes().size()));
        for (ComboType comboType2 : typeList) {
            int pressedTime = InputManager.testPressedTime(comboType2);
            if (pressedTime <= 0 || !InputManager.testClientConditions(comboType2)) continue;
            inputInterval = System.currentTimeMillis() - lastInputTime;
            list.add(InputManager.getExecutePacket(container.getSlot(), comboType2, pressedTime, inputInterval));
            if (comboType2.getSubTypes().isEmpty()) continue;
            break;
        }
        if (!list.isEmpty()) {
            lastInputTime = System.currentTimeMillis();
        }
        return list;
    }

    public static CPSkillRequest getExecutePacket(SkillSlot slot, ComboType comboType, int pressedTime, long inputInterval) {
        CPSkillRequest packet = new CPSkillRequest(slot);
        packet.getBuffer().writeInt(comboType.universalOrdinal());
        packet.getBuffer().writeInt(pressedTime);
        packet.getBuffer().writeLong(inputInterval);
        return packet;
    }

    public static int testPressedTime(ComboType comboType) {
        if (comboType.getSubTypes().isEmpty()) {
            KeyMapping keyMapping = TYPE_KEY_MAP.get(comboType);
            if (keyMapping == null || !KEY_STATE_CACHE.containsKey(keyMapping.getKey().m_84873_())) {
                return 0;
            }
            int pressedTime = KEY_STATE_CACHE.getOrDefault(keyMapping.getKey().m_84873_(), 0);
            return Math.max(pressedTime, 0);
        }
        int maxPressedTime = 0;
        for (ComboType subType : comboType.getSubTypes()) {
            int currentPressedTime = InputManager.testPressedTime(subType);
            if (currentPressedTime == 0) {
                return 0;
            }
            if (currentPressedTime <= maxPressedTime) continue;
            maxPressedTime = currentPressedTime;
        }
        return maxPressedTime;
    }

    public static boolean testClientConditions(ComboType comboType) {
        LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
        if (currentNode == null) {
            return false;
        }
        ComboNode next = currentNode.getNext(comboType);
        if (next == null) {
            return false;
        }
        for (Condition condition : next.getConditions(Side.CLIENT, Side.LOCAL_CLIENT, Side.BOTH)) {
            if (condition.predicate((Object)localPlayerPatch)) continue;
            return false;
        }
        return true;
    }

    static {
        TYPE_KEY_MAP = new HashMap<ComboType, KeyMapping>();
        KEY_STATE_CACHE = new HashMap<Integer, Integer>();
        INPUT_QUEUE = new ArrayDeque<Integer>();
    }
}

