/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillSlot;

public class AllSkillArgument
implements ArgumentType<Skill> {
    private static final Collection<String> EXAMPLES = Arrays.asList("epicfight:dodge");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_SKILL = new DynamicCommandExceptionType(obj -> Component.m_237110_((String)"epicfight.skillNotFound", (Object[])new Object[]{obj}));

    public static AllSkillArgument skill() {
        return new AllSkillArgument();
    }

    public static Skill getSkill(CommandContext<CommandSourceStack> commandContext, String name) {
        return (Skill)commandContext.getArgument(name, Skill.class);
    }

    public Skill parse(StringReader p_98428_) throws CommandSyntaxException {
        ResourceLocation resourcelocation = ResourceLocation.m_135818_((StringReader)p_98428_);
        Skill skill = SkillManager.getSkill((String)resourcelocation.toString());
        return Optional.ofNullable(skill).orElseThrow(() -> ERROR_UNKNOWN_SKILL.create((Object)resourcelocation));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        SkillCategory skillCategory;
        CommandNode commandNode;
        if (commandContext.getNodes().size() > 5 && (commandNode = ((ParsedCommandNode)commandContext.getNodes().get(4)).getNode()) instanceof LiteralCommandNode) {
            LiteralCommandNode literalNode = (LiteralCommandNode)commandNode;
            skillCategory = AllSkillArgument.nullParam((SkillSlot)SkillSlot.ENUM_MANAGER.getOrThrow(literalNode.getLiteral()));
        } else {
            skillCategory = null;
        }
        SkillCategory skillCategory2 = skillCategory;
        return SharedSuggestionProvider.m_82957_((Stream)SkillManager.getSkillNames(skill -> skillCategory2 == null || skill.getCategory().equals(skillCategory2)), (SuggestionsBuilder)suggestionsBuilder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static SkillCategory nullParam(SkillSlot slot) {
        return slot == null ? null : slot.category();
    }
}

