/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.compat.controlify;

import com.p1nero.invincible.InvincibleMod;
import com.p1nero.invincible.client.InvincibleKeyMappings;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.api.bind.ControlifyBindApi;
import dev.isxander.controlify.api.bind.InputBindingSupplier;
import dev.isxander.controlify.api.entrypoint.ControlifyEntrypoint;
import dev.isxander.controlify.api.entrypoint.InitContext;
import dev.isxander.controlify.api.entrypoint.PreInitContext;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.RadialIcons;
import dev.isxander.controlify.utils.render.Blit;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;

public class ControlifyCompat
implements ControlifyEntrypoint {
    private static InputBindingSupplier primaryAction;
    private static InputBindingSupplier secondaryAction;
    private static InputBindingSupplier specialAbility1;
    private static InputBindingSupplier specialAbility2;
    private static final BindContext IN_GAME_EPIC_FIGHT_CONTEXT;

    public void onControllersDiscovered(ControlifyApi controlify) {
    }

    public void onControlifyInit(InitContext context) {
    }

    public void onControlifyPreInit(PreInitContext context) {
        ControlifyBindApi registrar = ControlifyBindApi.get();
        ControlifyCompat.registerCustomRadialIcons();
        registrar.registerBindContext(IN_GAME_EPIC_FIGHT_CONTEXT);
        ControlifyCompat.registerInputBindings(registrar);
    }

    private static void registerInputBindings(ControlifyBindApi registrar) {
        primaryAction = registrar.registerBinding(builder -> builder.id(InvincibleMod.rl("primary_action")).category(ComponentConstants.COMMON_CATEGORY).allowedContexts(new BindContext[]{IN_GAME_EPIC_FIGHT_CONTEXT}).name(ComponentConstants.PRIMARY_ACTION).description(ComponentConstants.PRIMARY_ACTION_DESCRIPTION).addKeyCorrelation(InvincibleKeyMappings.KEY1).keyEmulation(InvincibleKeyMappings.KEY1));
        secondaryAction = registrar.registerBinding(builder -> builder.id(InvincibleMod.rl("secondary_action")).category(ComponentConstants.COMMON_CATEGORY).allowedContexts(new BindContext[]{IN_GAME_EPIC_FIGHT_CONTEXT}).name(ComponentConstants.SECONDARY_ACTION).description(ComponentConstants.SECONDARY_ACTION_DESCRIPTION).addKeyCorrelation(InvincibleKeyMappings.KEY2).keyEmulation(InvincibleKeyMappings.KEY2));
        specialAbility1 = registrar.registerBinding(builder -> builder.id(InvincibleMod.rl("special_ability_1")).category(ComponentConstants.COMMON_CATEGORY).allowedContexts(new BindContext[]{IN_GAME_EPIC_FIGHT_CONTEXT}).name(ComponentConstants.SPECIAL_ABILITY_1).description(ComponentConstants.SPECIAL_ABILITY_1_DESCRIPTION).addKeyCorrelation(InvincibleKeyMappings.KEY3).keyEmulation(InvincibleKeyMappings.KEY3).radialCandidate(InvincibleRadialIcons.COMBO_ATTACKS.getId()));
        specialAbility2 = registrar.registerBinding(builder -> builder.id(InvincibleMod.rl("special_ability_2")).category(ComponentConstants.COMMON_CATEGORY).allowedContexts(new BindContext[]{IN_GAME_EPIC_FIGHT_CONTEXT}).name(ComponentConstants.SPECIAL_ABILITY_2).description(ComponentConstants.SPECIAL_ABILITY_2_DESCRIPTION).addKeyCorrelation(InvincibleKeyMappings.KEY4).keyEmulation(InvincibleKeyMappings.KEY4).radialCandidate(InvincibleRadialIcons.COMBO_ATTACKS.getId()));
    }

    private static void registerCustomRadialIcons() {
        for (InvincibleRadialIcons icon : InvincibleRadialIcons.values()) {
            ResourceLocation location = icon.getId();
            RadialIcons.registerIcon((ResourceLocation)location, (graphics, x, y, tickDelta) -> {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
                graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
                Blit.blitTex((GuiGraphics)graphics, (ResourceLocation)location, (int)0, (int)0, (int)0, (int)0, (int)32, (int)32, (int)32, (int)32);
                graphics.m_280168_().m_85849_();
            });
        }
    }

    static {
        IN_GAME_EPIC_FIGHT_CONTEXT = new BindContext(InvincibleMod.rl("epicfight_combat"), mc -> {
            boolean isInGame = mc.f_91080_ == null && mc.f_91073_ != null && mc.f_91074_ != null;
            LocalPlayerPatch localPlayerPatch = ClientEngine.getInstance().getPlayerPatch();
            if (localPlayerPatch == null) {
                return false;
            }
            return isInGame && localPlayerPatch.isEpicFightMode();
        });
    }

    private static enum InvincibleRadialIcons {
        COMBO_ATTACKS(InvincibleMod.rl("textures/gui/skills/weapon_innate/combo_demo.png"));

        @NotNull
        private final ResourceLocation id;

        private InvincibleRadialIcons(ResourceLocation id) {
            this.id = id;
        }

        @NotNull
        public ResourceLocation getId() {
            return this.id;
        }
    }

    private static class ComponentConstants {
        private static final Component COMMON_CATEGORY = Component.m_237115_((String)"key.invincible.category");
        private static final Component PRIMARY_ACTION = Component.m_237115_((String)"key.invincible.key1");
        private static final Component SECONDARY_ACTION = Component.m_237115_((String)"key.invincible.key2");
        private static final Component SPECIAL_ABILITY_1 = Component.m_237115_((String)"key.invincible.key3");
        private static final Component SPECIAL_ABILITY_2 = Component.m_237115_((String)"key.invincible.key4");
        private static final Component PRIMARY_ACTION_DESCRIPTION = Component.m_237115_((String)"key.invincible.key1.description");
        private static final Component SECONDARY_ACTION_DESCRIPTION = Component.m_237115_((String)"key.invincible.key2.description");
        private static final Component SPECIAL_ABILITY_1_DESCRIPTION = Component.m_237115_((String)"key.invincible.key3.description");
        private static final Component SPECIAL_ABILITY_2_DESCRIPTION = Component.m_237115_((String)"key.invincible.key4.description");

        private ComponentConstants() {
        }
    }
}

