/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.p1nero.invincible.api.events.BaseEvent;
import com.p1nero.invincible.api.events.TimeStampedEvent;
import com.p1nero.invincible.api.skill.ComboNode;
import com.p1nero.invincible.skill.ComboBasicAttack;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Unique;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.data.reloader.MobPatchReloadListener;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.damagesource.StunType;

public class ComboJsonLoader {
    public static void loadCombos(CompoundTag data) throws CommandSyntaxException {
        ComboJsonLoader.loadCombos(JsonParser.parseString((String)data.toString()).getAsJsonObject());
    }

    public static ComboBasicAttack.Builder loadCombos(JsonObject comboType) throws CommandSyntaxException {
        boolean drawSkillIcon = false;
        if (comboType.has("drawSkillIcon")) {
            drawSkillIcon = comboType.get("drawSkillIcon").getAsBoolean();
        }
        JsonArray combos = comboType.getAsJsonArray("combos");
        ComboNode root = ComboNode.create();
        ComboJsonLoader.deserializeCombos(root, combos);
        ArrayList<String> tipList = new ArrayList<String>();
        if (comboType.has("descriptions")) {
            for (JsonElement element : comboType.get("descriptions").getAsJsonArray()) {
                tipList.add(element.getAsString());
            }
        }
        ResourceLocation resourceLocation = null;
        if (comboType.has("skillTextureLocation")) {
            resourceLocation = ResourceLocation.parse((String)comboType.get("skillTextureLocation").getAsString());
        }
        ComboBasicAttack.Builder builder = ComboBasicAttack.createComboBasicAttack().setShouldDrawGui(drawSkillIcon).setCombo(root).addToolTipOnItem(tipList).setSkillTextureLocation(resourceLocation);
        if (comboType.has("maxProtectTime")) {
            builder.setMaxProtectTime(comboType.get("maxProtectTime").getAsInt());
        }
        if (comboType.has("maxPressTime")) {
            builder.setMaxPressTime(comboType.get("maxPressTime").getAsInt());
        }
        if (comboType.has("reserveTime")) {
            builder.setReserveTime(comboType.get("reserveTime").getAsInt());
        }
        return builder;
    }

    @Unique
    public static void deserializeCombos(ComboNode parent, JsonArray combos) throws CommandSyntaxException {
        for (JsonElement comboElement : combos) {
            JsonObject combo = comboElement.getAsJsonObject();
            ComboNode child = ComboNode.create();
            if (combo.has("condition_animations")) {
                JsonArray conditionAnimationsListList = combo.getAsJsonArray("condition_animations");
                ComboJsonLoader.deserializeCombos(child, conditionAnimationsListList);
            } else {
                JsonArray commandList;
                String animation = combo.get("animation").getAsString();
                child.setAnimationProvider((AnimationManager.AnimationAccessor<? extends StaticAnimation>)AnimationManager.byKey((String)animation));
                child.setAnimationName(animation);
                if (combo.has("speed_multiplier")) {
                    child.setPlaySpeed(combo.get("speed_multiplier").getAsFloat());
                }
                if (combo.has("damage_multiplier")) {
                    JsonObject valueModifier = combo.getAsJsonObject("damage_multiplier");
                    float adder = 0.0f;
                    float multiplier = 1.0f;
                    float setter = Float.NaN;
                    if (valueModifier.has("adder")) {
                        adder = valueModifier.get("adder").getAsFloat();
                    }
                    if (valueModifier.has("multiplier")) {
                        multiplier = valueModifier.get("multiplier").getAsFloat();
                    }
                    if (valueModifier.has("setter")) {
                        setter = valueModifier.get("setter").getAsFloat();
                    }
                    child.setDamageMultiplier((ValueModifier)new ValueModifier.Unified(adder, multiplier, setter));
                }
                if (combo.has("hurt_damage_multiplier")) {
                    child.setHurtDamageMultiplier(combo.get("hurt_damage_multiplier").getAsFloat());
                }
                if (combo.has("armor_negation")) {
                    child.setArmorNegation(combo.get("armor_negation").getAsFloat());
                }
                if (combo.has("impact_multiplier")) {
                    child.setImpactMultiplier(combo.get("impact_multiplier").getAsFloat());
                }
                if (combo.has("can_be_interrupt")) {
                    child.setCanBeInterrupt(combo.get("can_be_interrupt").getAsBoolean());
                }
                if (combo.has("stun_type")) {
                    child.setStunTypeModifier(StunType.valueOf((String)combo.get("stun_type").getAsString()));
                }
                if (combo.has("convert_time")) {
                    child.setConvertTime(combo.get("convert_time").getAsFloat());
                }
                if (combo.has("not_charge")) {
                    child.setNotCharge(combo.get("not_charge").getAsBoolean());
                }
                if (combo.has("set_phase")) {
                    child.setNewPhase(combo.get("set_phase").getAsInt());
                }
                if (combo.has("cooldown")) {
                    child.setCooldown(combo.get("cooldown").getAsInt());
                }
                if (combo.has("conditions")) {
                    JsonArray conditionList = combo.getAsJsonArray("conditions");
                    for (JsonElement conditionElement : conditionList) {
                        JsonObject condition = conditionElement.getAsJsonObject();
                        CompoundTag tag = TagParser.m_129359_((String)condition.toString());
                        if (tag.m_128461_("predicate").isEmpty()) continue;
                        Condition predicate = MobPatchReloadListener.deserializeBehaviorPredicate((String)tag.m_128461_("predicate"), (CompoundTag)tag);
                        child.addCondition(predicate);
                    }
                }
                if (combo.has("time_command_list")) {
                    commandList = combo.getAsJsonArray("time_command_list");
                    for (JsonElement commandElement : commandList) {
                        JsonObject command = commandElement.getAsJsonObject();
                        float time = command.get("time").getAsFloat();
                        String commandText = command.get("command").getAsString();
                        boolean executeAtTarget = command.get("execute_at_target").getAsBoolean();
                        child.addTimeEvent(TimeStampedEvent.createTimeCommandEvent(time, commandText, executeAtTarget));
                    }
                }
                if (combo.has("hit_command_list")) {
                    commandList = combo.getAsJsonArray("hit_command_list");
                    for (JsonElement commandElement : commandList) {
                        JsonObject command = commandElement.getAsJsonObject();
                        String commandText = command.get("command").getAsString();
                        boolean executeAtTarget = command.get("execute_at_target").getAsBoolean();
                        child.addHitEvent(BaseEvent.createBiCommandEvent(commandText, executeAtTarget));
                    }
                }
                if (combo.has("hurt_command_list")) {
                    commandList = combo.getAsJsonArray("hurt_command_list");
                    for (JsonElement commandElement : commandList) {
                        JsonObject command = commandElement.getAsJsonObject();
                        String commandText = command.get("command").getAsString();
                        boolean executeAtTarget = command.get("execute_at_target").getAsBoolean();
                        child.addHurtEvent(BaseEvent.createBiCommandEvent(commandText, executeAtTarget));
                    }
                }
                if (combo.has("dodge_success_command_list")) {
                    commandList = combo.getAsJsonArray("dodge_success_command_list");
                    for (JsonElement commandElement : commandList) {
                        JsonObject command = commandElement.getAsJsonObject();
                        String commandText = command.get("command").getAsString();
                        boolean executeAtTarget = command.get("execute_at_target").getAsBoolean();
                        child.addDodgeSuccessEvent(BaseEvent.createBiCommandEvent(commandText, executeAtTarget));
                    }
                }
                if (combo.has("priority")) {
                    child.setPriority(combo.get("priority").getAsInt());
                    parent.addConditionNode(child);
                }
            }
            if (combo.has("combos")) {
                ComboJsonLoader.deserializeCombos(child, combo.getAsJsonArray("combos"));
            }
            if (!combo.has("key")) continue;
            String key = combo.get("key").getAsString();
            ComboNode.ComboTypes keyType = ComboNode.ComboTypes.valueOf(key);
            parent.addChild(keyType, child);
        }
    }
}

