/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.skill;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.p1nero.invincible.InvincibleConfig;
import com.p1nero.invincible.api.events.BaseEvent;
import com.p1nero.invincible.api.events.TimeStampedEvent;
import com.p1nero.invincible.api.skill.ComboNode;
import com.p1nero.invincible.capability.InvinciblePlayer;
import com.p1nero.invincible.capability.InvinciblePlayerCapabilityProvider;
import com.p1nero.invincible.gameassets.InvincibleSkillDataKeys;
import com.p1nero.invincible.skill.AbstractInvincibleInnateSkill;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class SimpleCustomInnateSkill
extends AbstractInvincibleInnateSkill {
    protected static final UUID EVENT_UUID = UUID.fromString("d1d114cc-f11f-11ed-a05b-0242ac191981");
    protected boolean shouldDrawGui;
    protected List<String> translationKeys;
    protected ResourceLocation skillTexture;
    protected ComboNode node;
    private static final Vec2f[] CLOCK_POS = new Vec2f[]{new Vec2f(0.5f, 0.5f), new Vec2f(0.5f, 0.0f), new Vec2f(0.0f, 0.0f), new Vec2f(0.0f, 1.0f), new Vec2f(1.0f, 1.0f), new Vec2f(1.0f, 0.0f)};

    public SimpleCustomInnateSkill(Builder builder) {
        super(builder);
        this.shouldDrawGui = builder.shouldDrawGui;
        this.skillTexture = builder.skillTextureLocation;
        this.node = builder.root;
        this.translationKeys = builder.translationKeys;
    }

    public static Builder createCustomInnateSkill() {
        return new Builder().setCategory((SkillCategory)SkillCategories.WEAPON_INNATE).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.NONE);
    }

    public boolean canExecute(SkillContainer container) {
        if (container.getExecutor().isLogicalClient()) {
            return super.canExecute(container);
        }
        if (((Player)container.getExecutor().getOriginal()).m_7500_()) {
            return true;
        }
        if (container.getStack() == 0 && this.getMaxStack() != 0) {
            return false;
        }
        ItemStack itemstack = ((Player)container.getExecutor().getOriginal()).m_21205_();
        return super.canExecute(container) && EpicFightCapabilities.getItemStackCapability((ItemStack)itemstack).getInnateSkill(container.getExecutor(), itemstack) == this && ((Player)container.getExecutor().getOriginal()).m_20202_() == null;
    }

    public boolean isExecutableState(PlayerPatch<?> executor) {
        return executor.getEntityState().canBasicAttack() && !((Player)executor.getOriginal()).m_5833_();
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        AnimationManager.AnimationAccessor<? extends StaticAnimation> animationAccessor = this.node.getAnimationAccessor();
        if (animationAccessor == null) {
            return;
        }
        float convertTime = this.node.getConvertTime();
        container.getExecutor().playAnimationSynchronized(animationAccessor, convertTime);
        InvinciblePlayer invinciblePlayer = InvinciblePlayerCapabilityProvider.get((Player)container.getExecutor().getOriginal());
        this.node.getOnBeginEvents().forEach(event -> event.testAndExecute(container.getExecutor(), (Entity)container.getExecutor().getTarget(), invinciblePlayer));
        this.initPlayer(container, InvinciblePlayerCapabilityProvider.get((Player)container.getServerExecutor().getOriginal()), this.node);
        this.setStackSynchronize(container, container.getStack() - 1);
    }

    private void initPlayer(SkillContainer container, InvinciblePlayer invinciblePlayer, ComboNode node) {
        invinciblePlayer.resetTimeEvents();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TimeStampedEvent event : node.getTimeEvents()) {
            event.resetExecuted();
            builder.add((Object)event);
        }
        invinciblePlayer.setTimeStampedEvents((ImmutableList<TimeStampedEvent>)builder.build());
        invinciblePlayer.setHurtEvents((ImmutableList<BaseEvent>)ImmutableList.copyOf(node.getHurtEvents()));
        invinciblePlayer.setHitSuccessEvents((ImmutableList<BaseEvent>)ImmutableList.copyOf(node.getHitEvents()));
        invinciblePlayer.setDodgeSuccessEvents((ImmutableList<BaseEvent>)ImmutableList.copyOf(node.getDodgeSuccessEvents()));
        invinciblePlayer.setCanBeInterrupt(node.isCanBeInterrupt());
        invinciblePlayer.setPlaySpeedMultiplier(node.getPlaySpeed());
        invinciblePlayer.setNotCharge(node.isNotCharge());
        if (node.getCooldown() > 0) {
            container.getDataManager().setDataSync((SkillDataKey)InvincibleSkillDataKeys.COOLDOWN.get(), (Object)node.getCooldown());
            invinciblePlayer.setItemCooldown(((Player)container.getExecutor().getOriginal()).m_21205_(), node.getCooldown());
        }
        invinciblePlayer.setArmorNegation(node.getArmorNegation());
        invinciblePlayer.setHurtDamageMultiplier(node.getHurtDamageMultiplier());
        invinciblePlayer.setDamageMultiplier(node.getDamageMultiplier());
        invinciblePlayer.setImpactMultiplier(node.getImpactMultiplier());
        invinciblePlayer.setStunTypeModifier(node.getStunTypeModifier());
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        this.resetCombo(container.getExecutor(), this.node);
        InvinciblePlayerCapabilityProvider.get((Player)container.getExecutor().getOriginal()).resetPhase();
        container.getDataManager().setData((SkillDataKey)InvincibleSkillDataKeys.COOLDOWN.get(), (Object)0);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID, event -> {
            InvinciblePlayer invinciblePlayer = InvinciblePlayerCapabilityProvider.get((Player)container.getExecutor().getOriginal());
            ImmutableList<BaseEvent> dodgeSuccessEvents = InvinciblePlayerCapabilityProvider.get((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).getDodgeSuccessEvents();
            if (dodgeSuccessEvents != null) {
                dodgeSuccessEvents.forEach(dodgeEvent -> dodgeEvent.testAndExecute(event.getPlayerPatch(), (Entity)((ServerPlayerPatch)event.getPlayerPatch()).getTarget(), invinciblePlayer));
            }
            container.getDataManager().setDataSync((SkillDataKey)InvincibleSkillDataKeys.DODGE_SUCCESS_TIMER.get(), (Object)((Integer)InvincibleConfig.EFFECT_TICK.get()));
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            InvinciblePlayer invinciblePlayer = InvinciblePlayerCapabilityProvider.get((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            DamageSource patt7999$temp = event.getDamageSource();
            if (patt7999$temp instanceof EpicFightDamageSource) {
                EpicFightDamageSource epicFightDamageSource = (EpicFightDamageSource)patt7999$temp;
                if (!invinciblePlayer.isCanBeInterrupt()) {
                    epicFightDamageSource.setStunType(StunType.NONE);
                }
            }
            if (event.isParried()) {
                container.getDataManager().setDataSync((SkillDataKey)InvincibleSkillDataKeys.PARRY_TIMER.get(), (Object)((Integer)InvincibleConfig.EFFECT_TICK.get()));
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_HURT, EVENT_UUID, event -> {
            InvinciblePlayer invinciblePlayer = InvinciblePlayerCapabilityProvider.get((Player)container.getExecutor().getOriginal());
            ImmutableList<BaseEvent> hurtEvents = InvinciblePlayerCapabilityProvider.get((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).getHurtEvents();
            if (hurtEvents != null) {
                hurtEvents.forEach(hurtEvent -> hurtEvent.testAndExecute(event.getPlayerPatch(), (Entity)((ServerPlayerPatch)event.getPlayerPatch()).getTarget(), invinciblePlayer));
            }
            if (invinciblePlayer.getHurtDamageMultiplier() != 0.0f) {
                event.attachValueModifier(ValueModifier.multiplier((float)invinciblePlayer.getHurtDamageMultiplier()));
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            InvinciblePlayer invinciblePlayer = InvinciblePlayerCapabilityProvider.get((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            if (invinciblePlayer.getStunTypeModifier() != null) {
                event.getDamageSource().setStunType(invinciblePlayer.getStunTypeModifier());
            }
            if (invinciblePlayer.getImpactMultiplier() != 1.0f) {
                event.getDamageSource().setBaseImpact(event.getDamageSource().getBaseImpact() * invinciblePlayer.getImpactMultiplier());
            }
            if (invinciblePlayer.getArmorNegation() != 0.0f) {
                event.getDamageSource().setBaseArmorNegation(invinciblePlayer.getArmorNegation());
            }
            if (invinciblePlayer.getDamageMultiplier() != null) {
                event.getDamageSource().attachDamageModifier(invinciblePlayer.getDamageMultiplier());
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID, event -> {
            float value;
            PlayerPatch playerPatch = event.getPlayerPatch();
            ItemStack mainHandItem = ((Player)playerPatch.getOriginal()).m_21205_();
            CapabilityItem capabilityItem = EpicFightCapabilities.getItemStackCapability((ItemStack)mainHandItem);
            if (capabilityItem == null || !(capabilityItem.getInnateSkill(playerPatch, mainHandItem) instanceof SimpleCustomInnateSkill)) {
                return;
            }
            if (!InvinciblePlayerCapabilityProvider.get((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).isNotCharge() && !container.isFull() && (value = container.getResource() + event.getAttackDamage()) > 0.0f) {
                this.setConsumptionSynchronize(container, value);
            }
            InvinciblePlayer invinciblePlayer = InvinciblePlayerCapabilityProvider.get((Player)container.getExecutor().getOriginal());
            ImmutableList<BaseEvent> hitEvents = InvinciblePlayerCapabilityProvider.get((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).getHitSuccessEvents();
            if (hitEvents != null) {
                hitEvents.forEach(hitEvent -> hitEvent.testAndExecute(event.getPlayerPatch(), (Entity)(event.getTarget() == null ? ((ServerPlayerPatch)event.getPlayerPatch()).getTarget() : event.getTarget()), invinciblePlayer));
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_HURT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
    }

    public void updateContainer(SkillContainer container) {
        PlayerPatch playerPatch;
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient() && container.getExecutor().getTickSinceLastAction() > (Integer)InvincibleConfig.RESET_TICK.get()) {
            this.resetCombo((PlayerPatch<?>)container.getServerExecutor(), this.node);
        }
        InvinciblePlayer invinciblePlayer = InvinciblePlayerCapabilityProvider.get((Player)container.getExecutor().getOriginal());
        SkillDataManager manager = container.getDataManager();
        if (manager.hasData((SkillDataKey)InvincibleSkillDataKeys.DODGE_SUCCESS_TIMER.get())) {
            manager.setData((SkillDataKey)InvincibleSkillDataKeys.DODGE_SUCCESS_TIMER.get(), (Object)Math.max((Integer)manager.getDataValue((SkillDataKey)InvincibleSkillDataKeys.DODGE_SUCCESS_TIMER.get()) - 1, 0));
        }
        if (manager.hasData((SkillDataKey)InvincibleSkillDataKeys.PARRY_TIMER.get())) {
            manager.setData((SkillDataKey)InvincibleSkillDataKeys.PARRY_TIMER.get(), (Object)Math.max((Integer)manager.getDataValue((SkillDataKey)InvincibleSkillDataKeys.PARRY_TIMER.get()) - 1, 0));
        }
        if ((playerPatch = container.getExecutor()) instanceof ServerPlayerPatch) {
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerPatch;
            ItemStack itemStack = ((ServerPlayer)serverPlayerPatch.getOriginal()).m_21205_();
            int currentCooldown = invinciblePlayer.getItemCooldown(itemStack);
            if (currentCooldown > 0) {
                invinciblePlayer.setItemCooldown(itemStack, --currentCooldown);
            }
            if (currentCooldown != (Integer)manager.getDataValue((SkillDataKey)InvincibleSkillDataKeys.COOLDOWN.get())) {
                manager.setDataSync((SkillDataKey)InvincibleSkillDataKeys.COOLDOWN.get(), (Object)currentCooldown);
            }
        }
    }

    public void resetCombo(PlayerPatch<?> playerPatch, ComboNode root) {
        InvinciblePlayer invinciblePlayer = InvinciblePlayerCapabilityProvider.get((Player)playerPatch.getOriginal());
        invinciblePlayer.setCurrentNode(root);
        invinciblePlayer.clear();
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        if (this.translationKeys.isEmpty()) {
            return super.getTooltipOnItem(itemStack, cap, playerpatch);
        }
        ArrayList list = Lists.newArrayList();
        for (String translationKey : this.translationKeys) {
            list.add(Component.m_237115_((String)translationKey));
        }
        return list;
    }

    public boolean shouldDraw(SkillContainer container) {
        return this.shouldDrawGui;
    }

    public ResourceLocation getSkillTexture() {
        return this.skillTexture == null ? super.getSkillTexture() : this.skillTexture;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        SkillDataManager manager;
        int stringWidth;
        int j;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        boolean creative = ((Player)container.getExecutor().getOriginal()).m_7500_();
        boolean fullstack = creative || container.isFull();
        boolean canUse = !container.isDisabled() && container.getSkill().checkExecuteCondition(container);
        float cooldownRatio = fullstack || container.isActivated() ? 1.0f : container.getResource(partialTick);
        int vertexNum = 0;
        float iconSize = 32.0f;
        float bottom = y + iconSize;
        float right = x + iconSize;
        float middle = x + iconSize * 0.5f;
        float lastVertexX = 0.0f;
        float lastVertexY = 0.0f;
        float lastTexX = 0.0f;
        float lastTexY = 0.0f;
        if (cooldownRatio < 0.125f) {
            vertexNum = 6;
            lastTexX = cooldownRatio / 0.25f;
            lastTexY = 0.0f;
            lastVertexX = middle + iconSize * lastTexX;
            lastVertexY = y;
            lastTexX += 0.5f;
        } else if (cooldownRatio < 0.375f) {
            vertexNum = 5;
            lastTexX = 1.0f;
            lastTexY = (cooldownRatio - 0.125f) / 0.25f;
            lastVertexX = right;
            lastVertexY = y + iconSize * lastTexY;
        } else if (cooldownRatio < 0.625f) {
            vertexNum = 4;
            lastTexX = (cooldownRatio - 0.375f) / 0.25f;
            lastTexY = 1.0f;
            lastVertexX = right - iconSize * lastTexX;
            lastVertexY = bottom;
            lastTexX = 1.0f - lastTexX;
        } else if (cooldownRatio < 0.875f) {
            vertexNum = 3;
            lastTexX = 0.0f;
            lastTexY = (cooldownRatio - 0.625f) / 0.25f;
            lastVertexX = x;
            lastVertexY = bottom - iconSize * lastTexY;
            lastTexY = 1.0f - lastTexY;
        } else {
            vertexNum = 2;
            lastTexX = (cooldownRatio - 0.875f) / 0.25f;
            lastTexY = 0.0f;
            lastVertexX = x + iconSize * lastTexX;
            lastVertexY = y;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)container.getSkill().getSkillTexture());
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (canUse) {
            if (container.getStack() > 0) {
                RenderSystem.setShaderColor((float)0.0f, (float)0.64f, (float)0.72f, (float)0.8f);
            } else {
                RenderSystem.setShaderColor((float)0.0f, (float)0.5f, (float)0.5f, (float)0.6f);
            }
        } else {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.6f);
        }
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85817_);
        for (j = 0; j < vertexNum; ++j) {
            bufferbuilder.m_252986_(guiGraphics.m_280168_().m_85850_().m_252922_(), x + iconSize * SimpleCustomInnateSkill.CLOCK_POS[j].x, y + iconSize * SimpleCustomInnateSkill.CLOCK_POS[j].y, 0.0f).m_7421_(SimpleCustomInnateSkill.CLOCK_POS[j].x, SimpleCustomInnateSkill.CLOCK_POS[j].y).m_5752_();
        }
        bufferbuilder.m_252986_(guiGraphics.m_280168_().m_85850_().m_252922_(), lastVertexX, lastVertexY, 0.0f).m_7421_(lastTexX, lastTexY).m_5752_();
        tessellator.m_85914_();
        if (canUse) {
            RenderSystem.setShaderColor((float)0.08f, (float)0.79f, (float)0.95f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glCullFace((int)1028);
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85817_);
        for (j = 0; j < 2; ++j) {
            bufferbuilder.m_252986_(guiGraphics.m_280168_().m_85850_().m_252922_(), x + iconSize * SimpleCustomInnateSkill.CLOCK_POS[j].x, y + iconSize * SimpleCustomInnateSkill.CLOCK_POS[j].y, 0.0f).m_7421_(SimpleCustomInnateSkill.CLOCK_POS[j].x, SimpleCustomInnateSkill.CLOCK_POS[j].y).m_5752_();
        }
        for (j = CLOCK_POS.length - 1; j >= vertexNum; --j) {
            bufferbuilder.m_252986_(guiGraphics.m_280168_().m_85850_().m_252922_(), x + iconSize * SimpleCustomInnateSkill.CLOCK_POS[j].x, y + iconSize * SimpleCustomInnateSkill.CLOCK_POS[j].y, 0.0f).m_7421_(SimpleCustomInnateSkill.CLOCK_POS[j].x, SimpleCustomInnateSkill.CLOCK_POS[j].y).m_5752_();
        }
        bufferbuilder.m_252986_(guiGraphics.m_280168_().m_85850_().m_252922_(), lastVertexX, lastVertexY, 0.0f).m_7421_(lastTexX, lastTexY).m_5752_();
        tessellator.m_85914_();
        GL11.glCullFace((int)1029);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (container.isActivated() && (container.getSkill().getActivateType() == Skill.ActivateType.DURATION || container.getSkill().getActivateType() == Skill.ActivateType.DURATION_INFINITE)) {
            String s = String.format("%.0f", Float.valueOf((float)container.getRemainDuration() / 20.0f));
            stringWidth = (gui.getFont().m_92895_(s) - 6) / 3;
            guiGraphics.drawString(gui.getFont(), s, x + 13.0f - (float)stringWidth, y + 13.0f, 0xFFFFFF, true);
        } else if (!fullstack) {
            String s = String.valueOf((int)(cooldownRatio * 100.0f));
            stringWidth = (gui.getFont().m_92895_(s) - 6) / 3;
            guiGraphics.drawString(gui.getFont(), s, x + 13.0f - (float)stringWidth, y + 13.0f, 0xFFFFFF, true);
        }
        if (container.getSkill().getMaxStack() > 1) {
            String s = String.valueOf(container.getStack());
            stringWidth = (gui.getFont().m_92895_(s) - 6) / 3;
            guiGraphics.drawString(gui.getFont(), s, x + 25.0f - (float)stringWidth, y + 22.0f, 0xFFFFFF, true);
        }
        if (!(manager = container.getDataManager()).hasData((SkillDataKey)InvincibleSkillDataKeys.COOLDOWN.get())) {
            return;
        }
        int cooldown = (Integer)manager.getDataValue((SkillDataKey)InvincibleSkillDataKeys.COOLDOWN.get());
        if (cooldown > 0) {
            Font font = gui.getFont();
            String s = String.format("%.1fs", (double)cooldown / 20.0);
            int stringWidth2 = (font.m_92895_(s) - 6) / 3;
            guiGraphics.drawString(font, s, x - (float)stringWidth2, y + 22.0f, 0xFFFFFF, true);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public static class Builder
    extends SkillBuilder<SimpleCustomInnateSkill> {
        protected ComboNode root;
        protected List<String> translationKeys = List.of();
        protected boolean shouldDrawGui;
        protected ResourceLocation skillTextureLocation;

        public Builder setCategory(SkillCategory category) {
            this.category = category;
            return this;
        }

        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }

        public Builder setCombo(ComboNode root) {
            this.root = root;
            return this;
        }

        public Builder setShouldDrawGui(boolean shouldDrawGui) {
            this.shouldDrawGui = shouldDrawGui;
            return this;
        }

        public Builder addToolTipOnItem(List<String> translationKeys) {
            this.translationKeys = translationKeys;
            return this;
        }

        public Builder setSkillTextureLocation(ResourceLocation skillTextureLocation) {
            this.skillTextureLocation = skillTextureLocation;
            return this;
        }
    }
}

