/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kc.procedures;

import net.mcreator.kc.KcMod;
import net.mcreator.kc.entity.HogKongEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class HogKongAtkCycleProcedure {
    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        HogKongAtkCycleProcedure.execute((LevelAccessor)event.getEntity().m_9236_(), (Entity)event.getEntity());
    }

    public static void execute(LevelAccessor world, Entity entity) {
        if (!(entity instanceof HogKongEntity)) {
            return;
        }
        HogKongEntity hogKong = (HogKongEntity)entity;
        if (!(hogKong instanceof Mob)) {
            return;
        }
        HogKongEntity mob = hogKong;
        if (!mob.m_5912_()) {
            return;
        }
        double tick = entity.getPersistentData().m_128459_("KcHogAtk") + 1.0;
        entity.getPersistentData().m_128347_("KcHogAtk", tick);
        switch ((int)tick) {
            case 126: {
                hogKong.setAnimation("attack_3");
                KcMod.queueServerWork(7, () -> HogKongAtkCycleProcedure.playHitSound(world, entity));
                KcMod.queueServerWork(7, () -> HogKongAtkCycleProcedure.lambda$execute$1((Mob)mob, entity));
                break;
            }
            case 48: {
                hogKong.setAnimation("attack_2");
                KcMod.queueServerWork(12, () -> HogKongAtkCycleProcedure.playHitSound(world, entity));
                break;
            }
            case 96: {
                hogKong.setAnimation("roar");
                if (hogKong instanceof LivingEntity) {
                    hogKong.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 6, false, false));
                }
                HogKongAtkCycleProcedure.playHitSound(world, entity);
                HogKongAtkCycleProcedure.applyNauseaNearby((Mob)mob);
                break;
            }
            case 192: {
                hogKong.setAnimation("ferral");
                if (hogKong.m_20160_()) break;
                if (hogKong instanceof LivingEntity) {
                    hogKong.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 6, false, false));
                }
                HogKongAtkCycleProcedure.playHitSound(world, entity);
                HogKongAtkCycleProcedure.applyNauseaNearby((Mob)mob);
                KcMod.queueServerWork(10, () -> HogKongAtkCycleProcedure.spawnFerralTornado(world, (Entity)hogKong));
                break;
            }
            case 381: {
                entity.getPersistentData().m_128347_("KcHogAtk", 0.0);
            }
        }
    }

    private static void flingTarget(Entity target, Entity source, double strength) {
        double dz;
        double dx = target.m_20185_() - source.m_20185_();
        double distance = Math.sqrt(dx * dx + (dz = target.m_20189_() - source.m_20189_()) * dz);
        if (distance == 0.0) {
            distance = 0.1;
        }
        double scale = strength / distance;
        target.m_20334_(dx * scale, 3.0, dz * scale);
    }

    private static void spawnFerralTornado(LevelAccessor world, Entity entity) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)world;
        int particleCount = 100;
        double heightStep = entity.m_20206_() / (float)particleCount;
        double radiusBase = (double)entity.m_20205_() / 2.0;
        for (int i = 0; i < particleCount; ++i) {
            double angle = (double)i * Math.PI / 8.0;
            double radius = radiusBase + Math.sin((double)i * 0.3) * 2.0;
            double px = entity.m_20185_() + Math.cos(angle) * radius;
            double py = entity.m_20186_() + (double)i * heightStep;
            double pz = entity.m_20189_() + Math.sin(angle) * radius;
            if (sLevel.f_46441_.m_188499_()) {
                sLevel.m_8767_((ParticleOptions)ParticleTypes.f_123784_, px, py, pz, 2, 0.0, 0.0, 0.0, 0.01);
                continue;
            }
            sLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, px, py, pz, 2, 0.0, 0.0, 0.0, 0.01);
        }
    }

    private static void applyNauseaNearby(Mob mob) {
        for (Entity e : mob.m_9236_().m_45933_((Entity)mob, mob.m_20191_().m_82400_(6.0))) {
            TamableAnimal tame;
            LivingEntity living;
            if (!(e instanceof LivingEntity) || (living = (LivingEntity)e) instanceof TamableAnimal && (tame = (TamableAnimal)living).m_21824_() || living == mob) continue;
            living.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 180, 1, false, false));
        }
    }

    private static void playHitSound(LevelAccessor world, Entity entity) {
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        if (!level.m_5776_()) {
            level.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("kc:kc_hit")), SoundSource.HOSTILE, 1.0f, 1.0f);
        } else {
            level.m_7785_(x, y, z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("kc:kc_hit")), SoundSource.HOSTILE, 1.0f, 1.0f, false);
        }
    }

    private static /* synthetic */ void lambda$execute$1(Mob mob, Entity entity) {
        LivingEntity target = mob.m_5448_();
        if (target != null && target.m_6084_()) {
            HogKongAtkCycleProcedure.flingTarget((Entity)target, entity, 3.0);
        }
    }
}

