/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities;

import con.sleys.lazyutilities.LazyUtilitiesMod;
import con.sleys.lazyutilities.anotations.CompatibilityRun;
import java.io.File;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public abstract class LazyUtilitiesCore {
    public static final String MODID = "lazy_utilities";
    public static final String MINECRAFT = "minecraft";
    public static final File gameDir = new File(System.getProperty("user.dir"));
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"lazy_utilities", (String)"lazy_utilities"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }

    @Deprecated(forRemoval=true, since="2.9")
    public static void CapabilityRun(Object modInstance) {
        String callBack = modInstance.getClass().getSimpleName();
        for (Method method : modInstance.getClass().getDeclaredMethods()) {
            CompatibilityRun[] annotations;
            for (CompatibilityRun annotation : annotations = (CompatibilityRun[])method.getAnnotationsByType(CompatibilityRun.class)) {
                String requiredMod = annotation.modid();
                String requiredVersion = annotation.version();
                String capVersion = annotation.versionCap();
                if (!ModList.get().isLoaded(requiredMod)) {
                    LazyUtilitiesMod.LOGGER.warn("[<CB> {}] Mod no presente: {}", (Object)callBack, (Object)requiredMod);
                    continue;
                }
                String actualVersion = ModList.get().getModContainerById(requiredMod).map(c -> c.getModInfo().getVersion().toString()).orElse("unknown");
                boolean meetsMinVersion = LazyUtilitiesCore.checkVersion(requiredVersion, actualVersion);
                boolean meetsMaxVersion = LazyUtilitiesCore.checkVersion(capVersion, actualVersion);
                if (!meetsMinVersion || !meetsMaxVersion) continue;
                try {
                    LazyUtilitiesMod.LOGGER.info("[<CB> {}] Ejecutando compatibilidad con {} [{}]", (Object)callBack, (Object)requiredMod, (Object)actualVersion);
                    method.setAccessible(true);
                    method.invoke(modInstance, new Object[0]);
                }
                catch (Exception e) {
                    LazyUtilitiesMod.LOGGER.error("[<CB> {}] Error ejecutando compatibilidad con {}", (Object)callBack, (Object)requiredMod, (Object)e);
                }
            }
        }
    }

    public static void CapabilityRun(Object modInstance, String commander) {
        for (Method method : modInstance.getClass().getDeclaredMethods()) {
            CompatibilityRun[] annotations;
            for (CompatibilityRun annotation : annotations = (CompatibilityRun[])method.getAnnotationsByType(CompatibilityRun.class)) {
                String requiredMod = annotation.modid();
                String requiredVersion = annotation.version();
                String capVersion = annotation.versionCap();
                if (!ModList.get().isLoaded(requiredMod)) {
                    LazyUtilitiesMod.LOGGER.warn("[{}] Mod no presente: {}", (Object)commander, (Object)requiredMod);
                    continue;
                }
                String actualVersion = ModList.get().getModContainerById(requiredMod).map(c -> c.getModInfo().getVersion().toString()).orElse("unknown");
                boolean meetsMinVersion = LazyUtilitiesCore.checkVersion(requiredVersion, actualVersion);
                boolean meetsMaxVersion = LazyUtilitiesCore.checkVersion(capVersion, actualVersion);
                if (!meetsMinVersion || !meetsMaxVersion) continue;
                try {
                    LazyUtilitiesMod.LOGGER.info("[{}] Ejecutando compatibilidad con {} [{}]", (Object)commander, (Object)requiredMod, (Object)actualVersion);
                    method.setAccessible(true);
                    method.invoke(modInstance, new Object[0]);
                }
                catch (Exception e) {
                    LazyUtilitiesMod.LOGGER.error("[{}] Error ejecutando compatibilidad con {}", (Object)commander, (Object)requiredMod, (Object)e);
                }
            }
        }
    }

    private static boolean checkVersion(String required, String actual) {
        if (required.equals("*")) {
            return true;
        }
        if (required.startsWith(">=")) {
            return LazyUtilitiesCore.compareVersions(actual, required.substring(2).trim()) >= 0;
        }
        if (required.startsWith("<=")) {
            return LazyUtilitiesCore.compareVersions(actual, required.substring(2).trim()) <= 0;
        }
        if (required.startsWith(">")) {
            return LazyUtilitiesCore.compareVersions(actual, required.substring(1).trim()) > 0;
        }
        if (required.startsWith("<")) {
            return LazyUtilitiesCore.compareVersions(actual, required.substring(1).trim()) < 0;
        }
        return actual.equals(required);
    }

    private static int compareVersions(String v1, String v2) {
        String[] p1 = v1.split("\\.");
        String[] p2 = v2.split("\\.");
        int length = Math.max(p1.length, p2.length);
        for (int i = 0; i < length; ++i) {
            int num2;
            int num1 = i < p1.length ? Integer.parseInt(p1[i]) : 0;
            int n = num2 = i < p2.length ? Integer.parseInt(p2[i]) : 0;
            if (num1 == num2) continue;
            return Integer.compare(num1, num2);
        }
        return 0;
    }

    public static enum ExecutionType {
        CLIENT,
        SERVER,
        BOTH;

    }
}

