/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities;

import con.sleys.lazyutilities.LazyUtilitiesCCT;
import con.sleys.lazyutilities.LazyUtilitiesCore;
import con.sleys.lazyutilities.anotations.CompatibilityRun;
import con.sleys.lazyutilities.anotations.CompatibilityRuns;
import con.sleys.lazyutilities.client.keys.LazyUtilitiesKeyBinding;
import con.sleys.lazyutilities.commands.LazyUtilitiesCommands;
import con.sleys.lazyutilities.config.LazyUtilitiesConfigClient;
import con.sleys.lazyutilities.config.LazyUtilitiesConfigCommon;
import con.sleys.lazyutilities.forgeevent.CameraControllerEvent;
import con.sleys.lazyutilities.forgeevent.RenderArmorCodexScreenEvent;
import con.sleys.lazyutilities.forgeevent.RenderArmorCodexTooltipEvent;
import con.sleys.lazyutilities.forgeevent.RenderWeaponCodexScreenEvent;
import con.sleys.lazyutilities.forgeevent.RenderWeaponCodexTooltipEvent;
import con.sleys.lazyutilities.network.CTSFocalTagSyncPacket;
import con.sleys.lazyutilities.network.CTSMessageApplyCooldown;
import con.sleys.lazyutilities.network.CTSParticlePacket;
import con.sleys.lazyutilities.network.STCFocalTagSyncPacket;
import con.sleys.lazyutilities.network.STCParticlePacket;
import con.sleys.lazyutilities.network.STCUnfocalTagSyncPacket;
import java.io.File;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lazy_utilities")
public class LazyUtilitiesMod
extends LazyUtilitiesCore {
    public static final Logger LOGGER = LogManager.getLogger(LazyUtilitiesMod.class);
    private static final String LazyUtilitiesConfigFile = "lazy_utilities/LazyUtilities-Client.toml";
    private static final String LazyUtilitiesConfigCommonFile = "lazy_utilities/LazyUtilities-Common.toml";
    private static final boolean wipConfig = false;

    public LazyUtilitiesMod(FMLJavaModLoadingContext context) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = context.getModEventBus();
        bus.addListener(this::commonSetup);
        LazyUtilitiesCCT.REGISTRY.register(bus);
        LazyUtilitiesMod.CapabilityRun(this, "Lazy Utilities");
        MinecraftForge.EVENT_BUS.register(LazyUtilitiesCommands.CommandRegistry.class);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)LazyUtilitiesConfigCommon.LAZY_UTILITIES_COMMON_CONFIG, LazyUtilitiesConfigCommonFile);
        LazyUtilitiesMod.CreatePackFolder();
        if (FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
            context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)LazyUtilitiesConfigClient.LAZY_UTILITIES_CONFIG, LazyUtilitiesConfigFile);
            context.getModEventBus().register(LazyUtilitiesKeyBinding.class);
            MinecraftForge.EVENT_BUS.register(RenderArmorCodexScreenEvent.class);
            MinecraftForge.EVENT_BUS.register(RenderArmorCodexTooltipEvent.class);
            MinecraftForge.EVENT_BUS.register(RenderWeaponCodexScreenEvent.class);
            MinecraftForge.EVENT_BUS.register(RenderWeaponCodexTooltipEvent.class);
        }
    }

    @CompatibilityRuns(value={@CompatibilityRun(modid="nimble"), @CompatibilityRun(modid="betterthirdperson"), @CompatibilityRun(modid="customcameraview")})
    private void DelegateCameraControl() {
        if (!CameraControllerEvent.DelegateCameraControl) {
            CameraControllerEvent.DelegateCameraControl = true;
        }
    }

    @CompatibilityRun(modid="shouldersurfing")
    private void DelegateCameraControlShoulder() {
        if (!CameraControllerEvent.DelegateCameraControl) {
            CameraControllerEvent.DelegateCameraControl = true;
        }
        if (!CameraControllerEvent.ShoulderSurfing) {
            CameraControllerEvent.ShoulderSurfing = true;
        }
    }

    public static void CreatePackFolder() {
        String[] subDirs;
        for (String subDir : subDirs = new String[]{"lazy_utilities", "lazy_utilities/global/datapacks", "lazy_utilities/global/resourcepacks"}) {
            File dir = new File(gameDir, subDir);
            if (dir.exists()) continue;
            dir.mkdirs();
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            LazyUtilitiesMod.addNetworkMessage(STCUnfocalTagSyncPacket.class, STCUnfocalTagSyncPacket::encode, STCUnfocalTagSyncPacket::decode, STCUnfocalTagSyncPacket::handle);
            LazyUtilitiesMod.addNetworkMessage(STCFocalTagSyncPacket.class, STCFocalTagSyncPacket::encode, STCFocalTagSyncPacket::decode, STCFocalTagSyncPacket::handle);
            LazyUtilitiesMod.addNetworkMessage(CTSFocalTagSyncPacket.class, CTSFocalTagSyncPacket::encode, CTSFocalTagSyncPacket::decode, CTSFocalTagSyncPacket::handle);
            LazyUtilitiesMod.addNetworkMessage(STCParticlePacket.class, STCParticlePacket::encode, STCParticlePacket::decode, STCParticlePacket::handle);
            LazyUtilitiesMod.addNetworkMessage(CTSParticlePacket.class, CTSParticlePacket::encode, CTSParticlePacket::decode, CTSParticlePacket::handle);
            LazyUtilitiesMod.addNetworkMessage(CTSMessageApplyCooldown.class, CTSMessageApplyCooldown::toBytes, CTSMessageApplyCooldown::new, CTSMessageApplyCooldown::handle);
        });
    }
}

