/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.client.screens;

import com.mojang.blaze3d.vertex.Tesselator;
import con.sleys.lazyutilities.client.screens.button.ButtonCodexTab;
import con.sleys.lazyutilities.client.screens.scroll.ScrollCodexPanel;
import con.sleys.lazyutilities.client.screens.tab.CodexTab;
import con.sleys.lazyutilities.client.screens.tabs.armor.ArmorAttributeTab;
import con.sleys.lazyutilities.client.screens.tabs.common.PassivesTab;
import con.sleys.lazyutilities.client.screens.tabs.common.SkillsTab;
import con.sleys.lazyutilities.interfaces.IArmorCodex;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ArmorCodexPanel
extends AbstractWidget {
    private final ItemStack stack;
    private final IArmorCodex codex;
    private final List<CodexTab> tabs = new ArrayList<CodexTab>();
    private final List<ButtonCodexTab> tabButtons = new ArrayList<ButtonCodexTab>();
    private final Minecraft minecraft;
    private int selectedTab = 0;
    private ScrollCodexPanel scrollPanel;

    public ArmorCodexPanel(int x, int y, int width, int height, ItemStack stack, IArmorCodex codex) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.stack = stack;
        this.codex = codex;
        this.minecraft = Minecraft.m_91087_();
        this.initTabs();
        this.initTabButtons();
        this.initScrollPanel();
    }

    private void initTabs() {
        this.tabs.clear();
        if (this.minecraft != null && this.minecraft.f_91074_ != null && this.stack != null) {
            this.tabs.add(new ArmorAttributeTab(this.stack, this.codex.getItemSlot(), this.codex.getCorrectionFactor(), this.codex.getItemName(this.stack), "lazy_utilities.tab.attributes"));
            if (this.codex.existSkills(this.stack)) {
                this.tabs.add(new SkillsTab(this.codex.getSkills(this.stack), "lazy_utilities.tab.weapon_skills"));
            }
            if (this.codex.existPassives(this.stack)) {
                this.tabs.add(new PassivesTab(this.codex.getPassives(this.stack), "lazy_utilities.tab.weapon_passives"));
            }
        }
    }

    private void initTabButtons() {
        this.tabButtons.clear();
        int tabButtonWidth = 20;
        int tabButtonHeight = 20;
        int tabSpacing = 5;
        for (int i = 0; i < this.tabs.size(); ++i) {
            int tabIndex = i;
            ButtonCodexTab tabButton = new ButtonCodexTab(this.m_252754_() + this.f_93618_ - 195 + 5, this.m_252907_() + i * (tabButtonHeight + tabSpacing), tabButtonWidth, tabButtonHeight, (Component)Component.m_237119_(), button -> {
                this.selectedTab = tabIndex;
                this.updateTabButtonsSelection();
                if (this.scrollPanel != null) {
                    this.scrollPanel.setScrollAmount(0.0);
                }
            }, tabIndex == this.selectedTab);
            this.tabButtons.add(tabButton);
        }
    }

    private void initScrollPanel() {
        if (!this.tabs.isEmpty()) {
            this.scrollPanel = new ScrollCodexPanel(this.minecraft, this.m_252754_() + 8, this.m_252907_() + 20, this.f_93618_ - 15, this.f_93619_ - 25, 0){

                protected void m_87963_(@NotNull GuiGraphics p_282139_, int p_268034_, int p_268009_, float p_268085_) {
                }

                protected void m_168797_(@NotNull NarrationElementOutput p_259858_) {
                }

                @Override
                public int getContentHeight() {
                    return ArmorCodexPanel.this.tabs.get(ArmorCodexPanel.this.selectedTab).getContentHeight();
                }

                @Override
                public void drawPanel(GuiGraphics gg, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
                    if (ArmorCodexPanel.this.selectedTab < ArmorCodexPanel.this.tabs.size()) {
                        ArmorCodexPanel.this.tabs.get(ArmorCodexPanel.this.selectedTab).renderContent(gg, this.m_252754_() + 10, this.m_252907_() + 35 - (int)this.scrollAmount, mouseX, mouseY);
                    }
                }
            };
        }
    }

    private void updateTabButtonsSelection() {
        for (int i = 0; i < this.tabButtons.size(); ++i) {
            this.tabButtons.get(i).setSelected(i == this.selectedTab);
        }
    }

    public void m_88315_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float partialTick) {
        if (this.tabs.isEmpty()) {
            this.initTabs();
            this.initTabButtons();
            this.initScrollPanel();
        }
        gg.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -1442840576);
        int adjustedX = this.m_252754_() + 5;
        CodexTab tab = this.tabs.get(this.selectedTab);
        Component tabKey = tab.getTitle();
        if (!tabKey.getString().isEmpty()) {
            int fontWidth = this.minecraft.f_91062_.m_92852_((FormattedText)tabKey);
            adjustedX -= fontWidth / 2;
        }
        gg.m_280430_(this.minecraft.f_91062_, tabKey, adjustedX + 75, this.m_252907_() + 6, 0xFFFFFF);
        for (ButtonCodexTab tabButton : this.tabButtons) {
            tabButton.m_88315_(gg, mouseX, mouseY, partialTick);
        }
        if (this.scrollPanel != null && this.selectedTab < this.tabs.size()) {
            this.scrollPanel.m_88315_(gg, mouseX, mouseY, partialTick);
            this.tabs.get(this.selectedTab).renderTooltips(gg, mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (ButtonCodexTab tabButton : this.tabButtons) {
            if (!tabButton.m_5953_(mouseX, mouseY)) continue;
            return tabButton.m_6375_(mouseX, mouseY, button);
        }
        if (this.scrollPanel != null && this.scrollPanel.m_5953_(mouseX, mouseY)) {
            this.tabs.get(this.selectedTab).mouseClicked(mouseX, mouseY, button);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.scrollPanel != null && this.scrollPanel.m_5953_(mouseX, mouseY)) {
            return this.scrollPanel.m_6050_(mouseX, mouseY, delta);
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    protected void m_87963_(GuiGraphics gg, int mouseX, int mouseY, float partialTick) {
    }

    protected void m_168797_(@NotNull NarrationElementOutput narration) {
    }
}

