/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.client.screens.tab;

import con.sleys.lazyutilities.client.screens.tab.CodexTab;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public abstract class WrappedTextTab
extends CodexTab {
    protected final int maxWidth;
    protected final int lineSpacing;
    protected final int paragraphSpacing;
    protected final Font font;

    public WrappedTextTab(int maxWidth, int lineSpacing, int paragraphSpacing, String tabName) {
        super((Component)Component.m_237115_((String)tabName));
        this.maxWidth = maxWidth;
        this.lineSpacing = lineSpacing;
        this.paragraphSpacing = paragraphSpacing;
        this.font = Minecraft.m_91087_().f_91062_;
    }

    protected abstract List<FormattedCharSequence> getLines();

    @Override
    public void renderContent(GuiGraphics gg, int x, int y, int mouseX, int mouseY) {
        int lineY = y - 27;
        List<FormattedCharSequence> lines = this.getLines();
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence line = lines.get(i);
            gg.m_280649_(this.font, line, x, lineY, 0xCCCCCC, false);
            lineY += this.lineSpacing;
            if (i >= lines.size() - 1 || !this.isEndOfParagraph(line)) continue;
            lineY += this.paragraphSpacing;
        }
    }

    @Override
    public int getContentHeight() {
        List<FormattedCharSequence> lines = this.getLines();
        int height = lines.size() * this.lineSpacing;
        for (int i = 0; i < lines.size() - 1; ++i) {
            if (!this.isEndOfParagraph(lines.get(i))) continue;
            height += this.paragraphSpacing;
        }
        return height + 15;
    }

    protected boolean isEndOfParagraph(FormattedCharSequence line) {
        String lineText = line.toString();
        return lineText.trim().isEmpty() || lineText.matches(".*[.!?]$") || (double)lineText.length() < (double)this.maxWidth * 0.7;
    }
}

