/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.client.shadering;

import com.mojang.blaze3d.systems.RenderSystem;
import con.sleys.lazyutilities.LazyUtilitiesMod;
import con.sleys.lazyutilities.utilities.ScreenUtilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class NoiseOverlay {
    private static PostChain noiseChain;
    private static int effectTimer;
    private static float currentIntensity;
    public static final ResourceLocation POST_CHAIN_LOCATION;

    public static void triggerNoiseEffect(int durationTicks) {
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            try {
                mc.f_91063_.m_109128_(POST_CHAIN_LOCATION);
                effectTimer = durationTicks;
                currentIntensity = 1.0f;
                PostChain actuallyEffect = mc.f_91063_.m_109149_();
                if (actuallyEffect != null && actuallyEffect.m_110022_().equals("lazy_utilities:shaders/post/noise_overlay.json")) {
                    noiseChain = actuallyEffect;
                }
            }
            catch (Exception e) {
                LazyUtilitiesMod.LOGGER.error("Failed to load impact shader", (Throwable)e);
            }
        });
    }

    public static void clearImpactFrame() {
        if (noiseChain != null) {
            noiseChain.close();
            noiseChain = null;
        }
        effectTimer = 0;
        currentIntensity = 0.0f;
    }

    public static void updateUniforms() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        PostChain chain = mc.f_91063_.m_109149_();
        if (chain == null) {
            return;
        }
        float time = mc.f_91073_.m_46467_();
        for (PostPass pass : chain.f_110009_) {
            if (!pass.m_173046_().equals("lazy_utilities:noise/noise_overlay")) continue;
            EffectInstance effect = pass.m_110074_();
            ScreenUtilities.setUniformSafe(effect, "Time", time);
            ScreenUtilities.setUniformSafe(effect, "Intensity", currentIntensity);
            ScreenUtilities.setUniformSafe(effect, "FocalUV", new float[]{0.5f, 0.5f});
            ScreenUtilities.setUniformSafe(effect, "Scale", 2.5f);
            ScreenUtilities.setUniformSafe(effect, "ColorFilter", new float[]{1.0f, 1.0f, 1.0f});
        }
    }

    static {
        POST_CHAIN_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"lazy_utilities", (String)"shaders/post/noise_overlay.json");
    }

    public static class NoiseTickEvent {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END && effectTimer > 0) {
                currentIntensity = (float)(--effectTimer) / 40.0f;
                NoiseOverlay.updateUniforms();
                if (effectTimer <= 0) {
                    NoiseOverlay.clearImpactFrame();
                }
            }
        }

        @SubscribeEvent
        public static void onRender(RenderLevelStageEvent event) {
            if (noiseChain != null && event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
                RenderSystem.disableDepthTest();
                noiseChain.m_110023_(event.getPartialTick());
                RenderSystem.enableDepthTest();
            }
        }
    }
}

