/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.client.shadering;

import com.mojang.blaze3d.systems.RenderSystem;
import con.sleys.lazyutilities.LazyUtilitiesMod;
import con.sleys.lazyutilities.utilities.ScreenUtilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RadialFastBlur {
    private static PostChain radialFastBlurChain;
    private static final ResourceLocation POST_CHAIN_LOCATION;

    public static boolean existRadialFastBlur() {
        return radialFastBlurChain != null;
    }

    public static void triggerRadialFastBlurEffect() {
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            try {
                mc.f_91063_.m_109128_(POST_CHAIN_LOCATION);
                PostChain actuallyEffect = mc.f_91063_.m_109149_();
                if (actuallyEffect != null && actuallyEffect.m_110022_().equals("lazy_utilities:shaders/post/radial_fast_blur.json")) {
                    radialFastBlurChain = actuallyEffect;
                }
            }
            catch (Exception e) {
                LazyUtilitiesMod.LOGGER.error("Failed to load impact shader", (Throwable)e);
            }
        });
    }

    public static void updateUniforms() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        PostChain chain = mc.f_91063_.m_109149_();
        if (chain == null) {
            return;
        }
        for (PostPass pass : chain.f_110009_) {
            EffectInstance effect = pass.m_110074_();
            if (pass.m_173046_().equals("lazy_utilities:radial_fast_blur/posterize_combine")) {
                ScreenUtilities.setUniformSafe(effect, "GlowIntensity", 0.04f);
                ScreenUtilities.setUniformSafe(effect, "GhostStrength", 0.9f);
                ScreenUtilities.setUniformSafe(effect, "FocalUV", new float[]{0.5f, 0.45f});
            }
            if (pass.m_173046_().equals("lazy_utilities:radial_fast_blur/radial_blur")) {
                ScreenUtilities.setUniformSafe(effect, "Strength", 0.12f);
                ScreenUtilities.setUniformSafe(effect, "Samples", 12);
                ScreenUtilities.setUniformSafe(effect, "FocalUV", new float[]{0.5f, 0.45f});
            }
            if (!pass.m_173046_().equals("lazy_utilities:radial_fast_blur/radial_mask")) continue;
            ScreenUtilities.setUniformSafe(effect, "Radius", 0.5f);
            ScreenUtilities.setUniformSafe(effect, "Feather", 0.12f);
            ScreenUtilities.setUniformSafe(effect, "AmbientBoost", 0.04f);
            ScreenUtilities.setUniformSafe(effect, "FocalUV", new float[]{0.5f, 0.45f});
        }
    }

    public static void clearRadialFastBlur() {
        if (radialFastBlurChain != null) {
            radialFastBlurChain.close();
            radialFastBlurChain = null;
        }
    }

    static {
        POST_CHAIN_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"lazy_utilities", (String)"shaders/post/radial_fast_blur.json");
    }

    public static class RadialFastBlurTickEvent {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END && radialFastBlurChain != null) {
                RadialFastBlur.updateUniforms();
            }
        }

        @SubscribeEvent
        public static void onRender(RenderLevelStageEvent event) {
            if (radialFastBlurChain != null && event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
                RenderSystem.disableDepthTest();
                radialFastBlurChain.m_110023_(event.getPartialTick());
                RenderSystem.enableDepthTest();
            }
        }
    }
}

