/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.client.shadering;

import com.mojang.blaze3d.systems.RenderSystem;
import con.sleys.lazyutilities.LazyUtilitiesMod;
import con.sleys.lazyutilities.utilities.ScreenUtilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RadialMask {
    private static PostChain radialMuskBlurChain;
    private static final ResourceLocation POST_CHAIN_LOCATION;

    public static boolean existRadialMusk() {
        return radialMuskBlurChain != null;
    }

    public static void triggerRadialMuskEffect() {
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            try {
                mc.f_91063_.m_109128_(POST_CHAIN_LOCATION);
                PostChain actuallyEffect = mc.f_91063_.m_109149_();
                if (actuallyEffect != null && actuallyEffect.m_110022_().equals("lazy_utilities:shaders/post/radial_mask.json")) {
                    radialMuskBlurChain = actuallyEffect;
                }
            }
            catch (Exception e) {
                LazyUtilitiesMod.LOGGER.error("Failed to load impact shader", (Throwable)e);
            }
        });
    }

    public static void updateUniforms() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        PostChain chain = mc.f_91063_.m_109149_();
        if (chain == null) {
            return;
        }
        for (PostPass pass : chain.f_110009_) {
            EffectInstance effect = pass.m_110074_();
            if (!pass.m_173046_().equals("lazy_utilities:radial_fast_blur/radial_mask")) continue;
            ScreenUtilities.setUniformSafe(effect, "Radius", 0.5f);
            ScreenUtilities.setUniformSafe(effect, "Feather", 0.12f);
            ScreenUtilities.setUniformSafe(effect, "AmbientBoost", 0.04f);
            ScreenUtilities.setUniformSafe(effect, "FocalUV", new float[]{0.5f, 0.45f});
        }
    }

    public static void clearRadialMusk() {
        if (radialMuskBlurChain != null) {
            radialMuskBlurChain.close();
            radialMuskBlurChain = null;
        }
    }

    static {
        POST_CHAIN_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"lazy_utilities", (String)"shaders/post/radial_mask.json");
    }

    public static class RadialMaskTickEvent {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END && radialMuskBlurChain != null) {
                RadialMask.updateUniforms();
            }
        }

        @SubscribeEvent
        public static void onRender(RenderLevelStageEvent event) {
            if (radialMuskBlurChain != null && event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
                RenderSystem.disableDepthTest();
                radialMuskBlurChain.m_110023_(event.getPartialTick());
                RenderSystem.enableDepthTest();
            }
        }
    }
}

