/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class LazyUtilitiesConfigCommon {
    public static final ForgeConfigSpec LAZY_UTILITIES_COMMON_CONFIG;
    public static final ForgeConfigSpec.EnumValue<ErrorHandler> SELECT_ERROR_HANDLER_EPICFIGHT;
    public static final ForgeConfigSpec.EnumValue<ErrorHandler> SELECT_ERROR_HANDLER_BETTERCOMBAT;
    public static final ForgeConfigSpec.EnumValue<ErrorHandler> SELECT_ERROR_HANDLER_LAZYUTILITIES;

    public static ErrorHandler getErrorHandlerLazyUtilities() {
        return (ErrorHandler)((Object)SELECT_ERROR_HANDLER_LAZYUTILITIES.get());
    }

    public static ErrorHandler getErrorHandlerEpicFight() {
        return (ErrorHandler)((Object)SELECT_ERROR_HANDLER_EPICFIGHT.get());
    }

    public static ErrorHandler getErrorHandlerBetterCombat() {
        return (ErrorHandler)((Object)SELECT_ERROR_HANDLER_BETTERCOMBAT.get());
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("Lazy Utilities - Modules -/- Main");
        SELECT_ERROR_HANDLER_LAZYUTILITIES = builder.comment("Determine how Lazy Utilities Main Module will handle errors.\n\nCATCH: Catches errors, preventing the game from closing if an error occurs. It does not provide any debugging data.\n\nEXCEPTION: Closes the game immediately upon an error. The closure is immediate and provides debugging data.").defineEnum("fatalLazyUtilitiesRuntimeHandler", (Enum)ErrorHandler.CATCH);
        builder.pop();
        builder.push("Lazy Utilities - Modules -/- Epic Fight");
        SELECT_ERROR_HANDLER_EPICFIGHT = builder.comment("Determine how the Epic Fight module (LZM: Epic Fight) will handle errors.\n\nCATCH: Catches errors, preventing the game from closing if an error occurs. It does not provide any debugging data.\n\nEXCEPTION: Closes the game immediately upon an error. The closure is immediate and provides debugging data.").defineEnum("fatalEpicFightRuntimeHandler", (Enum)ErrorHandler.CATCH);
        builder.pop();
        builder.push("Lazy Utilities - Modules -/- Better Combat");
        SELECT_ERROR_HANDLER_BETTERCOMBAT = builder.comment("Determine how the Better Combat (LZM: Better Combat) module will handle errors.\n\nCATCH: Catches errors, preventing the game from closing if an error occurs. It does not provide any debugging data.\n\nEXCEPTION: Closes the game immediately upon an error. The closure is immediate and provides debugging data.").defineEnum("fatalBetterCombatRuntimeHandler", (Enum)ErrorHandler.CATCH);
        builder.pop();
        LAZY_UTILITIES_COMMON_CONFIG = builder.build();
    }

    public static enum ErrorHandler {
        CATCH,
        EXCEPTION;

    }
}

