/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.forgeevent;

import com.github.exopandora.shouldersurfing.api.model.Perspective;
import con.sleys.lazyutilities.config.LazyUtilitiesConfigCommon;
import con.sleys.lazyutilities.utilities.BooleanUtilities;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lazy_utilities", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class CameraControllerEvent {
    public static final Map<String, ActiveTransition> activeTransitions = new HashMap<String, ActiveTransition>();
    public static Vec3 currentOffset = Vec3.f_82478_;
    public static float currentYaw = 0.0f;
    public static boolean DelegateCameraControl = false;
    public static boolean ShoulderSurfing = false;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void OnCameraEvent(CameraEvent event) {
        Perspective perspective;
        if (event.player == null) {
            return;
        }
        if (ShoulderSurfing && ((perspective = Perspective.current()) == Perspective.SHOULDER_SURFING || perspective == Perspective.THIRD_PERSON_BACK)) {
            try {
                event.camera.m_90568_(event.offset.f_82479_, event.offset.f_82480_, event.offset.f_82481_);
                event.forgeEvent.setYaw(event.forgeEvent.getYaw() + currentYaw);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (event.cameraType == CameraType.THIRD_PERSON_BACK) {
            try {
                event.camera.m_90568_(event.offset.f_82479_, event.offset.f_82480_, event.offset.f_82481_);
                event.forgeEvent.setYaw(event.forgeEvent.getYaw() + currentYaw);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public static void onCameraAnglesEvent(ViewportEvent.ComputeCameraAngles event) {
        if (LazyUtilitiesConfigCommon.getErrorHandlerLazyUtilities() != LazyUtilitiesConfigCommon.ErrorHandler.EXCEPTION) {
            try {
                CameraControllerEvent.onCameraAnglesPayload(event);
            }
            catch (Exception exception) {}
        } else {
            CameraControllerEvent.onCameraAnglesPayload(event);
        }
    }

    private static void onCameraAnglesPayload(ViewportEvent.ComputeCameraAngles event) {
        if (event.getCamera().m_90593_()) {
            CameraType cameraType = Minecraft.m_91087_().f_91066_.m_92176_();
            Camera camera = event.getCamera();
            Player player = (Player)event.getCamera().m_90592_();
            if (BooleanUtilities.isValidPlayer(player)) {
                MinecraftForge.EVENT_BUS.post((Event)new CameraEvent(player, camera, cameraType, event));
            }
        }
    }

    public static void startTransition(String id, Vec3 offset, float startYaw, float targetYaw, CameraInterpolation inInterpolation, long inTransitionTime, long holdTime, CameraInterpolation outInterpolation, long outTransitionTime, boolean isAbsolute) {
        boolean shouldApply = false;
        if (ShoulderSurfing) {
            Perspective perspective = Perspective.current();
            if (perspective == Perspective.SHOULDER_SURFING && isAbsolute) {
                shouldApply = true;
            } else if (perspective == Perspective.THIRD_PERSON_BACK) {
                shouldApply = true;
            }
        }
        if (DelegateCameraControl && isAbsolute) {
            shouldApply = true;
        }
        if (!ShoulderSurfing && !DelegateCameraControl) {
            shouldApply = true;
        }
        if (shouldApply) {
            activeTransitions.put(id, new ActiveTransition(currentOffset, offset, startYaw, targetYaw, inInterpolation, inTransitionTime, holdTime, outInterpolation, outTransitionTime));
        }
    }

    public static void endTransition(String id) {
        activeTransitions.remove(id);
    }

    public static Vec3 updateAndGetOffset() {
        long currentTime = System.currentTimeMillis();
        Vec3 totalOffset = Vec3.f_82478_;
        float totalYaw = 0.0f;
        Iterator<Map.Entry<String, ActiveTransition>> it = activeTransitions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ActiveTransition> entry = it.next();
            ActiveTransition transition = entry.getValue();
            TransitionResult result = transition.update(currentTime);
            totalOffset = totalOffset.m_82549_(result.offset);
            totalYaw += result.yaw;
            if (!transition.markedForRemoval) continue;
            it.remove();
        }
        currentOffset = totalOffset;
        currentYaw = totalYaw;
        return currentOffset;
    }

    public static class CameraEvent
    extends Event {
        private final Player player;
        private final Vec3 offset;
        private final CameraType cameraType;
        private final Camera camera;
        private final ViewportEvent.ComputeCameraAngles forgeEvent;

        public CameraEvent(Player player, Camera camera, CameraType cameraType, ViewportEvent.ComputeCameraAngles forgeEvent) {
            this.player = player;
            this.offset = CameraControllerEvent.updateAndGetOffset();
            this.cameraType = cameraType;
            this.camera = camera;
            this.forgeEvent = forgeEvent;
        }

        public Player getPlayer() {
            return this.player;
        }

        public Vec3 getOffset() {
            return this.offset;
        }

        public CameraType getCameraType() {
            return this.cameraType;
        }

        public Camera getCamera() {
            return this.camera;
        }

        public ViewportEvent.ComputeCameraAngles getForgeEvent() {
            return this.forgeEvent;
        }
    }

    public static class ActiveTransition {
        public Vec3 startOffset;
        public Vec3 targetOffset;
        public float startYaw;
        public float targetYaw;
        public CameraInterpolation inInterpolation;
        public long inTransitionTime;
        public long holdTime;
        public CameraInterpolation outInterpolation;
        public long outTransitionTime;
        public boolean markedForRemoval = false;
        public long startTime;

        public ActiveTransition(Vec3 startOffset, Vec3 targetOffset, float startYaw, float targetYaw, CameraInterpolation inInterpolation, long inTransitionTime, long holdTime, CameraInterpolation outInterpolation, long outTransitionTime) {
            this.startOffset = startOffset;
            this.targetOffset = targetOffset;
            this.startYaw = startYaw;
            this.targetYaw = targetYaw;
            this.inInterpolation = inInterpolation;
            this.inTransitionTime = inTransitionTime;
            this.holdTime = holdTime;
            this.outInterpolation = outInterpolation;
            this.outTransitionTime = outTransitionTime;
            this.startTime = System.currentTimeMillis();
        }

        public TransitionResult update(long currentTime) {
            long elapsed = currentTime - this.startTime;
            if (elapsed < this.inTransitionTime) {
                double t = Math.min(1.0, (double)elapsed / (double)this.inTransitionTime);
                double easedT = this.inInterpolation.apply(t);
                Vec3 offset = this.startOffset.m_165921_(this.targetOffset, easedT);
                float yaw = this.lerpYaw(this.startYaw, this.targetYaw, (float)easedT);
                return new TransitionResult(offset, yaw);
            }
            if (elapsed < this.inTransitionTime + this.holdTime) {
                return new TransitionResult(this.targetOffset, this.targetYaw);
            }
            long outElapsed = elapsed - (this.inTransitionTime + this.holdTime);
            if (outElapsed < this.outTransitionTime) {
                double t = Math.min(1.0, (double)outElapsed / (double)this.outTransitionTime);
                double easedT = this.outInterpolation.apply(t);
                Vec3 offset = this.targetOffset.m_165921_(Vec3.f_82478_, easedT);
                float yaw = this.lerpYaw(this.targetYaw, 0.0f, (float)easedT);
                return new TransitionResult(offset, yaw);
            }
            this.markedForRemoval = true;
            return new TransitionResult(Vec3.f_82478_, 0.0f);
        }

        private float lerpYaw(float start, float end, float t) {
            return start + (end - start) * t;
        }
    }

    public static enum CameraInterpolation {
        DIRECT,
        LINEAR,
        EASE_IN,
        EASE_OUT,
        EASE_IN_OUT;


        public double apply(double t) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case DIRECT -> 1.0;
                case LINEAR -> t;
                case EASE_IN -> t * t;
                case EASE_OUT -> 1.0 - Math.pow(1.0 - t, 2.0);
                case EASE_IN_OUT -> t < 0.5 ? 2.0 * t * t : 1.0 - Math.pow(-2.0 * t + 2.0, 2.0) / 2.0;
            };
        }
    }

    public static class TransitionResult {
        public final Vec3 offset;
        public final float yaw;

        public TransitionResult(Vec3 offset, float yaw) {
            this.offset = offset;
            this.yaw = yaw;
        }
    }
}

