/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.modules.bettercombat.forgeevent;

import con.sleys.lazyutilities.config.BetterCombatModuleConfigClient;
import con.sleys.lazyutilities.modules.bettercombat.client.LZMBetterCombatKeybinding;
import con.sleys.lazyutilities.modules.bettercombat.interfaces.IOnUltimateChargedSkill;
import con.sleys.lazyutilities.modules.bettercombat.interfaces.IOnUltimateSkill;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WeaponUltimateKeyEvent {
    private static int chargeTicks = 0;
    private static final int chargeValidTicks = 8;
    private static boolean wasPressed = false;
    private static int minCharge = 0;
    private static int fullCharge = 0;
    private static int maxCharge = 0;
    private static String skillName = "";
    private static boolean isCharging = false;
    private static boolean needExecute = false;

    public int getMinCharge() {
        return minCharge;
    }

    public static int getFullCharge() {
        return fullCharge;
    }

    public static int getMaxCharge() {
        return maxCharge;
    }

    public static String getSkillName() {
        return skillName;
    }

    @SubscribeEvent
    public static void onUltimateSkill(UltimateSkill event) {
        Item item = event.item;
        if (item instanceof IOnUltimateSkill) {
            IOnUltimateSkill ultimateSkill = (IOnUltimateSkill)item;
            ultimateSkill.onUltimateSkill(event);
        }
    }

    @SubscribeEvent
    public static void onUltimateChargedSkill(ChargedUltimateSkill event) {
        Item item = event.item;
        if (item instanceof IOnUltimateChargedSkill) {
            IOnUltimateChargedSkill ultimateChargedSkill = (IOnUltimateChargedSkill)item;
            ultimateChargedSkill.onUltimateChargedSkill(event, event.chargeTime, event.getChargeType());
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player == null || player.m_5833_() || player.m_213877_() || player.m_21224_() || !player.m_6084_()) {
            return;
        }
        if (event.side.isClient()) {
            IOnUltimateSkill skill;
            if (LZMBetterCombatKeybinding.ultimateSkillKeyBinding == null) {
                return;
            }
            boolean isPressed = LZMBetterCombatKeybinding.ultimateSkillKeyBinding.m_90857_();
            ItemStack mainHand = event.player.m_21205_();
            Item item = mainHand.m_41720_();
            if (item instanceof IOnUltimateChargedSkill) {
                IOnUltimateChargedSkill skill2 = (IOnUltimateChargedSkill)item;
                minCharge = skill2.getMinCharge();
                fullCharge = skill2.getFullCharge();
                maxCharge = skill2.getMaxCharge();
                skillName = skill2.getSkillName();
                needExecute = skill2.needExecute();
            } else if (item instanceof IOnUltimateSkill && (skill = (IOnUltimateSkill)item).needExecute()) {
                needExecute = skill.needExecute();
            }
            if (!needExecute) {
                return;
            }
            if (isPressed) {
                if (chargeTicks < maxCharge) {
                    ++chargeTicks;
                }
                wasPressed = true;
            } else if (wasPressed) {
                if (chargeTicks >= 8 + minCharge) {
                    MinecraftForge.EVENT_BUS.post((Event)new ChargedUltimateSkill(event, chargeTicks, ChargeSkillType.RELEASE));
                    isCharging = false;
                    needExecute = false;
                    skillName = "";
                } else {
                    MinecraftForge.EVENT_BUS.post((Event)new UltimateSkill(event));
                }
                chargeTicks = 0;
                wasPressed = false;
                isCharging = false;
                needExecute = false;
                skillName = "";
            }
            if (wasPressed && chargeTicks >= fullCharge && chargeTicks < maxCharge) {
                MinecraftForge.EVENT_BUS.post((Event)new ChargedUltimateSkill(event, chargeTicks, ChargeSkillType.HOLD));
                isCharging = true;
                return;
            }
            if (chargeTicks >= maxCharge) {
                MinecraftForge.EVENT_BUS.post((Event)new ChargedUltimateSkill(event, chargeTicks, ChargeSkillType.RELEASE));
                chargeTicks = 0;
                wasPressed = false;
                isCharging = false;
                needExecute = false;
                skillName = "";
                return;
            }
            if (chargeTicks > 8) {
                MinecraftForge.EVENT_BUS.post((Event)new ChargedUltimateSkill(event, chargeTicks, ChargeSkillType.HOLD));
                isCharging = true;
            }
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || player.m_5833_() || player.m_213877_() || player.m_21224_() || !player.m_6084_()) {
            return;
        }
        if (!isCharging) {
            return;
        }
        float progress = (float)chargeTicks / (float)fullCharge;
        progress = Math.min(progress, 1.0f);
        int width = 100;
        int height = 4;
        int x = (event.getWindow().m_85445_() - width - -BetterCombatModuleConfigClient.getUltimateBarX()) / 2;
        int y = event.getWindow().m_85446_() - -BetterCombatModuleConfigClient.getUltimateBarY();
        int filled = (int)((float)width * progress);
        int color = -16711936;
        if (chargeTicks >= fullCharge) {
            color = -256;
        }
        if (chargeTicks >= maxCharge) {
            color = -65536;
        }
        GuiGraphics gui = event.getGuiGraphics();
        gui.m_280509_(x, y, x + width, y + height, 0x808080);
        gui.m_280509_(x, y, x + filled, y + height, color);
        int fontWidth = mc.f_91062_.m_92895_(skillName);
        int adjustedX = x - fontWidth / 2;
        gui.m_280056_(mc.f_91062_, skillName, adjustedX - -BetterCombatModuleConfigClient.getUltimateSkillNameX(), y - -BetterCombatModuleConfigClient.getUltimateSkillNameY(), -1, true);
    }

    public static class UltimateSkill
    extends Event {
        private final Item item;
        private final LocalPlayer localCaster;
        private final TickEvent.PlayerTickEvent forgeEvent;

        public UltimateSkill(TickEvent.PlayerTickEvent event) {
            this.localCaster = (LocalPlayer)event.player;
            this.item = this.localCaster.m_21205_().m_41720_();
            this.forgeEvent = event;
        }

        public Item getItem() {
            return this.item;
        }

        public LocalPlayer getLocalCaster() {
            return this.localCaster;
        }

        public TickEvent.PlayerTickEvent getForgeEvent() {
            return this.forgeEvent;
        }
    }

    public static class ChargedUltimateSkill
    extends Event {
        private final int chargeTime;
        private final ChargeSkillType type;
        private final Item item;
        private final LocalPlayer localCaster;
        private final TickEvent.PlayerTickEvent forgeEvent;

        public ChargedUltimateSkill(TickEvent.PlayerTickEvent event, int chargeTime, ChargeSkillType type) {
            this.localCaster = (LocalPlayer)event.player;
            this.item = this.localCaster.m_21205_().m_41720_();
            this.forgeEvent = event;
            this.chargeTime = chargeTime;
            this.type = type;
        }

        public int getChargeTime() {
            return this.chargeTime;
        }

        public ChargeSkillType getChargeType() {
            return this.type;
        }

        public Item getItem() {
            return this.item;
        }

        public LocalPlayer getLocalCaster() {
            return this.localCaster;
        }

        public TickEvent.PlayerTickEvent getForgeEvent() {
            return this.forgeEvent;
        }
    }

    public static enum ChargeSkillType {
        HOLD,
        RELEASE;

    }
}

