/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.modules.bettercombat.skills;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class ArmorAbilityTagHandler {
    private final ServerPlayer player;

    public ArmorAbilityTagHandler(ServerPlayer player) {
        this.player = player;
    }

    public CompoundTag getPersistentData() {
        return this.player.getPersistentData();
    }

    public void handleAbility(String tag, boolean inCooldown, Runnable onInitiate, @Nullable Runnable onUpdate, @Nullable Runnable onRemove, @Nullable Runnable onSkillFail, @Nullable Runnable onSkillFailExecution) {
        CompoundTag data = this.getPersistentData();
        boolean activeAbility = data.m_128471_(tag);
        boolean failAbility = data.m_128471_(tag + "_fail");
        boolean failExecutionActive = data.m_128471_(tag + "_fail_execution");
        if (inCooldown) {
            if (activeAbility) {
                if (onUpdate != null) {
                    onUpdate.run();
                }
            } else {
                data.m_128379_(tag, true);
                onInitiate.run();
            }
            if (failAbility && onSkillFail != null) {
                data.m_128379_(tag + "_fail", false);
                onSkillFail.run();
            }
        } else if (activeAbility) {
            data.m_128379_(tag, false);
            data.m_128473_(tag);
            if (onRemove != null) {
                onRemove.run();
            }
        }
        if (!inCooldown && failExecutionActive && onSkillFailExecution != null) {
            data.m_128379_(tag + "_fail_execution", false);
            onSkillFailExecution.run();
        }
    }
}

