/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.modules.elements.combat.reactions;

import con.sleys.lazyutilities.config.ElementsModuleConfig;
import con.sleys.lazyutilities.modules.elements.LZElementsMod;
import con.sleys.lazyutilities.modules.elements.combat.cooldowns.ERCS;
import con.sleys.lazyutilities.modules.elements.combat.cooldowns.ERGCS;
import con.sleys.lazyutilities.modules.elements.init.ElementsList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ElementalReactions {
    public static final Logger LOGGER = LogManager.getLogger(LZElementsMod.class);
    static int INSTA_REACTION = 10;
    static int NO_RETURN = 0;
    public static final Map<Element, Map<Element, Reaction>> REACTIONS = new HashMap<Element, Map<Element, Reaction>>();

    public static void applyReaction(LivingEntity entity, Element first, Element second) {
        Reaction reaction = ElementalReactions.getReaction(first, second);
        if (reaction != null) {
            UUID entityId = entity.m_20148_();
            if (!ERGCS.isBlocked(entityId) && !entity.m_21023_((MobEffect)ElementsList.REACTIONS_SHIELD.get())) {
                if (ERCS.canReact(entityId, reaction)) {
                    entity.m_7292_(reaction.createEffectInstance(reaction.reactionDuration));
                    if (reaction.resultingElement != null) {
                        entity.m_7292_(reaction.createEffectInstance(reaction.resultingElementDuration));
                    }
                    if (ElementsModuleConfig.isDepurateReactions()) {
                        LOGGER.info("[Reactions Matrix] Aplicando reacci\u00f3n: " + String.valueOf((Object)first) + " + " + String.valueOf((Object)second) + " -> " + reaction.effectSupplier.get().m_19481_() + " con duraci\u00f3n de reacci\u00f3n: " + reaction.reactionDuration + " y duraci\u00f3n del elemento resultante: " + reaction.resultingElementDuration);
                    }
                    ERCS.applyCooldown(entityId, reaction);
                    ERGCS.addReaction(entityId, reaction);
                } else if (ElementsModuleConfig.isDepurateReactions()) {
                    LOGGER.info("[Reactions Matrix] Reacci\u00f3n en cooldown: " + String.valueOf((Object)first) + " + " + String.valueOf((Object)second));
                }
            } else {
                if (ElementsModuleConfig.isDepurateReactions()) {
                    LOGGER.info("[Reactions Matrix] En Cooldown Global");
                    LOGGER.info("[Reactions Matrix] Condici\u00f3n de cooldown global: " + String.valueOf(ERGCS.ergcs_globalCooldowns.getOrDefault(entityId, 0)));
                }
                if (!entity.m_21023_((MobEffect)ElementsList.REACTIONS_SHIELD.get())) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)ElementsList.REACTIONS_SHIELD.get(), 400, 0, false, true, false));
                }
            }
        }
    }

    public static Reaction getReaction(Element first, Element second) {
        return (Reaction)REACTIONS.getOrDefault((Object)first, Map.of()).get((Object)second);
    }

    static {
        REACTIONS.put(Element.PYRO, Map.of(Element.HYDRO, new Reaction(() -> ElementsList.VAPORIZED.get(), Element.HYDRO, INSTA_REACTION, 100), Element.GEO, new Reaction(() -> ElementsList.BURNING.get(), Element.PYRO, 140, 60), Element.CRYO, new Reaction(() -> ElementsList.MELTED.get(), null, INSTA_REACTION, NO_RETURN), Element.ELECTRO, new Reaction(() -> ElementsList.OVERLOAD.get(), null, INSTA_REACTION, NO_RETURN)));
        REACTIONS.put(Element.HYDRO, Map.of(Element.PYRO, new Reaction(() -> ElementsList.VAPORIZED.get(), null, INSTA_REACTION, NO_RETURN), Element.GEO, new Reaction(() -> ElementsList.ROOTED.get(), null, 200, NO_RETURN), Element.CRYO, new Reaction(() -> ElementsList.FROZEN.get(), Element.CRYO, INSTA_REACTION, 100), Element.ELECTRO, new Reaction(() -> ElementsList.ELECTROCHARGED.get(), Element.ELECTRO, 260, 160)));
        REACTIONS.put(Element.GEO, Map.of(Element.PYRO, new Reaction(() -> ElementsList.BURNING.get(), null, 180, NO_RETURN), Element.HYDRO, new Reaction(() -> ElementsList.ROOTED.get(), null, 260, NO_RETURN), Element.CRYO, new Reaction(() -> ElementsList.COLD.get(), null, 200, NO_RETURN), Element.ELECTRO, new Reaction(() -> ElementsList.CONDUCTOR.get(), null, 220, NO_RETURN)));
        REACTIONS.put(Element.CRYO, Map.of(Element.PYRO, new Reaction(() -> ElementsList.MELTED.get(), Element.PYRO, INSTA_REACTION, 60), Element.HYDRO, new Reaction(() -> ElementsList.FROZEN.get(), Element.CRYO, INSTA_REACTION, 100), Element.GEO, new Reaction(() -> ElementsList.COLD.get(), Element.CRYO, 180, 100), Element.ELECTRO, new Reaction(() -> ElementsList.SUPERCONDUCTOR.get(), null, 220, NO_RETURN)));
        REACTIONS.put(Element.ELECTRO, Map.of(Element.PYRO, new Reaction(() -> ElementsList.OVERLOAD.get(), null, INSTA_REACTION, NO_RETURN), Element.HYDRO, new Reaction(() -> ElementsList.ELECTROCHARGED.get(), Element.ELECTRO, 260, 160), Element.GEO, new Reaction(() -> ElementsList.CONDUCTOR.get(), null, 220, NO_RETURN), Element.CRYO, new Reaction(() -> ElementsList.SUPERCONDUCTOR.get(), null, 220, NO_RETURN)));
    }

    public static enum Element {
        PYRO,
        HYDRO,
        GEO,
        CRYO,
        ELECTRO;

    }

    public static class Reaction {
        public final Supplier<MobEffect> effectSupplier;
        public final Element resultingElement;
        public final int reactionDuration;
        public final int resultingElementDuration;

        public Reaction(Supplier<MobEffect> effectSupplier, Element resultingElement, int reactionDuration, int resultingElementDuration) {
            this.effectSupplier = effectSupplier;
            this.resultingElement = resultingElement;
            this.reactionDuration = reactionDuration;
            this.resultingElementDuration = resultingElementDuration;
        }

        public MobEffectInstance createEffectInstance(int duration) {
            MobEffect effect = this.effectSupplier.get();
            return new MobEffectInstance(effect, duration);
        }
    }
}

