/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.modules.elements.combat.reactions;

import con.sleys.lazyutilities.config.ElementsModuleConfig;
import con.sleys.lazyutilities.modules.elements.LZElementsMod;
import con.sleys.lazyutilities.modules.elements.combat.reactions.ElementalReactions;
import con.sleys.lazyutilities.modules.elements.init.ElementsList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ElementalStatusManager {
    public static final Logger LOGGER = LogManager.getLogger(LZElementsMod.class);
    private static final String ELEMENT_TAG = "ElementalPrimerizo";
    private static final String USED_ELEMENT_TAG = "ElementoPrimerizoUsado";

    public static void applyElement(LivingEntity entity, ElementalReactions.Element element) {
        if (!ElementsModuleConfig.isAllowReactions()) {
            return;
        }
        CompoundTag tag = entity.getPersistentData();
        if (ElementsModuleConfig.isDepurateReactions()) {
            LOGGER.info("[Reactions] Condicion preterica: " + entity.m_7755_().getString() + " -> NBT: " + String.valueOf(tag));
        }
        if (tag.m_128441_(ELEMENT_TAG)) {
            ElementalReactions.Element previous = ElementalReactions.Element.valueOf(tag.m_128461_(ELEMENT_TAG));
            ElementalReactions.Reaction reaction = ElementalReactions.getReaction(previous, element);
            if (reaction != null) {
                if (ElementsModuleConfig.isDepurateReactions()) {
                    LOGGER.info("[Reactions] Se activ\u00f3 la reacci\u00f3n: " + reaction.effectSupplier.get().m_19481_());
                }
                ElementalReactions.applyReaction(entity, previous, element);
                if (reaction.resultingElement != null) {
                    tag.m_128359_(ELEMENT_TAG, reaction.resultingElement.name());
                    if (ElementsModuleConfig.isDepurateReactions()) {
                        LOGGER.info("[Reactions] Elemento cambiado a: " + reaction.resultingElement.name());
                    }
                    if (reaction.resultingElement != previous) {
                        ElementalStatusManager.removeElementEffect(entity, previous);
                    }
                    if (reaction.resultingElement != element) {
                        ElementalStatusManager.removeElementEffect(entity, element);
                    }
                } else {
                    ElementalStatusManager.removeElementEffect(entity, previous);
                    ElementalStatusManager.removeElementEffect(entity, element);
                    Object usedElements = tag.m_128461_(USED_ELEMENT_TAG);
                    if (!((String)usedElements).isEmpty()) {
                        usedElements = (String)usedElements + ",";
                    }
                    usedElements = (String)usedElements + tag.m_128461_(ELEMENT_TAG);
                    tag.m_128359_(USED_ELEMENT_TAG, (String)usedElements);
                    tag.m_128473_(ELEMENT_TAG);
                    if (ElementsModuleConfig.isDepurateReactions()) {
                        LOGGER.info("[Reactions] Elemento marcado como usado y movido a 'ElementoPrimerizoUsado'.");
                    }
                }
            }
        } else {
            tag.m_128359_(ELEMENT_TAG, element.name());
            if (ElementsModuleConfig.isDepurateReactions()) {
                LOGGER.info("[Reactions] Elemento asignado: " + element.name());
            }
        }
        LOGGER.info("[Reactions] Condicion actual: " + entity.m_7755_().getString() + " -> NBT: " + String.valueOf(tag));
    }

    private static void removeElementEffect(LivingEntity entity, ElementalReactions.Element element) {
        MobEffect effect = ElementalStatusManager.getEffectForElement(element);
        if (effect != null) {
            entity.m_21195_(effect);
            LOGGER.info("[Reactions] Eliminado efecto: " + effect.m_19481_());
        }
    }

    private static MobEffect getEffectForElement(ElementalReactions.Element element) {
        switch (element) {
            case PYRO: {
                return (MobEffect)ElementsList.PYRO.get();
            }
            case HYDRO: {
                return (MobEffect)ElementsList.HYDRO.get();
            }
            case GEO: {
                return (MobEffect)ElementsList.GEO.get();
            }
            case CRYO: {
                return (MobEffect)ElementsList.CRYO.get();
            }
            case ELECTRO: {
                return (MobEffect)ElementsList.ELECTRO.get();
            }
        }
        return null;
    }
}

