/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.modules.epicfight.forgeevents;

import con.sleys.lazyutilities.config.LazyUtilitiesConfigCommon;
import con.sleys.lazyutilities.network.CTSFocalTagSyncSender;
import con.sleys.lazyutilities.utilities.BooleanUtilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class EpicFightAFKEvent {
    private static int TICK_COUNTER = 0;
    private static int COUNTERS_SEND_PACKETS = 0;
    private static final int SEND_PACKET_THRESHOLD = 30;
    private static final String TAG_AFK_IS_AFK = "lzm_epicfight.key.afk.is_afk";
    private static final String TAG_AFK_NEED_COUNTING = "lzm_epicfight.key.afk.need_know";
    private static final String TAG_AFK_WAS_AFK = "lzm_epicfight.key.afk.was_afk";

    public static String getTagAfkIsAFK() {
        return TAG_AFK_IS_AFK;
    }

    public static String getAfkNeedCounting() {
        return TAG_AFK_NEED_COUNTING;
    }

    public static String getTagAfkWasAFK() {
        return TAG_AFK_WAS_AFK;
    }

    @SubscribeEvent
    public static void playerClientTickEvent(TickEvent.ClientTickEvent event) {
        if (LazyUtilitiesConfigCommon.getErrorHandlerEpicFight() != LazyUtilitiesConfigCommon.ErrorHandler.EXCEPTION) {
            try {
                EpicFightAFKEvent.playerTickClientPayload(event);
            }
            catch (Exception exception) {}
        } else {
            EpicFightAFKEvent.playerTickClientPayload(event);
        }
    }

    private static void playerTickClientPayload(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || ++TICK_COUNTER % 15 != 0) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        PlayerPatch<?> patch = BooleanUtilities.safeParametricePlayerPatchTickEvent(event, (Player)player);
        if (patch == null) {
            return;
        }
        CompoundTag clientData = player.getPersistentData();
        if (!clientData.m_128471_(TAG_AFK_NEED_COUNTING)) {
            return;
        }
        if (COUNTERS_SEND_PACKETS < 30) {
            ++COUNTERS_SEND_PACKETS;
        }
        boolean isAFK = clientData.m_128471_(TAG_AFK_IS_AFK);
        boolean playerAfk = EpicFightAFKEvent.isPlayerAfk((Player)player, mc, patch);
        if (playerAfk && COUNTERS_SEND_PACKETS >= 30 && !isAFK) {
            clientData.m_128379_(TAG_AFK_IS_AFK, true);
            CTSFocalTagSyncSender.sendBoolean(TAG_AFK_IS_AFK, true);
        } else if (!playerAfk && isAFK) {
            COUNTERS_SEND_PACKETS = 0;
            clientData.m_128379_(TAG_AFK_IS_AFK, false);
            CTSFocalTagSyncSender.sendBoolean(TAG_AFK_IS_AFK, false);
        }
    }

    private static boolean isPlayerAfk(Player player, Minecraft mc, PlayerPatch<?> patch) {
        return patch.getCurrentLivingMotion() == LivingMotions.IDLE && !mc.f_91066_.f_92096_.m_90857_() && !mc.f_91066_.f_92095_.m_90857_() && mc.f_91080_ == null && player.m_20184_().m_165925_() <= 0.001 && !mc.m_91104_();
    }
}

