/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.modules.epicfight.forgeevents;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class InnateSkillListenerEvent {
    private static final Set<Skill> WATCHED_SKILLS = new HashSet<Skill>();

    public static void registerSkillToWatch(Skill skill) {
        WATCHED_SKILLS.add(skill);
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!player.m_6084_() || player.m_213877_() || player.m_5833_()) {
            return;
        }
        PlayerPatch patch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        if (patch == null) {
            return;
        }
        WATCHED_SKILLS.forEach(skill -> {
            SkillContainer skillContainer = patch.getSkill(skill);
            if (skillContainer == null) {
                return;
            }
            boolean isActive = skillContainer.isActivated();
            if (isActive) {
                MinecraftForge.EVENT_BUS.post((Event)new SkillActivedEvent(player, skillContainer));
            } else {
                MinecraftForge.EVENT_BUS.post((Event)new SkillDeactivatedEvent(player, skillContainer));
            }
        });
    }

    public static class SkillActivedEvent
    extends Event {
        private final Player player;
        private final SkillContainer skillContainer;
        private final Skill skill;

        public SkillActivedEvent(Player player, SkillContainer skillContainer) {
            this.player = player;
            this.skillContainer = skillContainer;
            this.skill = skillContainer.getSkill();
        }

        public Player getPlayer() {
            return this.player;
        }

        public PlayerPatch<?> getPlayerPatch() {
            return (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)this.getPlayer(), PlayerPatch.class);
        }

        public SkillContainer getSkillContainer() {
            return this.skillContainer;
        }

        public Skill getSkill() {
            return this.skillContainer.getSkill();
        }
    }

    public static class SkillDeactivatedEvent
    extends Event {
        private final Player player;
        private final SkillContainer skillContainer;
        private final Skill skill;

        public SkillDeactivatedEvent(Player player, SkillContainer skillContainer) {
            this.player = player;
            this.skillContainer = skillContainer;
            this.skill = skillContainer.getSkill();
        }

        public Player getPlayer() {
            return this.player;
        }

        public PlayerPatch<?> getPlayerPatch() {
            return (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)this.getPlayer(), PlayerPatch.class);
        }

        public SkillContainer getSkillContainer() {
            return this.skillContainer;
        }

        public Skill getSkill() {
            return this.skillContainer.getSkill();
        }
    }
}

