/*
 * Decompiled with CFR 0.152.
 */
package con.sleys.lazyutilities.modules.epicfight.forgeevents;

import con.sleys.lazyutilities.modules.epicfight.interfaces.IAnticipationState;
import con.sleys.lazyutilities.modules.epicfight.interfaces.IAttackState;
import con.sleys.lazyutilities.modules.epicfight.interfaces.IEntityState;
import con.sleys.lazyutilities.modules.epicfight.interfaces.IRecoveryState;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class PlayerAttackEvent {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEpicAttackState(EFAttackInteractionState event) {
        ItemStack playerItem = event.player.m_21205_();
        EntityStateTracker.update(event.player, event.playerPatch.getEntityState().getLevel());
        Item item = playerItem.m_41720_();
        if (item instanceof IEntityState) {
            IEntityState interactionType = (IEntityState)item;
            interactionType.AttackInteractionState(event.playerPatch, event.player, event.state);
        }
        if (event.prevState == 0 && event.prevState < event.state && (item = playerItem.m_41720_()) instanceof IAnticipationState) {
            IAnticipationState anticipation = (IAnticipationState)item;
            anticipation.AnticipationState(event.playerPatch, event.player, true);
        }
        if (event.prevState == 1 && event.prevState < event.state && (item = playerItem.m_41720_()) instanceof IAttackState) {
            IAttackState attack = (IAttackState)item;
            attack.AttackState(event.playerPatch, event.player, true);
        }
        if (event.prevState == 2 && event.prevState < event.state && (item = playerItem.m_41720_()) instanceof IRecoveryState) {
            IRecoveryState recovery = (IRecoveryState)item;
            recovery.RecoveryState(event.playerPatch, event.player, true);
        }
    }

    public static boolean isTrustedPatchItem(TickEvent.PlayerTickEvent event) {
        Item item = event.player.m_21205_().m_41720_();
        return Stream.of(IEntityState.class, IAnticipationState.class, IAttackState.class, IRecoveryState.class).anyMatch(clazz -> clazz.isInstance(item));
    }

    public static class EFAttackInteractionState
    extends Event {
        private final PlayerPatch<?> playerPatch;
        private final Player player;
        private final int state;
        private final int prevState;
        private final TickEvent.PlayerTickEvent forgeEvent;

        public EFAttackInteractionState(PlayerPatch<?> playerPatch, int prevState, TickEvent.PlayerTickEvent forgeEvent) {
            this.playerPatch = playerPatch;
            this.player = (Player)playerPatch.getOriginal();
            this.state = playerPatch.getEntityState().getLevel();
            this.prevState = prevState;
            this.forgeEvent = forgeEvent;
        }

        public PlayerPatch<?> getPlayerPatch() {
            return this.playerPatch;
        }

        public Player getPlayer() {
            return this.player;
        }

        public int getState() {
            return this.state;
        }

        public int getPrevState() {
            return this.prevState;
        }

        public TickEvent.PlayerTickEvent getForgeEvent() {
            return this.forgeEvent;
        }
    }

    public static class EntityStateTracker {
        private static final Map<UUID, Integer> lastStates = new HashMap<UUID, Integer>();

        public static int getPrevious(Player player) {
            return lastStates.getOrDefault(player.m_20148_(), -1);
        }

        public static void update(Player player, int newState) {
            lastStates.put(player.m_20148_(), newState);
        }
    }
}

